The `VAETrainer` is configured such that you can run `train_vae.py` on the cluster or locally. To modify the resources for SLURM, change your desired config inside of the [cluster folder](../../global_configs/cluster/).

### Training

Run: 

```
python train_vae.py
```

You may optionally pass `dataset=<DATASET_NAME>` to the script. A list of dataset names can be found in the [dataset folder](../../global_configs/dataset/).

Note: We recommend not specifying a `wandb.project` in hydra to take advantage of the automatic naming feature, which is used for checkpoint files and the wandb project. However, you may use a custom configuration (ignored by git) inside of the [wandb folder](../../global_configs/wandb). 

### Creating a sweep

First, create a `.yaml` sweep config file inside of the [create_sweep folder](configs/create_sweep). See the wandb documentation for more information on how to define a sweep config. 

For example, you may modify the [default.yaml](configs/create_sweep/default.yaml). Then run:

```
python train_vae.py create_sweep=default
```


### Submit the sweep

First, create a `.yaml` file inside of the [run_sweep folder](configs/run_sweep). Use the information from the sweep agent to fill in this file.

For example, you may modify the [default.yaml](configs/run_sweep/default.yaml). Then run:

```
python train_vae.py run_sweep=default
```

To launch multiple sweep agents at once (for example, if we want 10 agents), you may run:

```
python train_vae.py -m train.seed=$(seq -s, 0 9) run_sweep=default
```

Note that any hydra configurations besides `cluster` and `run_sweep` will be ignored because the configuration for the created sweep agent is loaded.