import matplotlib.pyplot as plt

# Data for Model 1
JPEG = [(1.6329752604166667, 21.592859268188477, 6.247324281192246), (1.7076416015625, 21.8941650390625, 6.558529135248821), (1.9853515625, 24.12175178527832, 8.256704241667741), (2.2687784830729165, 25.59046745300293, 9.54304256122105), (2.5380045572916665, 26.58952522277832, 10.47696077658586), (2.7950236002604165, 27.349275588989258, 11.247294203326604), (3.0426025390625, 28.01014518737793, 11.949168503872057), (3.26763916015625, 28.48687744140625, 12.473250879010342), (3.4890543619791665, 28.90785789489746, 12.964876460909423), (3.6920979817708335, 29.258567810058594, 13.377079982987707), (3.89593505859375, 29.630659103393555, 13.785932176117617), (4.09063720703125, 29.905126571655273, 14.132845191376532), (4.270182291666667, 30.180307388305664, 14.491344196685205), (4.4556884765625, 30.43315887451172, 14.797701545016146), (4.630879720052083, 30.637731552124023, 15.024978468083113)]

# Data for Model 2
MCUCoder = [(0.525319169207317, 19.54656219482422, 7.500289911717172), (1.0012385670731707, 23.899906158447266, 10.29905192489089), (1.440382050304878, 25.31182098388672, 11.698889106743271), (1.8488233612804879, 26.111013412475586, 12.753833706410827), (2.241544397865854, 26.548654556274414, 13.381615602763382), (2.6124714176829267, 26.912294387817383, 13.945480864401416), (2.9751572027439024, 27.247365951538086, 14.40205078296529), (3.347727705792683, 27.569122314453125, 14.817161721637817), (3.7068407012195124, 27.825376510620117, 15.156918984059129), (4.078934832317073, 28.011526107788086, 15.450441339810471), (4.411799733231708, 28.17641258239746, 15.656939590169772), (4.654082507621951, 28.257036209106445, 15.810085337903864)]

# Unpacking the data
image_size_1, psnr_1, msssim_1 = zip(*JPEG)
image_size_2, psnr_2, msssim_2 = zip(*MCUCoder)

# Plotting PSNR
plt.figure()
plt.plot(image_size_1, psnr_1, color='tab:blue', marker='o', label='JPEG PSNR')
plt.plot(image_size_2, psnr_2, color='tab:blue', linestyle='--', marker='x', label='MCUCoder PSNR')
plt.xlabel('Image Size (KB)')
plt.ylabel('PSNR (dB)')
plt.title('Image Size vs PSNR on KODAK')
plt.legend()
plt.savefig('psnr_plot.png')
plt.show()

# Plotting MS-SSIM
plt.figure()
plt.plot(image_size_1, msssim_1, color='tab:green', marker='s', label='JPEG MS-SSIM')
plt.plot(image_size_2, msssim_2, color='tab:green', linestyle='--', marker='d', label='MCUCoder MS-SSIM')
plt.xlabel('Image Size (KB)')
plt.ylabel('MS-SSIM (dB)')
plt.title('Image Size vs MS-SSIM on KODAK')
plt.legend()
plt.savefig('msssim_plot.png')
plt.show()
