import py7zr
import os

# Directory containing .7z files
download_dir = '/data22/aho/UVG_dataset/download'

# Extract all .7z files in the directory
for filename in os.listdir(download_dir):
    if filename.endswith('.7z'):
        file_path = os.path.join(download_dir, filename)
        try:
            with py7zr.SevenZipFile(file_path, mode='r') as archive:
                archive.extractall(path=download_dir)
            print(f"Successfully extracted {filename}")
        except py7zr.exceptions.Bad7zFile:
            print(f"Skipping {filename}: not a valid .7z file")
        except Exception as e:
            print(f"Error extracting {filename}: {e}")