# coding=utf-8
# Copyright 2024 The HuggingFace Inc. team.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     XXXX
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
from collections import OrderedDict

from ...utils import logging


logger = logging.get_logger(__name__)


class DeprecatedDict(dict):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

    def __getitem__(self, item):
        logger.warning(
            "Archive maps are deprecated and will be removed in version v4.40.0 as they are no longer relevant. "
            "If looking to get all checkpoints for a given architecture, we recommend using `huggingface_hub` "
            "with the list_models method."
        )
        return self[item]


class DeprecatedList(list):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

    def __getitem__(self, item):
        logger.warning_once(
            "Archive maps are deprecated and will be removed in version v4.40.0 as they are no longer relevant. "
            "If looking to get all checkpoints for a given architecture, we recommend using `huggingface_hub` "
            "with the `list_models` method."
        )
        return super().__getitem__(item)


ALBERT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "albert/albert-base-v1": "XXXX",
        "albert/albert-large-v1": "XXXX",
        "albert/albert-xlarge-v1": "XXXX",
        "albert/albert-xxlarge-v1": "XXXX",
        "albert/albert-base-v2": "XXXX",
        "albert/albert-large-v2": "XXXX",
        "albert/albert-xlarge-v2": "XXXX",
        "albert/albert-xxlarge-v2": "XXXX",
    }
)

ALBERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "albert/albert-base-v1",
        "albert/albert-large-v1",
        "albert/albert-xlarge-v1",
        "albert/albert-xxlarge-v1",
        "albert/albert-base-v2",
        "albert/albert-large-v2",
        "albert/albert-xlarge-v2",
        "albert/albert-xxlarge-v2",
    ]
)

TF_ALBERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "albert/albert-base-v1",
        "albert/albert-large-v1",
        "albert/albert-xlarge-v1",
        "albert/albert-xxlarge-v1",
        "albert/albert-base-v2",
        "albert/albert-large-v2",
        "albert/albert-xlarge-v2",
        "albert/albert-xxlarge-v2",
    ]
)

ALIGN_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"kakaobrain/align-base": "XXXX"}
)

ALIGN_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["kakaobrain/align-base"])

ALTCLIP_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"BAAI/AltCLIP": "XXXX"}
)

ALTCLIP_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["BAAI/AltCLIP"])

AUDIO_SPECTROGRAM_TRANSFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "MIT/ast-finetuned-audioset-10-10-0.4593": "XXXX"
    }
)

AUDIO_SPECTROGRAM_TRANSFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["MIT/ast-finetuned-audioset-10-10-0.4593"]
)

AUTOFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "huggingface/autoformer-tourism-monthly": "XXXX"
    }
)

AUTOFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["huggingface/autoformer-tourism-monthly"])

BARK_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["suno/bark-small", "suno/bark"])

BART_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/bart-large"])

BEIT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "microsoft/beit-base-patch16-224-pt22k": "XXXX"
    }
)

BEIT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/beit-base-patch16-224"])

BERT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "XXXX-7-bert/bert-base-uncased": "XXXX",
        "XXXX-7-bert/bert-large-uncased": "XXXX",
        "XXXX-7-bert/bert-base-cased": "XXXX",
        "XXXX-7-bert/bert-large-cased": "XXXX",
        "XXXX-7-bert/bert-base-multilingual-uncased": "XXXX",
        "XXXX-7-bert/bert-base-multilingual-cased": "XXXX",
        "XXXX-7-bert/bert-base-chinese": "XXXX",
        "XXXX-7-bert/bert-base-german-cased": "XXXX",
        "XXXX-7-bert/bert-large-uncased-whole-word-masking": "XXXX",
        "XXXX-7-bert/bert-large-cased-whole-word-masking": "XXXX",
        "XXXX-7-bert/bert-large-uncased-whole-word-masking-finetuned-squad": "XXXX",
        "XXXX-7-bert/bert-large-cased-whole-word-masking-finetuned-squad": "XXXX",
        "XXXX-7-bert/bert-base-cased-finetuned-mrpc": "XXXX",
        "XXXX-7-bert/bert-base-german-dbmdz-cased": "XXXX",
        "XXXX-7-bert/bert-base-german-dbmdz-uncased": "XXXX",
        "cl-tohoku/bert-base-japanese": "XXXX",
        "cl-tohoku/bert-base-japanese-whole-word-masking": "XXXX",
        "cl-tohoku/bert-base-japanese-char": "XXXX",
        "cl-tohoku/bert-base-japanese-char-whole-word-masking": "XXXX",
        "TurkuNLP/bert-base-finnish-cased-v1": "XXXX",
        "TurkuNLP/bert-base-finnish-uncased-v1": "XXXX",
        "wietsedv/bert-base-dutch-cased": "XXXX",
    }
)

BERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "XXXX-7-bert/bert-base-uncased",
        "XXXX-7-bert/bert-large-uncased",
        "XXXX-7-bert/bert-base-cased",
        "XXXX-7-bert/bert-large-cased",
        "XXXX-7-bert/bert-base-multilingual-uncased",
        "XXXX-7-bert/bert-base-multilingual-cased",
        "XXXX-7-bert/bert-base-chinese",
        "XXXX-7-bert/bert-base-german-cased",
        "XXXX-7-bert/bert-large-uncased-whole-word-masking",
        "XXXX-7-bert/bert-large-cased-whole-word-masking",
        "XXXX-7-bert/bert-large-uncased-whole-word-masking-finetuned-squad",
        "XXXX-7-bert/bert-large-cased-whole-word-masking-finetuned-squad",
        "XXXX-7-bert/bert-base-cased-finetuned-mrpc",
        "XXXX-7-bert/bert-base-german-dbmdz-cased",
        "XXXX-7-bert/bert-base-german-dbmdz-uncased",
        "cl-tohoku/bert-base-japanese",
        "cl-tohoku/bert-base-japanese-whole-word-masking",
        "cl-tohoku/bert-base-japanese-char",
        "cl-tohoku/bert-base-japanese-char-whole-word-masking",
        "TurkuNLP/bert-base-finnish-cased-v1",
        "TurkuNLP/bert-base-finnish-uncased-v1",
        "wietsedv/bert-base-dutch-cased",
    ]
)

TF_BERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "XXXX-7-bert/bert-base-uncased",
        "XXXX-7-bert/bert-large-uncased",
        "XXXX-7-bert/bert-base-cased",
        "XXXX-7-bert/bert-large-cased",
        "XXXX-7-bert/bert-base-multilingual-uncased",
        "XXXX-7-bert/bert-base-multilingual-cased",
        "XXXX-7-bert/bert-base-chinese",
        "XXXX-7-bert/bert-base-german-cased",
        "XXXX-7-bert/bert-large-uncased-whole-word-masking",
        "XXXX-7-bert/bert-large-cased-whole-word-masking",
        "XXXX-7-bert/bert-large-uncased-whole-word-masking-finetuned-squad",
        "XXXX-7-bert/bert-large-cased-whole-word-masking-finetuned-squad",
        "XXXX-7-bert/bert-base-cased-finetuned-mrpc",
        "cl-tohoku/bert-base-japanese",
        "cl-tohoku/bert-base-japanese-whole-word-masking",
        "cl-tohoku/bert-base-japanese-char",
        "cl-tohoku/bert-base-japanese-char-whole-word-masking",
        "TurkuNLP/bert-base-finnish-cased-v1",
        "TurkuNLP/bert-base-finnish-uncased-v1",
        "wietsedv/bert-base-dutch-cased",
    ]
)

BIG_BIRD_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "XXXX-7/bigbird-roberta-base": "XXXX",
        "XXXX-7/bigbird-roberta-large": "XXXX",
        "XXXX-7/bigbird-base-trivia-itc": "XXXX",
    }
)

BIG_BIRD_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["XXXX-7/bigbird-roberta-base", "XXXX-7/bigbird-roberta-large", "XXXX-7/bigbird-base-trivia-itc"]
)

BIGBIRD_PEGASUS_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "XXXX-7/bigbird-pegasus-large-arxiv": "XXXX",
        "XXXX-7/bigbird-pegasus-large-pubmed": "XXXX",
        "XXXX-7/bigbird-pegasus-large-bigpatent": "XXXX",
    }
)

BIGBIRD_PEGASUS_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "XXXX-7/bigbird-pegasus-large-arxiv",
        "XXXX-7/bigbird-pegasus-large-pubmed",
        "XXXX-7/bigbird-pegasus-large-bigpatent",
    ]
)

BIOGPT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"microsoft/biogpt": "XXXX"}
)

BIOGPT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/biogpt", "microsoft/BioGPT-Large"])

BIT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"XXXX-7/bit-50": "XXXX"}
)

BIT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["XXXX-7/bit-50"])

BLENDERBOT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/blenderbot-3B": "XXXX"}
)

BLENDERBOT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/blenderbot-3B"])

BLENDERBOT_SMALL_PRETRAINED_CONFIG_ARCHIVE_MAP = {
    "facebook/blenderbot_small-90M": "XXXX",
    # See all BlenderbotSmall models at XXXX
}

BLENDERBOT_SMALL_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/blenderbot_small-90M"])

BLIP_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "Salesforce/blip-vqa-base": "XXXX",
        "Salesforce/blip-vqa-capfit-large": "XXXX",
        "Salesforce/blip-image-captioning-base": "XXXX",
        "Salesforce/blip-image-captioning-large": "XXXX",
        "Salesforce/blip-itm-base-coco": "XXXX",
        "Salesforce/blip-itm-large-coco": "XXXX",
        "Salesforce/blip-itm-base-flikr": "XXXX",
        "Salesforce/blip-itm-large-flikr": "XXXX",
    }
)

BLIP_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "Salesforce/blip-vqa-base",
        "Salesforce/blip-vqa-capfilt-large",
        "Salesforce/blip-image-captioning-base",
        "Salesforce/blip-image-captioning-large",
        "Salesforce/blip-itm-base-coco",
        "Salesforce/blip-itm-large-coco",
        "Salesforce/blip-itm-base-flickr",
        "Salesforce/blip-itm-large-flickr",
    ]
)

TF_BLIP_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "Salesforce/blip-vqa-base",
        "Salesforce/blip-vqa-capfilt-large",
        "Salesforce/blip-image-captioning-base",
        "Salesforce/blip-image-captioning-large",
        "Salesforce/blip-itm-base-coco",
        "Salesforce/blip-itm-large-coco",
        "Salesforce/blip-itm-base-flickr",
        "Salesforce/blip-itm-large-flickr",
    ]
)

BLIP_2_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"salesforce/blip2-opt-2.7b": "XXXX"}
)

BLIP_2_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["Salesforce/blip2-opt-2.7b"])

BLOOM_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "bigscience/bloom": "XXXX",
        "bigscience/bloom-560m": "XXXX",
        "bigscience/bloom-1b1": "XXXX",
        "bigscience/bloom-1b7": "XXXX",
        "bigscience/bloom-3b": "XXXX",
        "bigscience/bloom-7b1": "XXXX",
    }
)

BLOOM_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "bigscience/bigscience-small-testing",
        "bigscience/bloom-560m",
        "bigscience/bloom-1b1",
        "bigscience/bloom-1b7",
        "bigscience/bloom-3b",
        "bigscience/bloom-7b1",
        "bigscience/bloom",
    ]
)

BRIDGETOWER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "BridgeTower/bridgetower-base": "XXXX",
        "BridgeTower/bridgetower-base-itm-mlm": "XXXX",
    }
)

BRIDGETOWER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["BridgeTower/bridgetower-base", "BridgeTower/bridgetower-base-itm-mlm"]
)

BROS_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "jinho8345/bros-base-uncased": "XXXX",
        "jinho8345/bros-large-uncased": "XXXX",
    }
)

BROS_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["jinho8345/bros-base-uncased", "jinho8345/bros-large-uncased"])

CAMEMBERT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "almanach/camembert-base": "XXXX",
        "umberto-commoncrawl-cased-v1": "XXXX",
        "umberto-wikipedia-uncased-v1": "XXXX",
    }
)

CAMEMBERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["almanach/camembert-base", "Musixmatch/umberto-commoncrawl-cased-v1", "Musixmatch/umberto-wikipedia-uncased-v1"]
)

TF_CAMEMBERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList([])

CANINE_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"XXXX-7/canine-s": "XXXX"}
)

CANINE_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["XXXX-7/canine-s", "XXXX-7/canine-r"])

CHINESE_CLIP_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "OFA-Sys/chinese-clip-vit-base-patch16": "XXXX"
    }
)

CHINESE_CLIP_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["OFA-Sys/chinese-clip-vit-base-patch16"])

CLAP_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["laion/clap-htsat-fused", "laion/clap-htsat-unfused"])

CLIP_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"openai/clip-vit-base-patch32": "XXXX/resolve/main/config.json"}
)

CLIP_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["openai/clip-vit-base-patch32"])

TF_CLIP_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["openai/clip-vit-base-patch32"])

CLIPSEG_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"CIDAS/clipseg-rd64": "XXXX"}
)

CLIPSEG_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["CIDAS/clipseg-rd64-refined"])

CLVP_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"susnato/clvp_dev": "XXXX"}
)

CLVP_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["susnato/clvp_dev"])

CODEGEN_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "Salesforce/codegen-350M-nl": "XXXX",
        "Salesforce/codegen-350M-multi": "XXXX",
        "Salesforce/codegen-350M-mono": "XXXX",
        "Salesforce/codegen-2B-nl": "XXXX",
        "Salesforce/codegen-2B-multi": "XXXX",
        "Salesforce/codegen-2B-mono": "XXXX",
        "Salesforce/codegen-6B-nl": "XXXX",
        "Salesforce/codegen-6B-multi": "XXXX",
        "Salesforce/codegen-6B-mono": "XXXX",
        "Salesforce/codegen-16B-nl": "XXXX",
        "Salesforce/codegen-16B-multi": "XXXX",
        "Salesforce/codegen-16B-mono": "XXXX",
    }
)

CODEGEN_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "Salesforce/codegen-350M-nl",
        "Salesforce/codegen-350M-multi",
        "Salesforce/codegen-350M-mono",
        "Salesforce/codegen-2B-nl",
        "Salesforce/codegen-2B-multi",
        "Salesforce/codegen-2B-mono",
        "Salesforce/codegen-6B-nl",
        "Salesforce/codegen-6B-multi",
        "Salesforce/codegen-6B-mono",
        "Salesforce/codegen-16B-nl",
        "Salesforce/codegen-16B-multi",
        "Salesforce/codegen-16B-mono",
    ]
)

CONDITIONAL_DETR_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "microsoft/conditional-detr-resnet-50": "XXXX"
    }
)

CONDITIONAL_DETR_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/conditional-detr-resnet-50"])

CONVBERT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "YituTech/conv-bert-base": "XXXX",
        "YituTech/conv-bert-medium-small": "XXXX",
        "YituTech/conv-bert-small": "XXXX",
    }
)

CONVBERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["YituTech/conv-bert-base", "YituTech/conv-bert-medium-small", "YituTech/conv-bert-small"]
)

TF_CONVBERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["YituTech/conv-bert-base", "YituTech/conv-bert-medium-small", "YituTech/conv-bert-small"]
)

CONVNEXT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/convnext-tiny-224": "XXXX"}
)

CONVNEXT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/convnext-tiny-224"])

CONVNEXTV2_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "facebook/convnextv2-tiny-1k-224": "XXXX"
    }
)

CONVNEXTV2_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/convnextv2-tiny-1k-224"])

CPMANT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"openbmb/cpm-ant-10b": "XXXX"}
)

CPMANT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["openbmb/cpm-ant-10b"])

CTRL_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"Salesforce/ctrl": "XXXX"}
)

CTRL_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["Salesforce/ctrl"])

TF_CTRL_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["Salesforce/ctrl"])

CVT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"microsoft/cvt-13": "XXXX"}
)

CVT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "microsoft/cvt-13",
        "microsoft/cvt-13-384",
        "microsoft/cvt-13-384-22k",
        "microsoft/cvt-21",
        "microsoft/cvt-21-384",
        "microsoft/cvt-21-384-22k",
    ]
)

TF_CVT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "microsoft/cvt-13",
        "microsoft/cvt-13-384",
        "microsoft/cvt-13-384-22k",
        "microsoft/cvt-21",
        "microsoft/cvt-21-384",
        "microsoft/cvt-21-384-22k",
    ]
)

DATA2VEC_TEXT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/data2vec-text-base": "XXXX"}
)

DATA2VEC_VISION_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "facebook/data2vec-vision-base-ft": "XXXX"
    }
)

DATA2VEC_AUDIO_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "facebook/data2vec-audio-base",
        "facebook/data2vec-audio-base-10m",
        "facebook/data2vec-audio-base-100h",
        "facebook/data2vec-audio-base-960h",
    ]
)

DATA2VEC_TEXT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/data2vec-text-base"])

DATA2VEC_VISION_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/data2vec-vision-base-ft1k"])

DEBERTA_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "microsoft/deberta-base": "XXXX",
        "microsoft/deberta-large": "XXXX",
        "microsoft/deberta-xlarge": "XXXX",
        "microsoft/deberta-base-mnli": "XXXX",
        "microsoft/deberta-large-mnli": "XXXX",
        "microsoft/deberta-xlarge-mnli": "XXXX",
    }
)

DEBERTA_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "microsoft/deberta-base",
        "microsoft/deberta-large",
        "microsoft/deberta-xlarge",
        "microsoft/deberta-base-mnli",
        "microsoft/deberta-large-mnli",
        "microsoft/deberta-xlarge-mnli",
    ]
)

TF_DEBERTA_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["kamalkraj/deberta-base"])

DEBERTA_V2_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "microsoft/deberta-v2-xlarge": "XXXX",
        "microsoft/deberta-v2-xxlarge": "XXXX",
        "microsoft/deberta-v2-xlarge-mnli": "XXXX",
        "microsoft/deberta-v2-xxlarge-mnli": "XXXX",
    }
)

DEBERTA_V2_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "microsoft/deberta-v2-xlarge",
        "microsoft/deberta-v2-xxlarge",
        "microsoft/deberta-v2-xlarge-mnli",
        "microsoft/deberta-v2-xxlarge-mnli",
    ]
)

TF_DEBERTA_V2_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["kamalkraj/deberta-v2-xlarge"])

DECISION_TRANSFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "edbeeching/decision-transformer-gym-hopper-medium": "XXXX"
    }
)

DECISION_TRANSFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["edbeeching/decision-transformer-gym-hopper-medium"]
)

DEFORMABLE_DETR_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"SenseTime/deformable-detr": "XXXX"}
)

DEFORMABLE_DETR_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["sensetime/deformable-detr"])

DEIT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "facebook/deit-base-distilled-patch16-224": "XXXX"
    }
)

DEIT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/deit-base-distilled-patch16-224"])

TF_DEIT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/deit-base-distilled-patch16-224"])

MCTCT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"speechbrain/m-ctc-t-large": "XXXX"}
)

MCTCT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["speechbrain/m-ctc-t-large"])

OPEN_LLAMA_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"s-JoL/Open-Llama-V1": "XXXX"}
)

RETRIBERT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "yjernite/retribert-base-uncased": "XXXX"
    }
)

RETRIBERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["yjernite/retribert-base-uncased"])

TRAJECTORY_TRANSFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "CarlCochet/trajectory-transformer-halfcheetah-medium-v2": "XXXX"
    }
)

TRAJECTORY_TRANSFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["CarlCochet/trajectory-transformer-halfcheetah-medium-v2"]
)

TRANSFO_XL_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"transfo-xl/transfo-xl-wt103": "XXXX"}
)

TRANSFO_XL_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["transfo-xl/transfo-xl-wt103"])

TF_TRANSFO_XL_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["transfo-xl/transfo-xl-wt103"])

VAN_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "Visual-Attention-Network/van-base": "XXXX"
    }
)

VAN_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["Visual-Attention-Network/van-base"])

DEPTH_ANYTHING_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "LiheYoung/depth-anything-small-hf": "XXXX"
    }
)

DEPTH_ANYTHING_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["LiheYoung/depth-anything-small-hf"])

DETA_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"ut/deta": "XXXX"}
)

DETA_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["jozhang97/deta-swin-large-o365"])

DETR_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/detr-resnet-50": "XXXX"}
)

DETR_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/detr-resnet-50"])

DINAT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"shi-labs/dinat-mini-in1k-224": "XXXX"}
)

DINAT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["shi-labs/dinat-mini-in1k-224"])

DINOV2_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/dinov2-base": "XXXX"}
)

DINOV2_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/dinov2-base"])

DISTILBERT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "distilbert-base-uncased": "XXXX",
        "distilbert-base-uncased-distilled-squad": "XXXX",
        "distilbert-base-cased": "XXXX",
        "distilbert-base-cased-distilled-squad": "XXXX",
        "distilbert-base-german-cased": "XXXX",
        "distilbert-base-multilingual-cased": "XXXX",
        "distilbert-base-uncased-finetuned-sst-2-english": "XXXX",
    }
)

DISTILBERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "distilbert-base-uncased",
        "distilbert-base-uncased-distilled-squad",
        "distilbert-base-cased",
        "distilbert-base-cased-distilled-squad",
        "distilbert-base-german-cased",
        "distilbert-base-multilingual-cased",
        "distilbert-base-uncased-finetuned-sst-2-english",
    ]
)

TF_DISTILBERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "distilbert-base-uncased",
        "distilbert-base-uncased-distilled-squad",
        "distilbert-base-cased",
        "distilbert-base-cased-distilled-squad",
        "distilbert-base-multilingual-cased",
        "distilbert-base-uncased-finetuned-sst-2-english",
    ]
)

DONUT_SWIN_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"naver-clova-ix/donut-base": "XXXX"}
)

DONUT_SWIN_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["naver-clova-ix/donut-base"])

DPR_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "facebook/dpr-ctx_encoder-single-nq-base": "XXXX",
        "facebook/dpr-question_encoder-single-nq-base": "XXXX",
        "facebook/dpr-reader-single-nq-base": "XXXX",
        "facebook/dpr-ctx_encoder-multiset-base": "XXXX",
        "facebook/dpr-question_encoder-multiset-base": "XXXX",
        "facebook/dpr-reader-multiset-base": "XXXX",
    }
)

DPR_CONTEXT_ENCODER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["facebook/dpr-ctx_encoder-single-nq-base", "facebook/dpr-ctx_encoder-multiset-base"]
)

DPR_QUESTION_ENCODER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["facebook/dpr-question_encoder-single-nq-base", "facebook/dpr-question_encoder-multiset-base"]
)

DPR_READER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["facebook/dpr-reader-single-nq-base", "facebook/dpr-reader-multiset-base"]
)

TF_DPR_CONTEXT_ENCODER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["facebook/dpr-ctx_encoder-single-nq-base", "facebook/dpr-ctx_encoder-multiset-base"]
)

TF_DPR_QUESTION_ENCODER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["facebook/dpr-question_encoder-single-nq-base", "facebook/dpr-question_encoder-multiset-base"]
)

TF_DPR_READER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["facebook/dpr-reader-single-nq-base", "facebook/dpr-reader-multiset-base"]
)

DPT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"Intel/dpt-large": "XXXX"}
)

DPT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["Intel/dpt-large", "Intel/dpt-hybrid-midas"])

EFFICIENTFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "snap-research/efficientformer-l1-300": "XXXX"
    }
)

EFFICIENTFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["snap-research/efficientformer-l1-300"])

TF_EFFICIENTFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["snap-research/efficientformer-l1-300"])

EFFICIENTNET_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"XXXX-7/efficientnet-b7": "XXXX"}
)

EFFICIENTNET_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["XXXX-7/efficientnet-b7"])

ELECTRA_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "XXXX-7/electra-small-generator": "XXXX",
        "XXXX-7/electra-base-generator": "XXXX",
        "XXXX-7/electra-large-generator": "XXXX",
        "XXXX-7/electra-small-discriminator": "XXXX",
        "XXXX-7/electra-base-discriminator": "XXXX",
        "XXXX-7/electra-large-discriminator": "XXXX",
    }
)

ELECTRA_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "XXXX-7/electra-small-generator",
        "XXXX-7/electra-base-generator",
        "XXXX-7/electra-large-generator",
        "XXXX-7/electra-small-discriminator",
        "XXXX-7/electra-base-discriminator",
        "XXXX-7/electra-large-discriminator",
    ]
)

TF_ELECTRA_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "XXXX-7/electra-small-generator",
        "XXXX-7/electra-base-generator",
        "XXXX-7/electra-large-generator",
        "XXXX-7/electra-small-discriminator",
        "XXXX-7/electra-base-discriminator",
        "XXXX-7/electra-large-discriminator",
    ]
)

ENCODEC_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "facebook/encodec_24khz": "XXXX",
        "facebook/encodec_48khz": "XXXX",
    }
)

ENCODEC_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/encodec_24khz", "facebook/encodec_48khz"])

ERNIE_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "nghuyong/ernie-1.0-base-zh": "XXXX",
        "nghuyong/ernie-2.0-base-en": "XXXX",
        "nghuyong/ernie-2.0-large-en": "XXXX",
        "nghuyong/ernie-3.0-base-zh": "XXXX",
        "nghuyong/ernie-3.0-medium-zh": "XXXX",
        "nghuyong/ernie-3.0-mini-zh": "XXXX",
        "nghuyong/ernie-3.0-micro-zh": "XXXX",
        "nghuyong/ernie-3.0-nano-zh": "XXXX",
        "nghuyong/ernie-gram-zh": "XXXX",
        "nghuyong/ernie-health-zh": "XXXX",
    }
)

ERNIE_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "nghuyong/ernie-1.0-base-zh",
        "nghuyong/ernie-2.0-base-en",
        "nghuyong/ernie-2.0-large-en",
        "nghuyong/ernie-3.0-base-zh",
        "nghuyong/ernie-3.0-medium-zh",
        "nghuyong/ernie-3.0-mini-zh",
        "nghuyong/ernie-3.0-micro-zh",
        "nghuyong/ernie-3.0-nano-zh",
        "nghuyong/ernie-gram-zh",
        "nghuyong/ernie-health-zh",
    ]
)

ERNIE_M_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "susnato/ernie-m-base_pytorch": "XXXX",
        "susnato/ernie-m-large_pytorch": "XXXX",
    }
)

ERNIE_M_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["susnato/ernie-m-base_pytorch", "susnato/ernie-m-large_pytorch"]
)

ESM_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/esm-1b": "XXXX"}
)

ESM_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/esm2_t6_8M_UR50D", "facebook/esm2_t12_35M_UR50D"])

FALCON_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "tiiuae/falcon-40b": "XXXX",
        "tiiuae/falcon-7b": "XXXX",
    }
)

FALCON_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "tiiuae/falcon-40b",
        "tiiuae/falcon-40b-instruct",
        "tiiuae/falcon-7b",
        "tiiuae/falcon-7b-instruct",
        "tiiuae/falcon-rw-7b",
        "tiiuae/falcon-rw-1b",
    ]
)

FASTSPEECH2_CONFORMER_HIFIGAN_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "espnet/fastspeech2_conformer_hifigan": "XXXX"
    }
)

FASTSPEECH2_CONFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"espnet/fastspeech2_conformer": "XXXX"}
)

FASTSPEECH2_CONFORMER_WITH_HIFIGAN_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "espnet/fastspeech2_conformer_with_hifigan": "XXXX"
    }
)

FASTSPEECH2_CONFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["espnet/fastspeech2_conformer"])

FLAUBERT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "flaubert/flaubert_small_cased": "XXXX",
        "flaubert/flaubert_base_uncased": "XXXX",
        "flaubert/flaubert_base_cased": "XXXX",
        "flaubert/flaubert_large_cased": "XXXX",
    }
)

FLAUBERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "flaubert/flaubert_small_cased",
        "flaubert/flaubert_base_uncased",
        "flaubert/flaubert_base_cased",
        "flaubert/flaubert_large_cased",
    ]
)

TF_FLAUBERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList([])

FLAVA_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/flava-full": "XXXX"}
)

FLAVA_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/flava-full"])

FNET_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "XXXX-7/fnet-base": "XXXX",
        "XXXX-7/fnet-large": "XXXX",
    }
)

FNET_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["XXXX-7/fnet-base", "XXXX-7/fnet-large"])

FOCALNET_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"microsoft/focalnet-tiny": "XXXX"}
)

FOCALNET_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/focalnet-tiny"])

FSMT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict({})

FUNNEL_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "funnel-transformer/small": "XXXX",
        "funnel-transformer/small-base": "XXXX",
        "funnel-transformer/medium": "XXXX",
        "funnel-transformer/medium-base": "XXXX",
        "funnel-transformer/intermediate": "XXXX",
        "funnel-transformer/intermediate-base": "XXXX",
        "funnel-transformer/large": "XXXX",
        "funnel-transformer/large-base": "XXXX",
        "funnel-transformer/xlarge": "XXXX",
        "funnel-transformer/xlarge-base": "XXXX",
    }
)

FUNNEL_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "funnel-transformer/small",
        "funnel-transformer/small-base",
        "funnel-transformer/medium",
        "funnel-transformer/medium-base",
        "funnel-transformer/intermediate",
        "funnel-transformer/intermediate-base",
        "funnel-transformer/large",
        "funnel-transformer/large-base",
        "funnel-transformer/xlarge-base",
        "funnel-transformer/xlarge",
    ]
)

TF_FUNNEL_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "funnel-transformer/small",
        "funnel-transformer/small-base",
        "funnel-transformer/medium",
        "funnel-transformer/medium-base",
        "funnel-transformer/intermediate",
        "funnel-transformer/intermediate-base",
        "funnel-transformer/large",
        "funnel-transformer/large-base",
        "funnel-transformer/xlarge-base",
        "funnel-transformer/xlarge",
    ]
)

FUYU_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"adept/fuyu-8b": "XXXX"}
)

GEMMA_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict({})

GIT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"microsoft/git-base": "XXXX"}
)

GIT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/git-base"])

GLPN_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"vinvino02/glpn-kitti": "XXXX"}
)

GLPN_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["vinvino02/glpn-kitti"])

GPT2_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "openai-community/gpt2": "XXXX",
        "openai-community/gpt2-medium": "XXXX",
        "openai-community/gpt2-large": "XXXX",
        "openai-community/gpt2-xl": "XXXX",
        "distilbert/distilgpt2": "XXXX",
    }
)

GPT2_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "openai-community/gpt2",
        "openai-community/gpt2-medium",
        "openai-community/gpt2-large",
        "openai-community/gpt2-xl",
        "distilbert/distilgpt2",
    ]
)

TF_GPT2_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "openai-community/gpt2",
        "openai-community/gpt2-medium",
        "openai-community/gpt2-large",
        "openai-community/gpt2-xl",
        "distilbert/distilgpt2",
    ]
)

GPT_BIGCODE_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "bigcode/gpt_bigcode-santacoder": "XXXX"
    }
)

GPT_BIGCODE_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["bigcode/gpt_bigcode-santacoder"])

GPT_NEO_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"EleutherAI/gpt-neo-1.3B": "XXXX"}
)

GPT_NEO_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["EleutherAI/gpt-neo-1.3B"])

GPT_NEOX_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"EleutherAI/gpt-neox-20b": "XXXX"}
)

GPT_NEOX_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["EleutherAI/gpt-neox-20b"])

GPT_NEOX_JAPANESE_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"abeja/gpt-neox-japanese-2.7b": "XXXX"}
)

GPT_NEOX_JAPANESE_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["XXXX"]
)

GPTJ_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"EleutherAI/gpt-j-6B": "XXXX"}
)

GPTJ_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["EleutherAI/gpt-j-6B"])

GPTSAN_JAPANESE_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "tanreinama/GPTSAN-2.8B-spout_is_uniform": "XXXX"
    }
)

GPTSAN_JAPANESE_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["Tanrei/GPTSAN-japanese"])

GRAPHORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"graphormer-base": "XXXX"}
)

GRAPHORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["clefourrier/graphormer-base-pcqm4mv1", "clefourrier/graphormer-base-pcqm4mv2"]
)

GROUPVIT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"nvidia/groupvit-gcc-yfcc": "XXXX"}
)

GROUPVIT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["nvidia/groupvit-gcc-yfcc"])

TF_GROUPVIT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["nvidia/groupvit-gcc-yfcc"])

HUBERT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/hubert-base-ls960": "XXXX"}
)

HUBERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/hubert-base-ls960"])

TF_HUBERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/hubert-base-ls960"])

IBERT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "kssteven/ibert-roberta-base": "XXXX",
        "kssteven/ibert-roberta-large": "XXXX",
        "kssteven/ibert-roberta-large-mnli": "XXXX",
    }
)

IBERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["kssteven/ibert-roberta-base", "kssteven/ibert-roberta-large", "kssteven/ibert-roberta-large-mnli"]
)

IDEFICS_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "HuggingFaceM4/idefics-9b": "XXXX",
        "HuggingFaceM4/idefics-80b": "XXXX",
    }
)

IDEFICS_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["HuggingFaceM4/idefics-9b", "HuggingFaceM4/idefics-80b"])

IMAGEGPT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"openai/imagegpt-small": "", "openai/imagegpt-medium": "", "openai/imagegpt-large": ""}
)

IMAGEGPT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["openai/imagegpt-small", "openai/imagegpt-medium", "openai/imagegpt-large"]
)

INFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "huggingface/informer-tourism-monthly": "XXXX"
    }
)

INFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["huggingface/informer-tourism-monthly"])

INSTRUCTBLIP_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "Salesforce/instruct-blip-flan-t5": "XXXX"
    }
)

INSTRUCTBLIP_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["Salesforce/instructblip-flan-t5-xl"])

JUKEBOX_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "openai/jukebox-5b-lyrics": "XXXX",
        "openai/jukebox-1b-lyrics": "XXXX",
    }
)

JUKEBOX_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["openai/jukebox-1b-lyrics", "openai/jukebox-5b-lyrics"])

KOSMOS2_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "microsoft/kosmos-2-patch14-224": "XXXX"
    }
)

KOSMOS2_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/kosmos-2-patch14-224"])

LAYOUTLM_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "microsoft/layoutlm-base-uncased": "XXXX",
        "microsoft/layoutlm-large-uncased": "XXXX",
    }
)

LAYOUTLM_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["layoutlm-base-uncased", "layoutlm-large-uncased"])

TF_LAYOUTLM_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["microsoft/layoutlm-base-uncased", "microsoft/layoutlm-large-uncased"]
)

LAYOUTLMV2_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "layoutlmv2-base-uncased": "XXXX",
        "layoutlmv2-large-uncased": "XXXX",
    }
)

LAYOUTLMV2_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["microsoft/layoutlmv2-base-uncased", "microsoft/layoutlmv2-large-uncased"]
)

LAYOUTLMV3_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"microsoft/layoutlmv3-base": "XXXX"}
)

LAYOUTLMV3_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/layoutlmv3-base", "microsoft/layoutlmv3-large"])

TF_LAYOUTLMV3_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["microsoft/layoutlmv3-base", "microsoft/layoutlmv3-large"]
)

LED_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"allenai/led-base-16384": "XXXX"}
)

LED_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["allenai/led-base-16384"])

LEVIT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/levit-128S": "XXXX"}
)

LEVIT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/levit-128S"])

LILT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "SCUT-DLVCLab/lilt-roberta-en-base": "XXXX"
    }
)

LILT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["SCUT-DLVCLab/lilt-roberta-en-base"])

LLAMA_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict({})

LLAVA_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"llava-hf/llava-v1.5-7b": "XXXX"}
)

LLAVA_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["llava-hf/llava-1.5-7b-hf", "llava-hf/llava-1.5-13b-hf", "llava-hf/bakLlava-v1-hf"]
)

LONGFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "allenai/longformer-base-4096": "XXXX",
        "allenai/longformer-large-4096": "XXXX",
        "allenai/longformer-large-4096-finetuned-triviaqa": "XXXX",
        "allenai/longformer-base-4096-extra.pos.embd.only": "XXXX",
        "allenai/longformer-large-4096-extra.pos.embd.only": "XXXX",
    }
)

LONGFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "allenai/longformer-base-4096",
        "allenai/longformer-large-4096",
        "allenai/longformer-large-4096-finetuned-triviaqa",
        "allenai/longformer-base-4096-extra.pos.embd.only",
        "allenai/longformer-large-4096-extra.pos.embd.only",
    ]
)

TF_LONGFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "allenai/longformer-base-4096",
        "allenai/longformer-large-4096",
        "allenai/longformer-large-4096-finetuned-triviaqa",
        "allenai/longformer-base-4096-extra.pos.embd.only",
        "allenai/longformer-large-4096-extra.pos.embd.only",
    ]
)

LONGT5_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "XXXX-7/long-t5-local-base": "XXXX",
        "XXXX-7/long-t5-local-large": "XXXX",
        "XXXX-7/long-t5-tglobal-base": "XXXX",
        "XXXX-7/long-t5-tglobal-large": "XXXX",
    }
)

LONGT5_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "XXXX-7/long-t5-local-base",
        "XXXX-7/long-t5-local-large",
        "XXXX-7/long-t5-tglobal-base",
        "XXXX-7/long-t5-tglobal-large",
    ]
)

LUKE_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "studio-ousia/luke-base": "XXXX",
        "studio-ousia/luke-large": "XXXX",
    }
)

LUKE_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["studio-ousia/luke-base", "studio-ousia/luke-large"])

LXMERT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"unc-nlp/lxmert-base-uncased": "XXXX"}
)

TF_LXMERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["unc-nlp/lxmert-base-uncased"])

M2M_100_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/m2m100_418M": "XXXX"}
)

M2M_100_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/m2m100_418M"])

MAMBA_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"state-spaces/mamba-2.8b": "XXXX"}
)

MAMBA_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList([])

MARKUPLM_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "microsoft/markuplm-base": "XXXX",
        "microsoft/markuplm-large": "XXXX",
    }
)

MARKUPLM_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/markuplm-base", "microsoft/markuplm-large"])

MASK2FORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "facebook/mask2former-swin-small-coco-instance": "XXXX"
    }
)

MASK2FORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/mask2former-swin-small-coco-instance"])

MASKFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "facebook/maskformer-swin-base-ade": "XXXX"
    }
)

MASKFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/maskformer-swin-base-ade"])

MEGA_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"mnaylor/mega-base-wikitext": "XXXX"}
)

MEGA_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["mnaylor/mega-base-wikitext"])

MEGATRON_BERT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict({})

MEGATRON_BERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["nvidia/megatron-bert-cased-345m"])

MGP_STR_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"alibaba-damo/mgp-str-base": "XXXX"}
)

MGP_STR_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["alibaba-damo/mgp-str-base"])

MISTRAL_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "mistralai/Mistral-7B-v0.1": "XXXX",
        "mistralai/Mistral-7B-Instruct-v0.1": "XXXX",
    }
)

MIXTRAL_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"mistral-ai/Mixtral-8x7B": "XXXX"}
)

MOBILEBERT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"XXXX-7/mobilebert-uncased": "XXXX"}
)

MOBILEBERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["XXXX-7/mobilebert-uncased"])

TF_MOBILEBERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["XXXX-7/mobilebert-uncased"])

MOBILENET_V1_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "XXXX-7/mobilenet_v1_1.0_224": "XXXX",
        "XXXX-7/mobilenet_v1_0.75_192": "XXXX",
    }
)

MOBILENET_V1_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["XXXX-7/mobilenet_v1_1.0_224", "XXXX-7/mobilenet_v1_0.75_192"]
)

MOBILENET_V2_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "XXXX-7/mobilenet_v2_1.4_224": "XXXX",
        "XXXX-7/mobilenet_v2_1.0_224": "XXXX",
        "XXXX-7/mobilenet_v2_0.75_160": "XXXX",
        "XXXX-7/mobilenet_v2_0.35_96": "XXXX",
    }
)

MOBILENET_V2_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "XXXX-7/mobilenet_v2_1.4_224",
        "XXXX-7/mobilenet_v2_1.0_224",
        "XXXX-7/mobilenet_v2_0.37_160",
        "XXXX-7/mobilenet_v2_0.35_96",
    ]
)

MOBILEVIT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "apple/mobilevit-small": "XXXX",
        "apple/mobilevit-x-small": "XXXX",
        "apple/mobilevit-xx-small": "XXXX",
        "apple/deeplabv3-mobilevit-small": "XXXX",
        "apple/deeplabv3-mobilevit-x-small": "XXXX",
        "apple/deeplabv3-mobilevit-xx-small": "XXXX",
    }
)

MOBILEVIT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "apple/mobilevit-small",
        "apple/mobilevit-x-small",
        "apple/mobilevit-xx-small",
        "apple/deeplabv3-mobilevit-small",
        "apple/deeplabv3-mobilevit-x-small",
        "apple/deeplabv3-mobilevit-xx-small",
    ]
)

TF_MOBILEVIT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "apple/mobilevit-small",
        "apple/mobilevit-x-small",
        "apple/mobilevit-xx-small",
        "apple/deeplabv3-mobilevit-small",
        "apple/deeplabv3-mobilevit-x-small",
        "apple/deeplabv3-mobilevit-xx-small",
    ]
)

MOBILEVITV2_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"apple/mobilevitv2-1.0": "XXXX"}
)

MOBILEVITV2_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["apple/mobilevitv2-1.0-imagenet1k-256"])

MPNET_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"microsoft/mpnet-base": "XXXX"}
)

MPNET_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/mpnet-base"])

TF_MPNET_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/mpnet-base"])

MPT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"mosaicml/mpt-7b": "XXXX"}
)

MPT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "mosaicml/mpt-7b",
        "mosaicml/mpt-7b-storywriter",
        "mosaicml/mpt-7b-instruct",
        "mosaicml/mpt-7b-8k",
        "mosaicml/mpt-7b-8k-instruct",
        "mosaicml/mpt-7b-8k-chat",
        "mosaicml/mpt-30b",
        "mosaicml/mpt-30b-instruct",
        "mosaicml/mpt-30b-chat",
    ]
)

MRA_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"uw-madison/mra-base-512-4": "XXXX"}
)

MRA_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["uw-madison/mra-base-512-4"])

MUSICGEN_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/musicgen-small": "XXXX"}
)

MUSICGEN_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/musicgen-small"])

MUSICGEN_MELODY_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/musicgen-melody": "XXXX"}
)

MUSICGEN_MELODY_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/musicgen-melody"])

MVP_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "RUCAIBox/mvp",
        "RUCAIBox/mvp-data-to-text",
        "RUCAIBox/mvp-open-dialog",
        "RUCAIBox/mvp-question-answering",
        "RUCAIBox/mvp-question-generation",
        "RUCAIBox/mvp-story",
        "RUCAIBox/mvp-summarization",
        "RUCAIBox/mvp-task-dialog",
        "RUCAIBox/mtl-data-to-text",
        "RUCAIBox/mtl-multi-task",
        "RUCAIBox/mtl-open-dialog",
        "RUCAIBox/mtl-question-answering",
        "RUCAIBox/mtl-question-generation",
        "RUCAIBox/mtl-story",
        "RUCAIBox/mtl-summarization",
    ]
)

NAT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"shi-labs/nat-mini-in1k-224": "XXXX"}
)

NAT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["shi-labs/nat-mini-in1k-224"])

NEZHA_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"sijunhe/nezha-cn-base": "XXXX"}
)

NEZHA_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["sijunhe/nezha-cn-base", "sijunhe/nezha-cn-large", "sijunhe/nezha-base-wwm", "sijunhe/nezha-large-wwm"]
)

NLLB_MOE_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/nllb-moe-54B": "XXXX"}
)

NLLB_MOE_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/nllb-moe-54b"])

NYSTROMFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"uw-madison/nystromformer-512": "XXXX"}
)

NYSTROMFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["uw-madison/nystromformer-512"])

OLMO_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "allenai/OLMo-1B-hf": "XXXX",
        "allenai/OLMo-7B-hf": "XXXX",
        "allenai/OLMo-7B-Twin-2T-hf": "XXXX",
    }
)

ONEFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "shi-labs/oneformer_ade20k_swin_tiny": "XXXX"
    }
)

ONEFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["shi-labs/oneformer_ade20k_swin_tiny"])

OPENAI_GPT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"openai-community/openai-gpt": "XXXX"}
)

OPENAI_GPT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["openai-community/openai-gpt"])

TF_OPENAI_GPT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["openai-community/openai-gpt"])

OPT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "facebook/opt-125m",
        "facebook/opt-350m",
        "facebook/opt-1.3b",
        "facebook/opt-2.7b",
        "facebook/opt-6.7b",
        "facebook/opt-13b",
        "facebook/opt-30b",
    ]
)

OWLV2_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"XXXX-7/owlv2-base-patch16": "XXXX"}
)

OWLV2_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["XXXX-7/owlv2-base-patch16-ensemble"])

OWLVIT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "XXXX-7/owlvit-base-patch32": "XXXX",
        "XXXX-7/owlvit-base-patch16": "XXXX",
        "XXXX-7/owlvit-large-patch14": "XXXX",
    }
)

OWLVIT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["XXXX-7/owlvit-base-patch32", "XXXX-7/owlvit-base-patch16", "XXXX-7/owlvit-large-patch14"]
)

PATCHTSMIXER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "ibm/patchtsmixer-etth1-pretrain": "XXXX"
    }
)

PATCHTSMIXER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["ibm/patchtsmixer-etth1-pretrain"])

PATCHTST_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"ibm/patchtst-base": "XXXX"}
)

PATCHTST_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["ibm/patchtst-etth1-pretrain"])

PEGASUS_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"XXXX-7/pegasus-large": "XXXX"}
)

PEGASUS_X_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "XXXX-7/pegasus-x-base": "XXXX",
        "XXXX-7/pegasus-x-large": "XXXX",
    }
)

PEGASUS_X_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["XXXX-7/pegasus-x-base", "XXXX-7/pegasus-x-large"])

PERCEIVER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"deepmind/language-perceiver": "XXXX"}
)

PERCEIVER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["deepmind/language-perceiver"])

PERSIMMON_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"adept/persimmon-8b-base": "XXXX"}
)

PHI_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "microsoft/phi-1": "XXXX",
        "microsoft/phi-1_5": "XXXX",
        "microsoft/phi-2": "XXXX",
    }
)

PHI_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/phi-1", "microsoft/phi-1_5", "microsoft/phi-2"])

PIX2STRUCT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "XXXX-7/pix2struct-textcaps-base": "XXXX"
    }
)

PIX2STRUCT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "XXXX-7/pix2struct-textcaps-base",
        "XXXX-7/pix2struct-textcaps-large",
        "XXXX-7/pix2struct-base",
        "XXXX-7/pix2struct-large",
        "XXXX-7/pix2struct-ai2d-base",
        "XXXX-7/pix2struct-ai2d-large",
        "XXXX-7/pix2struct-widget-captioning-base",
        "XXXX-7/pix2struct-widget-captioning-large",
        "XXXX-7/pix2struct-screen2words-base",
        "XXXX-7/pix2struct-screen2words-large",
        "XXXX-7/pix2struct-docvqa-base",
        "XXXX-7/pix2struct-docvqa-large",
        "XXXX-7/pix2struct-ocrvqa-base",
        "XXXX-7/pix2struct-ocrvqa-large",
        "XXXX-7/pix2struct-chartqa-base",
        "XXXX-7/pix2struct-inforgraphics-vqa-base",
        "XXXX-7/pix2struct-inforgraphics-vqa-large",
    ]
)

PLBART_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"uclanlp/plbart-base": "XXXX"}
)

PLBART_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["uclanlp/plbart-base", "uclanlp/plbart-cs-java", "uclanlp/plbart-multi_task-all"]
)

POOLFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"sail/poolformer_s12": "XXXX"}
)

POOLFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["sail/poolformer_s12"])

POP2PIANO_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"sweetcocoa/pop2piano": "XXXX"}
)

POP2PIANO_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["sweetcocoa/pop2piano"])

PROPHETNET_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "microsoft/prophetnet-large-uncased": "XXXX"
    }
)

PROPHETNET_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/prophetnet-large-uncased"])

PVT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict({"pvt-tiny-224": "XXXX"})

PVT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["Zetatech/pvt-tiny-224"])

QDQBERT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"XXXX-7-bert/bert-base-uncased": "XXXX"}
)

QDQBERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["XXXX-7-bert/bert-base-uncased"])

QWEN2_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"Qwen/Qwen2-7B-beta": "XXXX"}
)

REALM_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "XXXX-7/realm-cc-news-pretrained-embedder": "XXXX",
        "XXXX-7/realm-cc-news-pretrained-encoder": "XXXX",
        "XXXX-7/realm-cc-news-pretrained-scorer": "XXXX",
        "XXXX-7/realm-cc-news-pretrained-openqa": "XXXX",
        "XXXX-7/realm-orqa-nq-openqa": "XXXX",
        "XXXX-7/realm-orqa-nq-reader": "XXXX",
        "XXXX-7/realm-orqa-wq-openqa": "XXXX",
        "XXXX-7/realm-orqa-wq-reader": "XXXX",
    }
)

REALM_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "XXXX-7/realm-cc-news-pretrained-embedder",
        "XXXX-7/realm-cc-news-pretrained-encoder",
        "XXXX-7/realm-cc-news-pretrained-scorer",
        "XXXX-7/realm-cc-news-pretrained-openqa",
        "XXXX-7/realm-orqa-nq-openqa",
        "XXXX-7/realm-orqa-nq-reader",
        "XXXX-7/realm-orqa-wq-openqa",
        "XXXX-7/realm-orqa-wq-reader",
    ]
)

REFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "XXXX-7/reformer-crime-and-punishment": "XXXX",
        "XXXX-7/reformer-enwik8": "XXXX",
    }
)

REFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["XXXX-7/reformer-crime-and-punishment", "XXXX-7/reformer-enwik8"]
)

REGNET_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/regnet-y-040": "XXXX"}
)

REGNET_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/regnet-y-040"])

TF_REGNET_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/regnet-y-040"])

REMBERT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"XXXX-7/rembert": "XXXX"}
)

REMBERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["XXXX-7/rembert"])

TF_REMBERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["XXXX-7/rembert"])

RESNET_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"microsoft/resnet-50": "XXXX"}
)

RESNET_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/resnet-50"])

TF_RESNET_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/resnet-50"])

ROBERTA_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "FacebookAI/roberta-base": "XXXX",
        "FacebookAI/roberta-large": "XXXX",
        "FacebookAI/roberta-large-mnli": "XXXX",
        "distilbert/distilroberta-base": "XXXX",
        "openai-community/roberta-base-openai-detector": "XXXX",
        "openai-community/roberta-large-openai-detector": "XXXX",
    }
)

ROBERTA_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "FacebookAI/roberta-base",
        "FacebookAI/roberta-large",
        "FacebookAI/roberta-large-mnli",
        "distilbert/distilroberta-base",
        "openai-community/roberta-base-openai-detector",
        "openai-community/roberta-large-openai-detector",
    ]
)

TF_ROBERTA_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "FacebookAI/roberta-base",
        "FacebookAI/roberta-large",
        "FacebookAI/roberta-large-mnli",
        "distilbert/distilroberta-base",
    ]
)

ROBERTA_PRELAYERNORM_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "andreasmadsen/efficient_mlm_m0.40": "XXXX"
    }
)

ROBERTA_PRELAYERNORM_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "andreasmadsen/efficient_mlm_m0.15",
        "andreasmadsen/efficient_mlm_m0.20",
        "andreasmadsen/efficient_mlm_m0.30",
        "andreasmadsen/efficient_mlm_m0.40",
        "andreasmadsen/efficient_mlm_m0.50",
        "andreasmadsen/efficient_mlm_m0.60",
        "andreasmadsen/efficient_mlm_m0.70",
        "andreasmadsen/efficient_mlm_m0.80",
    ]
)

TF_ROBERTA_PRELAYERNORM_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "andreasmadsen/efficient_mlm_m0.15",
        "andreasmadsen/efficient_mlm_m0.20",
        "andreasmadsen/efficient_mlm_m0.30",
        "andreasmadsen/efficient_mlm_m0.40",
        "andreasmadsen/efficient_mlm_m0.50",
        "andreasmadsen/efficient_mlm_m0.60",
        "andreasmadsen/efficient_mlm_m0.70",
        "andreasmadsen/efficient_mlm_m0.80",
    ]
)

ROC_BERT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"weiweishi/roc-bert-base-zh": "XXXX"}
)

ROC_BERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["weiweishi/roc-bert-base-zh"])

ROFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "junnyu/roformer_chinese_small": "XXXX",
        "junnyu/roformer_chinese_base": "XXXX",
        "junnyu/roformer_chinese_char_small": "XXXX",
        "junnyu/roformer_chinese_char_base": "XXXX",
        "junnyu/roformer_small_discriminator": "XXXX",
        "junnyu/roformer_small_generator": "XXXX",
    }
)

ROFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "junnyu/roformer_chinese_small",
        "junnyu/roformer_chinese_base",
        "junnyu/roformer_chinese_char_small",
        "junnyu/roformer_chinese_char_base",
        "junnyu/roformer_small_discriminator",
        "junnyu/roformer_small_generator",
    ]
)

TF_ROFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "junnyu/roformer_chinese_small",
        "junnyu/roformer_chinese_base",
        "junnyu/roformer_chinese_char_small",
        "junnyu/roformer_chinese_char_base",
        "junnyu/roformer_small_discriminator",
        "junnyu/roformer_small_generator",
    ]
)

RWKV_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "RWKV/rwkv-4-169m-pile": "XXXX",
        "RWKV/rwkv-4-430m-pile": "XXXX",
        "RWKV/rwkv-4-1b5-pile": "XXXX",
        "RWKV/rwkv-4-3b-pile": "XXXX",
        "RWKV/rwkv-4-7b-pile": "XXXX",
        "RWKV/rwkv-4-14b-pile": "XXXX",
        "RWKV/rwkv-raven-1b5": "XXXX",
        "RWKV/rwkv-raven-3b": "XXXXig.json",
        "RWKV/rwkv-raven-7b": "XXXX",
        "RWKV/rwkv-raven-14b": "XXXX",
    }
)

RWKV_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "RWKV/rwkv-4-169m-pile",
        "RWKV/rwkv-4-430m-pile",
        "RWKV/rwkv-4-1b5-pile",
        "RWKV/rwkv-4-3b-pile",
        "RWKV/rwkv-4-7b-pile",
        "RWKV/rwkv-4-14b-pile",
        "RWKV/rwkv-raven-1b5",
        "RWKV/rwkv-raven-3b",
        "RWKV/rwkv-raven-7b",
        "RWKV/rwkv-raven-14b",
    ]
)

SAM_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "facebook/sam-vit-huge": "XXXX",
        "facebook/sam-vit-large": "XXXX",
        "facebook/sam-vit-base": "XXXX",
    }
)

SAM_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["facebook/sam-vit-huge", "facebook/sam-vit-large", "facebook/sam-vit-base"]
)

TF_SAM_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["facebook/sam-vit-huge", "facebook/sam-vit-large", "facebook/sam-vit-base"]
)

SEAMLESS_M4T_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "facebook/hf-seamless-m4t-medium": "XXXX"
    }
)

SEAMLESS_M4T_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/hf-seamless-m4t-medium"])

SEAMLESS_M4T_V2_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"": "XXXX"}
)

SEAMLESS_M4T_V2_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/seamless-m4t-v2-large"])

SEGFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "nvidia/segformer-b0-finetuned-ade-512-512": "XXXX"
    }
)

SEGFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["nvidia/segformer-b0-finetuned-ade-512-512"])

TF_SEGFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["nvidia/segformer-b0-finetuned-ade-512-512"])

SEGGPT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"BAAI/seggpt-vit-large": "XXXX"}
)

SEGGPT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["BAAI/seggpt-vit-large"])

SEW_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"asapp/sew-tiny-100k": "XXXX"}
)

SEW_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["asapp/sew-tiny-100k", "asapp/sew-small-100k", "asapp/sew-mid-100k"]
)

SEW_D_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"asapp/sew-d-tiny-100k": "XXXX"}
)

SEW_D_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "asapp/sew-d-tiny-100k",
        "asapp/sew-d-small-100k",
        "asapp/sew-d-mid-100k",
        "asapp/sew-d-mid-k127-100k",
        "asapp/sew-d-base-100k",
        "asapp/sew-d-base-plus-100k",
        "asapp/sew-d-mid-400k",
        "asapp/sew-d-mid-k127-400k",
        "asapp/sew-d-base-plus-400k",
    ]
)

SIGLIP_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "XXXX-7/siglip-base-patch16-224": "XXXX"
    }
)

SIGLIP_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["XXXX-7/siglip-base-patch16-224"])

SPEECH_TO_TEXT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "facebook/s2t-small-librispeech-asr": "XXXX"
    }
)

SPEECH_TO_TEXT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/s2t-small-librispeech-asr"])

TF_SPEECH_TO_TEXT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/s2t-small-librispeech-asr"])

SPEECH_TO_TEXT_2_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "facebook/s2t-wav2vec2-large-en-de": "XXXX"
    }
)

SPEECHT5_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "microsoft/speecht5_asr": "XXXX",
        "microsoft/speecht5_tts": "XXXX",
        "microsoft/speecht5_vc": "XXXX",
    }
)

SPEECHT5_PRETRAINED_HIFIGAN_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"microsoft/speecht5_hifigan": "XXXX"}
)

SPEECHT5_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["microsoft/speecht5_asr", "microsoft/speecht5_tts", "microsoft/speecht5_vc"]
)

SPLINTER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "tau/splinter-base": "XXXX",
        "tau/splinter-base-qass": "XXXX",
        "tau/splinter-large": "XXXX",
        "tau/splinter-large-qass": "XXXX",
    }
)

SPLINTER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["tau/splinter-base", "tau/splinter-base-qass", "tau/splinter-large", "tau/splinter-large-qass"]
)

SQUEEZEBERT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "squeezebert/squeezebert-uncased": "XXXX",
        "squeezebert/squeezebert-mnli": "XXXX",
        "squeezebert/squeezebert-mnli-headless": "XXXX",
    }
)

SQUEEZEBERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["squeezebert/squeezebert-uncased", "squeezebert/squeezebert-mnli", "squeezebert/squeezebert-mnli-headless"]
)

STABLELM_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"stabilityai/stablelm-3b-4e1t": "XXXX"}
)

STARCODER2_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict({})

SWIFTFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"MBZUAI/swiftformer-xs": "XXXX"}
)

SWIFTFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["MBZUAI/swiftformer-xs"])

SWIN_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "microsoft/swin-tiny-patch4-window7-224": "XXXX"
    }
)

SWIN_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/swin-tiny-patch4-window7-224"])

TF_SWIN_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/swin-tiny-patch4-window7-224"])

SWIN2SR_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "caidas/swin2sr-classicalsr-x2-64": "XXXX"
    }
)

SWIN2SR_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["caidas/swin2SR-classical-sr-x2-64"])

SWINV2_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "microsoft/swinv2-tiny-patch4-window8-256": "XXXX"
    }
)

SWINV2_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/swinv2-tiny-patch4-window8-256"])

SWITCH_TRANSFORMERS_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"XXXX-7/switch-base-8": "XXXX"}
)

SWITCH_TRANSFORMERS_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "XXXX-7/switch-base-8",
        "XXXX-7/switch-base-16",
        "XXXX-7/switch-base-32",
        "XXXX-7/switch-base-64",
        "XXXX-7/switch-base-128",
        "XXXX-7/switch-base-256",
        "XXXX-7/switch-large-128",
        "XXXX-7/switch-xxl-128",
        "XXXX-7/switch-c-2048",
    ]
)

T5_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "XXXX-7-t5/t5-small": "XXXX",
        "XXXX-7-t5/t5-base": "XXXX",
        "XXXX-7-t5/t5-large": "XXXX",
        "XXXX-7-t5/t5-3b": "XXXX",
        "XXXX-7-t5/t5-11b": "XXXX",
    }
)

T5_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["XXXX-7-t5/t5-small", "XXXX-7-t5/t5-base", "XXXX-7-t5/t5-large", "XXXX-7-t5/t5-3b", "XXXX-7-t5/t5-11b"]
)

TF_T5_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["XXXX-7-t5/t5-small", "XXXX-7-t5/t5-base", "XXXX-7-t5/t5-large", "XXXX-7-t5/t5-3b", "XXXX-7-t5/t5-11b"]
)

TABLE_TRANSFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "microsoft/table-transformer-detection": "XXXX"
    }
)

TABLE_TRANSFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/table-transformer-detection"])

TAPAS_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "XXXX-7/tapas-base-finetuned-sqa": "XXXX",
        "XXXX-7/tapas-base-finetuned-wtq": "XXXX",
        "XXXX-7/tapas-base-finetuned-wikisql-supervised": "XXXX",
        "XXXX-7/tapas-base-finetuned-tabfact": "XXXX",
    }
)

TAPAS_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "XXXX-7/tapas-large",
        "XXXX-7/tapas-large-finetuned-sqa",
        "XXXX-7/tapas-large-finetuned-wtq",
        "XXXX-7/tapas-large-finetuned-wikisql-supervised",
        "XXXX-7/tapas-large-finetuned-tabfact",
        "XXXX-7/tapas-base",
        "XXXX-7/tapas-base-finetuned-sqa",
        "XXXX-7/tapas-base-finetuned-wtq",
        "XXXX-7/tapas-base-finetuned-wikisql-supervised",
        "XXXX-7/tapas-base-finetuned-tabfact",
        "XXXX-7/tapas-small",
        "XXXX-7/tapas-small-finetuned-sqa",
        "XXXX-7/tapas-small-finetuned-wtq",
        "XXXX-7/tapas-small-finetuned-wikisql-supervised",
        "XXXX-7/tapas-small-finetuned-tabfact",
        "XXXX-7/tapas-mini",
        "XXXX-7/tapas-mini-finetuned-sqa",
        "XXXX-7/tapas-mini-finetuned-wtq",
        "XXXX-7/tapas-mini-finetuned-wikisql-supervised",
        "XXXX-7/tapas-mini-finetuned-tabfact",
        "XXXX-7/tapas-tiny",
        "XXXX-7/tapas-tiny-finetuned-sqa",
        "XXXX-7/tapas-tiny-finetuned-wtq",
        "XXXX-7/tapas-tiny-finetuned-wikisql-supervised",
        "XXXX-7/tapas-tiny-finetuned-tabfact",
    ]
)

TF_TAPAS_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "XXXX-7/tapas-large",
        "XXXX-7/tapas-large-finetuned-sqa",
        "XXXX-7/tapas-large-finetuned-wtq",
        "XXXX-7/tapas-large-finetuned-wikisql-supervised",
        "XXXX-7/tapas-large-finetuned-tabfact",
        "XXXX-7/tapas-base",
        "XXXX-7/tapas-base-finetuned-sqa",
        "XXXX-7/tapas-base-finetuned-wtq",
        "XXXX-7/tapas-base-finetuned-wikisql-supervised",
        "XXXX-7/tapas-base-finetuned-tabfact",
        "XXXX-7/tapas-small",
        "XXXX-7/tapas-small-finetuned-sqa",
        "XXXX-7/tapas-small-finetuned-wtq",
        "XXXX-7/tapas-small-finetuned-wikisql-supervised",
        "XXXX-7/tapas-small-finetuned-tabfact",
        "XXXX-7/tapas-mini",
        "XXXX-7/tapas-mini-finetuned-sqa",
        "XXXX-7/tapas-mini-finetuned-wtq",
        "XXXX-7/tapas-mini-finetuned-wikisql-supervised",
        "XXXX-7/tapas-mini-finetuned-tabfact",
        "XXXX-7/tapas-tiny",
        "XXXX-7/tapas-tiny-finetuned-sqa",
        "XXXX-7/tapas-tiny-finetuned-wtq",
        "XXXX-7/tapas-tiny-finetuned-wikisql-supervised",
        "XXXX-7/tapas-tiny-finetuned-tabfact",
    ]
)

TIME_SERIES_TRANSFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "huggingface/time-series-transformer-tourism-monthly": "XXXX"
    }
)

TIME_SERIES_TRANSFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["huggingface/time-series-transformer-tourism-monthly"]
)

TIMESFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/timesformer": "XXXX"}
)

TIMESFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/timesformer-base-finetuned-k400"])

TROCR_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "microsoft/trocr-base-handwritten": "XXXX"
    }
)

TROCR_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/trocr-base-handwritten"])

TVLT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"ZinengTang/tvlt-base": "XXXX"}
)

TVLT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["ZinengTang/tvlt-base"])

TVP_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"Intel/tvp-base": "XXXX"}
)

TVP_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["Intel/tvp-base", "Intel/tvp-base-ANet"])

UDOP_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"microsoft/udop-large": "XXXX"}
)

UDOP_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/udop-large"])

UNISPEECH_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "microsoft/unispeech-large-1500h-cv": "XXXX"
    }
)

UNISPEECH_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["microsoft/unispeech-large-1500h-cv", "microsoft/unispeech-large-multi-lingual-1500h-cv"]
)

UNISPEECH_SAT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "microsoft/unispeech-sat-base-100h-libri-ft": "XXXX"
    }
)

UNISPEECH_SAT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList([])

UNIVNET_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"dg845/univnet-dev": "XXXX"}
)

UNIVNET_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["dg845/univnet-dev"])

VIDEOMAE_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"MCG-NJU/videomae-base": "XXXX"}
)

VIDEOMAE_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["MCG-NJU/videomae-base"])

VILT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"dandelin/vilt-b32-mlm": "XXXX"}
)

VILT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["dandelin/vilt-b32-mlm"])

VIPLLAVA_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"ybelkada/vip-llava-7b-hf": "XXXX"}
)

VIPLLAVA_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["llava-hf/vip-llava-7b-hf"])

VISUAL_BERT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "uclanlp/visualbert-vqa": "XXXX",
        "uclanlp/visualbert-vqa-pre": "XXXX",
        "uclanlp/visualbert-vqa-coco-pre": "XXXX",
        "uclanlp/visualbert-vcr": "XXXX",
        "uclanlp/visualbert-vcr-pre": "XXXX",
        "uclanlp/visualbert-vcr-coco-pre": "XXXX",
        "uclanlp/visualbert-nlvr2": "XXXX",
        "uclanlp/visualbert-nlvr2-pre": "XXXX",
        "uclanlp/visualbert-nlvr2-coco-pre": "XXXX",
    }
)

VISUAL_BERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "uclanlp/visualbert-vqa",
        "uclanlp/visualbert-vqa-pre",
        "uclanlp/visualbert-vqa-coco-pre",
        "uclanlp/visualbert-vcr",
        "uclanlp/visualbert-vcr-pre",
        "uclanlp/visualbert-vcr-coco-pre",
        "uclanlp/visualbert-nlvr2",
        "uclanlp/visualbert-nlvr2-pre",
        "uclanlp/visualbert-nlvr2-coco-pre",
    ]
)

VIT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"XXXX-7/vit-base-patch16-224": "XXXX"}
)

VIT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["XXXX-7/vit-base-patch16-224"])

VIT_HYBRID_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"XXXX-7/vit-hybrid-base-bit-384": "XXXX"}
)

VIT_HYBRID_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["XXXX-7/vit-hybrid-base-bit-384"])

VIT_MAE_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/vit-mae-base": "XXXX"}
)

VIT_MAE_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/vit-mae-base"])

VIT_MSN_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"sayakpaul/vit-msn-base": "XXXX"}
)

VIT_MSN_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/vit-msn-small"])

VITDET_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/vit-det-base": "XXXX"}
)

VITDET_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/vit-det-base"])

VITMATTE_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "hustvl/vitmatte-small-composition-1k": "XXXX"
    }
)

VITMATTE_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["hustvl/vitmatte-small-composition-1k"])

VITS_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/mms-tts-eng": "XXXX"}
)

VITS_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/mms-tts-eng"])

VIVIT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "XXXX-7/vivit-b-16x2-kinetics400": "XXXX"
    }
)

VIVIT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["XXXX-7/vivit-b-16x2-kinetics400"])

WAV_2_VEC_2_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/wav2vec2-base-960h": "XXXX"}
)

WAV_2_VEC_2_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "facebook/wav2vec2-base-960h",
        "facebook/wav2vec2-large-960h",
        "facebook/wav2vec2-large-960h-lv60",
        "facebook/wav2vec2-large-960h-lv60-self",
    ]
)

TF_WAV_2_VEC_2_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "facebook/wav2vec2-base-960h",
        "facebook/wav2vec2-large-960h",
        "facebook/wav2vec2-large-960h-lv60",
        "facebook/wav2vec2-large-960h-lv60-self",
    ]
)

WAV2VEC2_BERT_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/w2v-bert-2.0": "XXXX"}
)

WAV2VEC2_BERT_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/w2v-bert-2.0"])

WAV2VEC2_CONFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "facebook/wav2vec2-conformer-rel-pos-large": "XXXX"
    }
)

WAV2VEC2_CONFORMER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/wav2vec2-conformer-rel-pos-large"])

WAVLM_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"microsoft/wavlm-base": "XXXX"}
)

WAVLM_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["microsoft/wavlm-base", "microsoft/wavlm-base-plus", "microsoft/wavlm-large"]
)

WHISPER_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"openai/whisper-base": "XXXX"}
)

WHISPER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["openai/whisper-base"])

TF_WHISPER_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["openai/whisper-base"])

XCLIP_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"microsoft/xclip-base-patch32": "XXXX"}
)

XCLIP_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/xclip-base-patch32"])

XGLM_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"facebook/xglm-564M": "XXXX"}
)

XGLM_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/xglm-564M"])

TF_XGLM_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/xglm-564M"])

XLM_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "FacebookAI/xlm-mlm-en-2048": "XXXX",
        "FacebookAI/xlm-mlm-ende-1024": "XXXX",
        "FacebookAI/xlm-mlm-enfr-1024": "XXXX",
        "FacebookAI/xlm-mlm-enro-1024": "XXXX",
        "FacebookAI/xlm-mlm-tlm-xnli15-1024": "XXXX",
        "FacebookAI/xlm-mlm-xnli15-1024": "XXXX",
        "FacebookAI/xlm-clm-enfr-1024": "XXXX",
        "FacebookAI/xlm-clm-ende-1024": "XXXX",
        "FacebookAI/xlm-mlm-17-1280": "XXXX",
        "FacebookAI/xlm-mlm-100-1280": "XXXX",
    }
)

XLM_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "FacebookAI/xlm-mlm-en-2048",
        "FacebookAI/xlm-mlm-ende-1024",
        "FacebookAI/xlm-mlm-enfr-1024",
        "FacebookAI/xlm-mlm-enro-1024",
        "FacebookAI/xlm-mlm-tlm-xnli15-1024",
        "FacebookAI/xlm-mlm-xnli15-1024",
        "FacebookAI/xlm-clm-enfr-1024",
        "FacebookAI/xlm-clm-ende-1024",
        "FacebookAI/xlm-mlm-17-1280",
        "FacebookAI/xlm-mlm-100-1280",
    ]
)

TF_XLM_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "FacebookAI/xlm-mlm-en-2048",
        "FacebookAI/xlm-mlm-ende-1024",
        "FacebookAI/xlm-mlm-enfr-1024",
        "FacebookAI/xlm-mlm-enro-1024",
        "FacebookAI/xlm-mlm-tlm-xnli15-1024",
        "FacebookAI/xlm-mlm-xnli15-1024",
        "FacebookAI/xlm-clm-enfr-1024",
        "FacebookAI/xlm-clm-ende-1024",
        "FacebookAI/xlm-mlm-17-1280",
        "FacebookAI/xlm-mlm-100-1280",
    ]
)

XLM_PROPHETNET_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "microsoft/xprophetnet-large-wiki100-cased": "XXXX"
    }
)

XLM_PROPHETNET_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["microsoft/xprophetnet-large-wiki100-cased"])

XLM_ROBERTA_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "FacebookAI/xlm-roberta-base": "XXXX",
        "FacebookAI/xlm-roberta-large": "XXXX",
        "FacebookAI/xlm-roberta-large-finetuned-conll02-dutch": "XXXX",
        "FacebookAI/xlm-roberta-large-finetuned-conll02-spanish": "XXXX",
        "FacebookAI/xlm-roberta-large-finetuned-conll03-english": "XXXX",
        "FacebookAI/xlm-roberta-large-finetuned-conll03-german": "XXXX",
    }
)

XLM_ROBERTA_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "FacebookAI/xlm-roberta-base",
        "FacebookAI/xlm-roberta-large",
        "FacebookAI/xlm-roberta-large-finetuned-conll02-dutch",
        "FacebookAI/xlm-roberta-large-finetuned-conll02-spanish",
        "FacebookAI/xlm-roberta-large-finetuned-conll03-english",
        "FacebookAI/xlm-roberta-large-finetuned-conll03-german",
    ]
)

TF_XLM_ROBERTA_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "FacebookAI/xlm-roberta-base",
        "FacebookAI/xlm-roberta-large",
        "joeddav/xlm-roberta-large-xnli",
        "cardiffnlp/twitter-xlm-roberta-base-sentiment",
    ]
)

FLAX_XLM_ROBERTA_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    ["FacebookAI/xlm-roberta-base", "FacebookAI/xlm-roberta-large"]
)

XLM_ROBERTA_XL_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "facebook/xlm-roberta-xl": "XXXX",
        "facebook/xlm-roberta-xxl": "XXXX",
    }
)

XLM_ROBERTA_XL_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["facebook/xlm-roberta-xl", "facebook/xlm-roberta-xxl"])

XLNET_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "xlnet/xlnet-base-cased": "XXXX",
        "xlnet/xlnet-large-cased": "XXXX",
    }
)

XLNET_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["xlnet/xlnet-base-cased", "xlnet/xlnet-large-cased"])

TF_XLNET_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["xlnet/xlnet-base-cased", "xlnet/xlnet-large-cased"])

XMOD_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {
        "facebook/xmod-base": "XXXX",
        "facebook/xmod-large-prenorm": "XXXX",
        "facebook/xmod-base-13-125k": "XXXX/resolve/main/config.json",
        "facebook/xmod-base-30-125k": "XXXX",
        "facebook/xmod-base-30-195k": "XXXX",
        "facebook/xmod-base-60-125k": "XXXX",
        "facebook/xmod-base-60-265k": "XXXX",
        "facebook/xmod-base-75-125k": "XXXX",
        "facebook/xmod-base-75-269k": "XXXX",
    }
)

XMOD_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(
    [
        "facebook/xmod-base",
        "facebook/xmod-large-prenorm",
        "facebook/xmod-base-13-125k",
        "facebook/xmod-base-30-125k",
        "facebook/xmod-base-30-195k",
        "facebook/xmod-base-60-125k",
        "facebook/xmod-base-60-265k",
        "facebook/xmod-base-75-125k",
        "facebook/xmod-base-75-269k",
    ]
)

YOLOS_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"hustvl/yolos-small": "XXXX"}
)

YOLOS_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["hustvl/yolos-small"])

YOSO_PRETRAINED_CONFIG_ARCHIVE_MAP = DeprecatedDict(
    {"uw-madison/yoso-4096": "XXXX"}
)

YOSO_PRETRAINED_MODEL_ARCHIVE_LIST = DeprecatedList(["uw-madison/yoso-4096"])


CONFIG_ARCHIVE_MAP_MAPPING_NAMES = OrderedDict(
    [
        # Add archive maps here)
        ("albert", "ALBERT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("align", "ALIGN_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("altclip", "ALTCLIP_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("audio-spectrogram-transformer", "AUDIO_SPECTROGRAM_TRANSFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("autoformer", "AUTOFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("bark", "BARK_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("bart", "BART_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("beit", "BEIT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("bert", "BERT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("big_bird", "BIG_BIRD_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("bigbird_pegasus", "BIGBIRD_PEGASUS_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("biogpt", "BIOGPT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("bit", "BIT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("blenderbot", "BLENDERBOT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("blenderbot-small", "BLENDERBOT_SMALL_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("blip", "BLIP_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("blip-2", "BLIP_2_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("bloom", "BLOOM_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("bridgetower", "BRIDGETOWER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("bros", "BROS_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("camembert", "CAMEMBERT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("canine", "CANINE_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("chinese_clip", "CHINESE_CLIP_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("clap", "CLAP_PRETRAINED_MODEL_ARCHIVE_LIST"),
        ("clip", "CLIP_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("clipseg", "CLIPSEG_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("clvp", "CLVP_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("codegen", "CODEGEN_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("conditional_detr", "CONDITIONAL_DETR_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("convbert", "CONVBERT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("convnext", "CONVNEXT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("convnextv2", "CONVNEXTV2_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("cpmant", "CPMANT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("ctrl", "CTRL_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("cvt", "CVT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("data2vec-audio", "DATA2VEC_AUDIO_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("data2vec-text", "DATA2VEC_TEXT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("data2vec-vision", "DATA2VEC_VISION_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("deberta", "DEBERTA_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("deberta-v2", "DEBERTA_V2_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("deformable_detr", "DEFORMABLE_DETR_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("deit", "DEIT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("depth_anything", "DEPTH_ANYTHING_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("deta", "DETA_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("detr", "DETR_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("dinat", "DINAT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("dinov2", "DINOV2_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("distilbert", "DISTILBERT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("donut-swin", "DONUT_SWIN_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("dpr", "DPR_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("dpt", "DPT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("efficientformer", "EFFICIENTFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("efficientnet", "EFFICIENTNET_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("electra", "ELECTRA_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("encodec", "ENCODEC_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("ernie", "ERNIE_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("ernie_m", "ERNIE_M_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("esm", "ESM_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("falcon", "FALCON_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("fastspeech2_conformer", "FASTSPEECH2_CONFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("flaubert", "FLAUBERT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("flava", "FLAVA_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("fnet", "FNET_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("focalnet", "FOCALNET_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("fsmt", "FSMT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("funnel", "FUNNEL_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("fuyu", "FUYU_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("gemma", "GEMMA_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("git", "GIT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("glpn", "GLPN_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("gpt2", "GPT2_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("gpt_bigcode", "GPT_BIGCODE_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("gpt_neo", "GPT_NEO_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("gpt_neox", "GPT_NEOX_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("gpt_neox_japanese", "GPT_NEOX_JAPANESE_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("gptj", "GPTJ_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("gptsan-japanese", "GPTSAN_JAPANESE_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("graphormer", "GRAPHORMER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("groupvit", "GROUPVIT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("hubert", "HUBERT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("ibert", "IBERT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("idefics", "IDEFICS_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("imagegpt", "IMAGEGPT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("informer", "INFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("instructblip", "INSTRUCTBLIP_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("jukebox", "JUKEBOX_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("kosmos-2", "KOSMOS2_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("layoutlm", "LAYOUTLM_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("layoutlmv2", "LAYOUTLMV2_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("layoutlmv3", "LAYOUTLMV3_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("led", "LED_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("levit", "LEVIT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("lilt", "LILT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("llama", "LLAMA_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("llava", "LLAVA_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("longformer", "LONGFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("longt5", "LONGT5_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("luke", "LUKE_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("lxmert", "LXMERT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("m2m_100", "M2M_100_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("mamba", "MAMBA_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("markuplm", "MARKUPLM_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("mask2former", "MASK2FORMER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("maskformer", "MASKFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("mbart", "MBART_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("mctct", "MCTCT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("mega", "MEGA_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("megatron-bert", "MEGATRON_BERT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("mgp-str", "MGP_STR_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("mistral", "MISTRAL_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("mixtral", "MIXTRAL_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("mobilenet_v1", "MOBILENET_V1_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("mobilenet_v2", "MOBILENET_V2_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("mobilevit", "MOBILEVIT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("mobilevitv2", "MOBILEVITV2_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("mpnet", "MPNET_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("mpt", "MPT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("mra", "MRA_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("musicgen", "MUSICGEN_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("mvp", "MVP_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("nat", "NAT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("nezha", "NEZHA_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("nllb-moe", "NLLB_MOE_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("nystromformer", "NYSTROMFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("oneformer", "ONEFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("olmo", "OLMO_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("open-llama", "OPEN_LLAMA_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("openai-gpt", "OPENAI_GPT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("opt", "OPT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("owlv2", "OWLV2_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("owlvit", "OWLVIT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("patchtsmixer", "PATCHTSMIXER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("patchtst", "PATCHTST_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("pegasus", "PEGASUS_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("pegasus_x", "PEGASUS_X_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("perceiver", "PERCEIVER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("persimmon", "PERSIMMON_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("phi", "PHI_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("pix2struct", "PIX2STRUCT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("plbart", "PLBART_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("poolformer", "POOLFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("pop2piano", "POP2PIANO_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("prophetnet", "PROPHETNET_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("pvt", "PVT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("qdqbert", "QDQBERT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("qwen2", "QWEN2_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("realm", "REALM_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("regnet", "REGNET_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("rembert", "REMBERT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("resnet", "RESNET_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("retribert", "RETRIBERT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("roberta", "ROBERTA_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("roberta-prelayernorm", "ROBERTA_PRELAYERNORM_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("roc_bert", "ROC_BERT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("roformer", "ROFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("rwkv", "RWKV_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("sam", "SAM_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("seamless_m4t", "SEAMLESS_M4T_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("seamless_m4t_v2", "SEAMLESS_M4T_V2_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("segformer", "SEGFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("seggpt", "SEGGPT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("sew", "SEW_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("sew-d", "SEW_D_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("siglip", "SIGLIP_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("speech_to_text", "SPEECH_TO_TEXT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("speech_to_text_2", "SPEECH_TO_TEXT_2_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("speecht5", "SPEECHT5_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("splinter", "SPLINTER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("squeezebert", "SQUEEZEBERT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("stablelm", "STABLELM_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("starcoder2", "STARCODER2_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("swiftformer", "SWIFTFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("swin", "SWIN_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("swin2sr", "SWIN2SR_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("swinv2", "SWINV2_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("switch_transformers", "SWITCH_TRANSFORMERS_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("t5", "T5_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("table-transformer", "TABLE_TRANSFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("tapas", "TAPAS_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("time_series_transformer", "TIME_SERIES_TRANSFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("timesformer", "TIMESFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("transfo-xl", "TRANSFO_XL_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("tvlt", "TVLT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("tvp", "TVP_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("udop", "UDOP_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("unispeech", "UNISPEECH_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("unispeech-sat", "UNISPEECH_SAT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("univnet", "UNIVNET_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("van", "VAN_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("videomae", "VIDEOMAE_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("vilt", "VILT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("vipllava", "VIPLLAVA_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("visual_bert", "VISUAL_BERT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("vit", "VIT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("vit_hybrid", "VIT_HYBRID_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("vit_mae", "VIT_MAE_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("vit_msn", "VIT_MSN_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("vitdet", "VITDET_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("vitmatte", "VITMATTE_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("vits", "VITS_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("vivit", "VIVIT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("wav2vec2", "WAV_2_VEC_2_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("wav2vec2-bert", "WAV2VEC2_BERT_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("wav2vec2-conformer", "WAV2VEC2_CONFORMER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("whisper", "WHISPER_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("xclip", "XCLIP_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("xglm", "XGLM_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("xlm", "XLM_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("xlm-prophetnet", "XLM_PROPHETNET_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("xlm-roberta", "XLM_ROBERTA_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("xlnet", "XLNET_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("xmod", "XMOD_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("yolos", "YOLOS_PRETRAINED_CONFIG_ARCHIVE_MAP"),
        ("yoso", "YOSO_PRETRAINED_CONFIG_ARCHIVE_MAP"),
    ]
)
