<!---
Copyright 2020 The HuggingFace Team. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    XXXX

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# Examples

We host a wide range of example scripts for multiple learning frameworks. Simply choose your favorite: [TensorFlow](XXXX), [PyTorch](XXXX) or [JAX/Flax](XXXX).

We also have some [research projects](XXXX), as well as some [legacy examples](XXXX). Note that unlike the main examples these are not actively maintained, and may require specific older versions of dependencies in order to run. 

While we strive to present as many use cases as possible, the example scripts are just that - examples. It is expected that they won't work out-of-the box on your specific problem and that you will be required to change a few lines of code to adapt them to your needs. To help you with that, most of the examples fully expose the preprocessing of the data, allowing you to tweak and edit them as required.

Please discuss on the [forum](XXXX) or in an [issue](XXXX) a feature you would like to implement in an example before submitting a PR; we welcome bug fixes, but since we want to keep the examples as simple as possible it's unlikely that we will merge a pull request adding more functionality at the cost of readability.

## Important note

**Important**

To make sure you can successfully run the latest versions of the example scripts, you have to **install the library from source** and install some example-specific requirements. To do this, execute the following steps in a new virtual environment:
```bash
git clone XXXX
cd transformers
pip install .
```
Then cd in the example folder of your choice and run
```bash
pip install -r requirements.txt
```

To browse the examples corresponding to released versions of 🤗 Transformers, click on the line below and then on your desired version of the library:

<details>
  <summary>Examples for older versions of 🤗 Transformers</summary>
	<ul>
	    <li><a href="XXXX">v4.21.0</a></li>
		<li><a href="XXXX">v4.20.1</a></li>
		<li><a href="XXXX">v4.19.4</a></li>
		<li><a href="XXXX">v4.18.0</a></li>
		<li><a href="XXXX">v4.17.0</a></li>
		<li><a href="XXXX">v4.16.2</a></li>
		<li><a href="XXXX">v4.15.0</a></li>
		<li><a href="XXXX">v4.14.1</a></li>
		<li><a href="XXXX">v4.13.0</a></li>
		<li><a href="XXXX">v4.12.5</a></li>
	    <li><a href="XXXX">v4.11.3</a></li>
	    <li><a href="XXXX">v4.10.3</a></li>
	    <li><a href="XXXX">v4.9.2</a></li>
	    <li><a href="XXXX">v4.8.2</a></li>
	    <li><a href="XXXX">v4.7.0</a></li>
	    <li><a href="XXXX">v4.6.1</a></li>
		<li><a href="XXXX">v4.5.1</a></li>
		<li><a href="XXXX">v4.4.2</a></li>
		<li><a href="XXXX">v4.3.3</a></li>
		<li><a href="XXXX">v4.2.2</a></li>
		<li><a href="XXXX">v4.1.1</a></li>
		<li><a href="XXXX">v4.0.1</a></li>
		<li><a href="XXXX">v3.5.1</a></li>
		<li><a href="XXXX">v3.4.0</a></li>
		<li><a href="XXXX">v3.3.1</a></li>
		<li><a href="XXXX">v3.2.0</a></li>
		<li><a href="XXXX">v3.1.0</a></li>
		<li><a href="XXXX">v3.0.2</a></li>
		<li><a href="XXXX">v2.11.0</a></li>
		<li><a href="XXXX">v2.10.0</a></li>
		<li><a href="XXXX">v2.9.1</a></li>
		<li><a href="XXXX">v2.8.0</a></li>
		<li><a href="XXXX">v2.7.0</a></li>
		<li><a href="XXXX">v2.6.0</a></li>
		<li><a href="XXXX">v2.5.1</a></li>
		<li><a href="XXXX.4.0/examples">v2.4.0</a></li>
		<li><a href="XXXX">v2.3.0</a></li>
		<li><a href="XXXX">v2.2.0</a></li>
		<li><a href="XXXX">v2.1.1</a></li>
		<li><a href="XXXX">v2.0.0</a></li>
		<li><a href="XXXX">v1.2.0</a></li>
		<li><a href="XXXX">v1.1.0</a></li>
		<li><a href="XXXX">v1.0.0</a></li>
	</ul>
</details>

Alternatively, you can switch your cloned 🤗 Transformers to a specific version (for instance with v3.5.1) with
```bash
git checkout tags/v3.5.1
```
and run the example command as usual afterward.
