<!---
Copyright 2020 The HuggingFace Team. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    XXXX

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# 🤗 Transformers Notebooks

You can find here a list of the official notebooks provided by Hugging Face.

Also, we would like to list here interesting content created by the community.
If you wrote some notebook(s) leveraging 🤗 Transformers and would like be listed here, please open a
Pull Request so it can be included under the Community notebooks.


## Hugging Face's notebooks 🤗

### Documentation notebooks

You can open any page of the documentation as a notebook in colab (there is a button directly on said pages) but they are also listed here if you need to:

| Notebook     |      Description      |   |   |
|:----------|:-------------|:-------------|------:|
| [Quicktour of the library](XXXX)  | A presentation of the various APIs in Transformers |[XXXX](XXXX)| [XXXX](XXXX)|
| [Summary of the tasks](XXXX)  | How to run the models of the Transformers library task by task |[XXXX](XXXX)| [XXXX](XXXX)|
| [Preprocessing data](XXXX)  | How to use a tokenizer to preprocess your data |[XXXX](XXXX)| [XXXX](XXXX)|
| [Fine-tuning a pretrained model](XXXX)  | How to use the Trainer to fine-tune a pretrained model |[XXXX](XXXX)| [XXXX](XXXX)|
| [Summary of the tokenizers](XXXX)  | The differences between the tokenizers algorithm |[XXXX](XXXX)| [XXXX](XXXX)|
| [Multilingual models](XXXX)  | How to use the multilingual models of the library |[XXXX](XXXX)| [XXXX](XXXX)|


### PyTorch Examples

| Notebook     |      Description      |   |   |
|:----------|:-------------|:-------------|------:|
| [Train your tokenizer](XXXX)  | How to train and use your very own tokenizer  |[XXXX](XXXX)| [XXXX](XXXX)|
| [Train your language model](XXXXfrom_scratch.ipynb)   | How to easily start using transformers  |[XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a model on text classification](XXXX)| Show how to preprocess the data and fine-tune a pretrained model on any GLUE task. | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a model on language modeling](XXXX)| Show how to preprocess the data and fine-tune a pretrained model on a causal or masked LM task. | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a model on token classification](XXXX)| Show how to preprocess the data and fine-tune a pretrained model on a token classification task (NER, PoS). | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a model on question answering](XXXX)| Show how to preprocess the data and fine-tune a pretrained model on SQUAD. | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a model on multiple choice](XXXX)| Show how to preprocess the data and fine-tune a pretrained model on SWAG. | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a model on translation](XXXX)| Show how to preprocess the data and fine-tune a pretrained model on WMT. | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a model on summarization](XXXX)| Show how to preprocess the data and fine-tune a pretrained model on XSUM. | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a speech recognition model in English](XXXX)| Show how to preprocess the data and fine-tune a pretrained Speech model on TIMIT | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a speech recognition model in any language](XXXX)| Show how to preprocess the data and fine-tune a multi-lingually pretrained speech model on Common Voice | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a model on audio classification](XXXX)| Show how to preprocess the data and fine-tune a pretrained Speech model on Keyword Spotting | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to train a language model from scratch](XXXX)| Highlight all the steps to effectively train Transformer model on custom data | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to generate text](XXXX)| How to use different decoding methods for language generation with transformers | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to generate text (with constraints)](XXXX)| How to guide language generation with user-provided constraints | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to export model to ONNX](XXXX)| Highlight how to export and run inference workloads through ONNX |
| [How to use Benchmarks](XXXX)| How to benchmark models with transformers | [XXXX](XXXX)| [XXXX](XXXX)|
| [Reformer](XXXX)| How Reformer pushes the limits of language modeling | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a model on image classification (Torchvision)](XXXX) | Show how to preprocess the data using Torchvision and fine-tune any pretrained Vision model on Image Classification | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a model on image classification (Albumentations)](XXXX) | Show how to preprocess the data using Albumentations and fine-tune any pretrained Vision model on Image Classification | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to perform zero-shot object detection with OWL-ViT](XXXX) | Show how to perform zero-shot object detection on images with text queries| [XXXX](XXXX.research.XXXX-7.com/github/huggingface/notebooks/blob/main/examples/zeroshot_object_detection_with_owlvit.ipynb)| [XXXX](XXXX)|
| [How to fine-tune a pre-trained protein model](XXXX) | See how to tokenize proteins and fine-tune a large pre-trained protein "language" model | [XXXX](XXXX) | [XXXX](XXXX) |
| [How to generate protein folds](XXXX) | See how to go from protein sequence to a full protein model and PDB file | [XXXX](XXXX) | [XXXX](XXXX) |

### TensorFlow Examples

| Notebook     |      Description      |   |   |
|:----------|:-------------|:-------------|------:|
| [Train your tokenizer](XXXX)  | How to train and use your very own tokenizer  |[XXXX](XXXX)| [XXXX](XXXX)|
| [Train your language model](XXXX)   | How to easily start using transformers  |[XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a model on text classification](XXXX)| Show how to preprocess the data and fine-tune a pretrained model on any GLUE task. | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a model on language modeling](XXXX)| Show how to preprocess the data and fine-tune a pretrained model on a causal or masked LM task. | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a model on token classification](XXXX)| Show how to preprocess the data and fine-tune a pretrained model on a token classification task (NER, PoS). | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a model on question answering](XXXX)| Show how to preprocess the data and fine-tune a pretrained model on SQUAD. | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a model on multiple choice](XXXX)| Show how to preprocess the data and fine-tune a pretrained model on SWAG. | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a model on translation](XXXX)| Show how to preprocess the data and fine-tune a pretrained model on WMT. | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a model on summarization](XXXX)| Show how to preprocess the data and fine-tune a pretrained model on XSUM. | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a pre-trained protein model](XXXX) | See how to tokenize proteins and fine-tune a large pre-trained protein "language" model | [XXXX](XXXX) | [XXXX](XXXX) |

### Optimum notebooks

🤗  [Optimum](XXXX) is an extension of 🤗 Transformers, providing a set of performance optimization tools enabling maximum efficiency to train and run models on targeted hardwares.

| Notebook     |      Description      |   |   |
|:----------|:-------------|:-------------|------:|
| [How to quantize a model with ONNX Runtime for text classification](XXXX)| Show how to apply static and dynamic quantization on a model using [ONNX Runtime](XXXX) for any GLUE task. | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to quantize a model with Intel Neural Compressor for text classification](XXXX)| Show how to apply static, dynamic and aware training quantization on a model using [Intel Neural Compressor (INC)](XXXX) for any GLUE task. | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a model on text classification with ONNX Runtime](XXXX)| Show how to preprocess the data and fine-tune a model on any GLUE task using [ONNX Runtime](XXXX). | [XXXX](XXXX)| [XXXX](XXXX)|
| [How to fine-tune a model on summarization with ONNX Runtime](XXXX)| Show how to preprocess the data and fine-tune a model on XSUM using [ONNX Runtime](XXXX). | [XXXX](XXXX)| [XXXX](XXXX)|

## Community notebooks:

More notebooks developed by the community are available [here](XXXX).
