<!---
Copyright 2020 The HuggingFace Team. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    XXXX

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

<!---
A useful guide for English-Traditional Chinese translation of Hugging Face documentation
- Add space around English words and numbers when they appear between Chinese characters. E.g., 共 100 多種語言; 使用 transformers 函式庫。
- Use square quotes, e.g.,「引用」
- Some of terms in the file can be found at National Academy for Educational Research (XXXX), an official website providing bilingual translations between English and Traditional Chinese.

Dictionary

API: API (不翻譯）
add: 加入
checkpoint: 檢查點
code: 程式碼
community: 社群
confidence: 信賴度
dataset: 資料集
documentation: 文件
example: 基本翻譯為「範例」，或依語意翻為「例子」
finetune: 微調
Hugging Face: Hugging Face（不翻譯）
implementation: 實作
inference: 推論
library: 函式庫
module: 模組
NLP/Natural Language Processing: 以 NLP 出現時不翻譯，以 Natural Language Processing 出現時翻譯為自然語言處理
online demos: 線上Demo
pipeline: pipeline（不翻譯）
pretrained/pretrain: 預訓練
Python data structures (e.g., list, set, dict): 翻譯為串列，集合，字典，並用括號標註原英文
repository: repository（不翻譯）
summary: 概覽
token-: token-（不翻譯）
Trainer: Trainer（不翻譯）
transformer: transformer（不翻譯）
tutorial: 教學
user: 使用者
-->

<p align="center">
    <br>
    <img src="XXXX" width="400"/>
    <br>
<p>
<p align="center">
    <a href="XXXX">
        <img alt="Build" src="XXXX">
    </a>
    <a href="XXXX">
        <img alt="GitHub" src="XXXX">
    </a>
    <a href="XXXX">
        <img alt="Documentation" src="XXXX">
    </a>
    <a href="XXXX">
        <img alt="GitHub release" src="XXXX">
    </a>
    <a href="XXXX">
        <img alt="Contributor Covenant" src="XXXX">
    </a>
    <a href="XXXX"><img src="XXXX" alt="DOI"></a>
</p>

<h4 align="center">
    <p>
        <a href="XXXX">English</a> |
        <a href="XXXX">简体中文</a> |
        <b>繁體中文</b> |
        <a href="XXXX">한국어</a> |
        <a href="XXXX">Español</a> |
        <a href="XXXX">日本語</a> |
        <a href="XXXX">हिन्दी</a>
    <p>
</h4>

<h3 align="center">
    <p>為 Jax、PyTorch 以及 TensorFlow 打造的先進自然語言處理函式庫</p>
</h3>

<h3 align="center">
    <a href="XXXX"><img src="XXXX"></a>
</h3>

🤗 Transformers 提供了數以千計的預訓練模型，支援 100 多種語言的文本分類、資訊擷取、問答、摘要、翻譯、文本生成。它的宗旨是讓最先進的 NLP 技術人人易用。

🤗 Transformers 提供了便於快速下載和使用的API，讓你可以將預訓練模型用在給定文本、在你的資料集上微調然後經由 [model hub](XXXX) 與社群共享。同時，每個定義的 Python 模組架構均完全獨立，方便修改和快速研究實驗。

🤗 Transformers 支援三個最熱門的深度學習函式庫： [Jax](XXXX), [PyTorch](XXXX) 以及 [TensorFlow](XXXX) — 並與之完美整合。你可以直接使用其中一個框架訓練你的模型，然後用另一個載入和推論。

## 線上Demo

你可以直接在 [model hub](XXXX) 上測試大多數的模型。我們也提供了 [私有模型託管、模型版本管理以及推論API](XXXXcing)。

這裡是一些範例：
- [用 BERT 做遮蓋填詞](XXXX)
- [用 Electra 做專有名詞辨識](XXXX)
- [用 GPT-2 做文本生成](XXXX+)
- [用 RoBERTa 做自然語言推論](XXXX)
- [用 BART 做文本摘要](XXXX)
- [用 DistilBERT 做問答](XXXX)
- [用 T5 做翻譯](XXXXt5-base?text=My+name+is+Wolfgang+and+I+live+in+Berlin)

**[Write With Transformer](XXXX)**，由 Hugging Face 團隊所打造，是一個文本生成的官方 demo。

## 如果你在尋找由 Hugging Face 團隊所提供的客製化支援服務

<a target="_blank" href="XXXX">
    <img alt="HuggingFace Expert Acceleration Program" src="XXXX" style="max-width: 600px; border: 1px solid #eee; border-radius: 4px; box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);">
</a><br>

## 快速上手

我們為快速使用模型提供了 `pipeline` API。 Pipeline 包含了預訓練模型和對應的文本預處理。下面是一個快速使用 pipeline 去判斷正負面情緒的例子：

```python
>>> from transformers import pipeline

# 使用情緒分析 pipeline
>>> classifier = pipeline('sentiment-analysis')
>>> classifier('We are very happy to introduce pipeline to the transformers repository.')
[{'label': 'POSITIVE', 'score': 0.9996980428695679}]
```

第二行程式碼下載並快取 pipeline 使用的預訓練模型，而第三行程式碼則在給定的文本上進行了評估。這裡的答案“正面” (positive) 具有 99.97% 的信賴度。

許多的 NLP 任務都有隨選即用的預訓練 `pipeline`。例如，我們可以輕鬆地從給定文本中擷取問題答案：

``` python
>>> from transformers import pipeline

# 使用問答 pipeline
>>> question_answerer = pipeline('question-answering')
>>> question_answerer({
...     'question': 'What is the name of the repository ?',
...     'context': 'Pipeline has been included in the huggingface/transformers repository'
... })
{'score': 0.30970096588134766, 'start': 34, 'end': 58, 'answer': 'huggingface/transformers'}

```

除了提供問題解答，預訓練模型還提供了對應的信賴度分數以及解答在 tokenized 後的文本中開始和結束的位置。你可以從[這個教學](XXXX)了解更多 `pipeline` API支援的任務。

要在你的任務中下載和使用任何預訓練模型很簡單，只需三行程式碼。這裡是 PyTorch 版的範例：
```python
>>> from transformers import AutoTokenizer, AutoModel

>>> tokenizer = AutoTokenizer.from_pretrained("bert-base-uncased")
>>> model = AutoModel.from_pretrained("bert-base-uncased")

>>> inputs = tokenizer("Hello world!", return_tensors="pt")
>>> outputs = model(**inputs)
```
這裡是對應的 TensorFlow 程式碼：
```python
>>> from transformers import AutoTokenizer, TFAutoModel

>>> tokenizer = AutoTokenizer.from_pretrained("bert-base-uncased")
>>> model = TFAutoModel.from_pretrained("bert-base-uncased")

>>> inputs = tokenizer("Hello world!", return_tensors="tf")
>>> outputs = model(**inputs)
```

Tokenizer 為所有的預訓練模型提供了預處理，並可以直接轉換單一字串（比如上面的例子）或串列 (list)。它會輸出一個的字典 (dict) 讓你可以在下游程式碼裡使用或直接藉由 `**` 運算式傳給模型。

模型本身是一個常規的 [Pytorch `nn.Module`](XXXX) 或 [TensorFlow `tf.keras.Model`](XXXX)（取決於你的後端），可依常規方式使用。 [這個教學](XXXX)解釋了如何將這樣的模型整合到一般的 PyTorch 或 TensorFlow 訓練迴圈中，或是如何使用我們的 `Trainer` API 在一個新的資料集上快速進行微調。

## 為什麼要用 transformers？

1. 便於使用的先進模型：
    - NLU 和 NLG 上性能卓越
    - 對教學和實作友好且低門檻
    - 高度抽象，使用者只須學習 3 個類別
    - 對所有模型使用的制式化API

1. 更低的運算成本，更少的碳排放：
    - 研究人員可以分享已訓練的模型而非每次從頭開始訓練
    - 工程師可以減少計算時間以及生產成本
    - 數十種模型架構、兩千多個預訓練模型、100多種語言支援

1. 對於模型生命週期的每一個部分都面面俱到：
    - 訓練先進的模型，只需 3 行程式碼
    - 模型可以在不同深度學習框架之間任意轉換
    - 為訓練、評估和生產選擇最適合的框架，並完美銜接

1. 為你的需求輕鬆客製化專屬模型和範例：
    - 我們為每種模型架構提供了多個範例來重現原論文結果
    - 一致的模型內部架構
    - 模型檔案可單獨使用，便於修改和快速實驗

## 什麼情況下我不該用 transformers？

- 本函式庫並不是模組化的神經網絡工具箱。模型文件中的程式碼並未做額外的抽象封裝，以便研究人員快速地翻閱及修改程式碼，而不會深陷複雜的類別包裝之中。
- `Trainer` API 並非相容任何模型，它只為本函式庫中的模型最佳化。對於一般的機器學習用途，請使用其他函式庫。
- 儘管我們已盡力而為，[examples 目錄](XXXX)中的腳本也僅為範例而已。對於特定問題，它們並不一定隨選即用，可能需要修改幾行程式碼以符合需求。

## 安裝

### 使用 pip

這個 Repository 已在 Python 3.6+、Flax 0.3.2+、PyTorch 1.3.1+ 和 TensorFlow 2.3+ 下經過測試。

你可以在[虛擬環境](XXXX)中安裝 🤗 Transformers。如果你還不熟悉 Python 的虛擬環境，請閱此[使用者指引](XXXX)。

首先，用你打算使用的版本的 Python 創建一個虛擬環境並進入。

然後，你需要安裝 Flax、PyTorch 或 TensorFlow 其中之一。對於該如何在你使用的平台上���裝這些框架，請參閱 [TensorFlow 安裝頁面](XXXX), [PyTorch 安裝頁面](XXXX) 或 [Flax 安裝頁面](XXXX)。

當其中一個後端安裝成功後，🤗 Transformers 可依此安裝：

```bash
pip install transformers
```

如果你想要試試範例或者想在正式發布前使用最新開發中的程式碼，你必須[從原始碼安裝](XXXX)。

### 使用 conda

自 Transformers 4.0.0 版始，我們有了一個 conda channel： `huggingface`。

🤗 Transformers 可以藉由 conda 依此安裝：

```shell script
conda install -c huggingface transformers
```

要藉由 conda 安裝 Flax、PyTorch 或 TensorFlow 其中之一，請參閱它們各自安裝頁面的說明。

## 模型架構

**🤗 Transformers 支援的[所有的模型檢查點](XXXX)**，由[使用者](XXXX)和[組織](XXXX)上傳，均與 huggingface.co [model hub](XXXX) 完美結合。

目前的檢查點數量： XXXX

🤗 Transformers 目前支援以下的架構（模型概覽請參閱[這裡](XXXX)）：

1. **[ALBERT](XXXX)** (from XXXX-7 Research and the Toyota Technological Institute at Chicago) released with the paper [ALBERT: A Lite BERT for Self-supervised Learning of Language Representations](XXXX), by Zhenzhong Lan, Mingda Chen, Sebastian Goodman, Kevin Gimpel, Piyush Sharma, Radu Soricut.
1. **[Audio Spectrogram Transformer](XXXX)** (from MIT) released with the paper [AST: Audio Spectrogram Transformer](XXXX) by Yuan Gong, Yu-An Chung, James Glass.
1. **[BART](XXXX)** (from Facebook) released with the paper [BART: Denoising Sequence-to-Sequence Pre-training for Natural Language Generation, Translation, and Comprehension](XXXX) by Mike Lewis, Yinhan Liu, Naman Goyal, Marjan Ghazvininejad, Abdelrahman Mohamed, Omer Levy, Ves Stoyanov and Luke Zettlemoyer.
1. **[BARThez](XXXX)** (from École polytechnique) released with the paper [BARThez: a Skilled Pretrained French Sequence-to-Sequence Model](XXXX) by Moussa Kamal Eddine, Antoine J.-P. Tixier, Michalis Vazirgiannis.
1. **[BARTpho](XXXX)** (from VinAI Research) released with the paper [BARTpho: Pre-trained Sequence-to-Sequence Models for Vietnamese](XXXX) by Nguyen Luong Tran, Duong Minh Le and Dat Quoc Nguyen.
1. **[BEiT](XXXX)** (from Microsoft) released with the paper [BEiT: BERT Pre-Training of Image Transformers](XXXX) by Hangbo Bao, Li Dong, Furu Wei.
1. **[BERT](XXXX)** (from XXXX-7) released with the paper [BERT: Pre-training of Deep Bidirectional Transformers for Language Understanding](XXXX) by Jacob Devlin, XXXX-12-Wei Chang, Kenton Lee and Kristina Toutanova.
1. **[BERT For Sequence Generation](XXXX)** (from XXXX-7) released with the paper [Leveraging Pre-trained Checkpoints for Sequence Generation Tasks](XXXX) by Sascha Rothe, Shashi Narayan, Aliaksei Severyn.
1. **[BERTweet](XXXX)** (from VinAI Research) released with the paper [BERTweet: A pre-trained language model for English Tweets](XXXX) by Dat Quoc Nguyen, Thanh Vu and Anh Tuan Nguyen.
1. **[BigBird-Pegasus](XXXX)** (from XXXX-7 Research) released with the paper [Big Bird: Transformers for Longer Sequences](XXXX) by Manzil Zaheer, Guru Guruganesh, Avinava Dubey, Joshua Ainslie, Chris Alberti, Santiago Ontanon, Philip Pham, Anirudh Ravula, Qifan Wang, Li Yang, Amr Ahmed.
1. **[BigBird-RoBERTa](XXXX)** (from XXXX-7 Research) released with the paper [Big Bird: Transformers for Longer Sequences](XXXX) by Manzil Zaheer, Guru Guruganesh, Avinava Dubey, Joshua Ainslie, Chris Alberti, Santiago Ontanon, Philip Pham, Anirudh Ravula, Qifan Wang, Li Yang, Amr Ahmed.
1. **[BioGpt](XXXX)** (from Microsoft Research AI4Science) released with the paper [BioGPT: generative pre-trained transformer for biomedical text generation and mining](XXXX) by Renqian Luo, Liai Sun, Yingce Xia, Tao Qin, Sheng Zhang, Hoifung Poon and Tie-Yan Liu.
1. **[BiT](XXXX)** (from XXXX-7 AI) released with the paper [Big Transfer (BiT) by Alexander Kolesnikov, Lucas Beyer, Xiaohua Zhai, Joan Puigcerver, Jessica Yung, Sylvain Gelly, Neil Houlsby.
1. **[Blenderbot](XXXX)** (from Facebook) released with the paper [Recipes for building an open-domain chatbot](XXXX) by Stephen Roller, Emily Dinan, Naman Goyal, Da Ju, Mary Williamson, Yinhan Liu, Jing Xu, Myle Ott, Kurt Shuster, Eric M. Smith, Y-Lan Boureau, Jason Weston.
1. **[BlenderbotSmall](XXXX)** (from Facebook) released with the paper [Recipes for building an open-domain chatbot](XXXX) by Stephen Roller, Emily Dinan, Naman Goyal, Da Ju, Mary Williamson, Yinhan Liu, Jing Xu, Myle Ott, Kurt Shuster, Eric M. Smith, Y-Lan Boureau, Jason Weston.
1. **[BLIP](XXXX)** (from Salesforce) released with the paper [BLIP: Bootstrapping Language-Image Pre-training for Unified Vision-Language Understanding and Generation](XXXX) by Junnan Li, Dongxu Li, Caiming Xiong, Steven Hoi.
1. **[BLOOM](XXXX)** (from BigScience workshop) released by the [BigScience Workshop](XXXX).
1. **[BORT](XXXX)** (from Alexa) released with the paper [Optimal Subarchitecture Extraction For BERT](XXXX) by Adrian de Wynter and Daniel J. Perry.
1. **[ByT5](XXXX)** (from XXXX-7 Research) released with the paper [ByT5: Towards a token-free future with pre-trained byte-to-byte models](XXXX) by Linting Xue, Aditya Barua, Noah Constant, Rami Al-Rfou, Sharan Narang, Mihir Kale, Adam Roberts, Colin Raffel.
1. **[CamemBERT](XXXX)** (from Inria/Facebook/Sorbonne) released with the paper [CamemBERT: a Tasty French Language Model](XXXX) by Louis XXXX-9*, Benjamin Muller*, Pedro Javier Ortiz Suárez*, Yoann Dupont, Laurent Romary, Éric Villemonte de la Clergerie, Djamé Seddah and Benoît Sagot.
1. **[CANINE](XXXX)** (from XXXX-7 Research) released with the paper [CANINE: Pre-training an Efficient Tokenization-Free Encoder for Language Representation](XXXX) by Jonathan H. Clark, Dan Garrette, Iulia Turc, John Wieting.
1. **[Chinese-CLIP](XXXX)** (from OFA-Sys) released with the paper [Chinese CLIP: Contrastive Vision-Language Pretraining in Chinese](XXXX) by An Yang, Junshu Pan, Junyang Lin, Rui Men, Yichang Zhang, Jingren Zhou, Chang Zhou.
1. **[CLIP](XXXX)** (from OpenAI) released with the paper [Learning Transferable Visual Models From Natural Language Supervision](XXXX) by Alec Radford, Jong Wook Kim, Chris Hallacy, Aditya Ramesh, Gabriel Goh, Sandhini Agarwal, Girish Sastry, Amanda Askell, Pamela Mishkin, Jack Clark, Gretchen Krueger, Ilya Sutskever.
1. **[CLIPSeg](XXXX)** (from University of Göttingen) released with the paper [Image Segmentation Using Text and Image Prompts](XXXX) by Timo Lüddecke and Alexander Ecker.
1. **[CodeGen](XXXX)** (from Salesforce) released with the paper [A Conversational Paradigm for Program Synthesis](XXXX) by Erik Nijkamp, Bo Pang, Hiroaki Hayashi, Lifu Tu, Huan Wang, Yingbo Zhou, Silvio Savarese, Caiming Xiong.
1. **[Conditional DETR](XXXX)** (from Microsoft Research Asia) released with the paper [Conditional DETR for Fast Training Convergence](XXXX) by Depu Meng, Xiaokang Chen, Zejia Fan, Gang Zeng, Houqiang Li, Yuhui Yuan, Lei Sun, Jingdong Wang.
1. **[ConvBERT](XXXX)** (from YituTech) released with the paper [ConvBERT: Improving BERT with Span-based Dynamic Convolution](XXXX) by Zihang Jiang, Weihao Yu, Daquan Zhou, Yunpeng Chen, Jiashi Feng, Shuicheng Yan.
1. **[ConvNeXT](XXXX)** (from Facebook AI) released with the paper [A ConvNet for the 2020s](XXXX) by Zhuang Liu, Hanzi Mao, Chao-Yuan Wu, Christoph Feichtenhofer, Trevor Darrell, Saining Xie.
1. **[CPM](XXXX)** (from Tsinghua University) released with the paper [CPM: A Large-scale Generative Chinese Pre-trained Language Model](XXXX) by Zhengyan Zhang, Xu Han, Hao Zhou, Pei Ke, Yuxian Gu, Deming Ye, Yujia Qin, Yusheng Su, Haozhe Ji, Jian Guan, Fanchao Qi, Xiaozhi Wang, Yanan Zheng, Guoyang Zeng, Huanqi Cao, Shengqi Chen, Daixuan Li, Zhenbo Sun, Zhiyuan Liu, Minlie Huang, Wentao Han, Jie Tang, Juanzi Li, Xiaoyan Zhu, Maosong Sun.
1. **[CTRL](XXXX)** (from Salesforce) released with the paper [CTRL: A Conditional Transformer Language Model for Controllable Generation](XXXX) by Nitish Shirish Keskar*, Bryan McCann*, Lav R. Varshney, Caiming Xiong and Richard Socher.
1. **[CvT](XXXX)** (from Microsoft) released with the paper [CvT: Introducing Convolutions to Vision Transformers](XXXX) by Haiping Wu, Bin Xiao, Noel Codella, Mengchen Liu, Xiyang Dai, Lu Yuan, Lei Zhang.
1. **[Data2Vec](XXXX)** (from Facebook) released with the paper [Data2Vec:  A General Framework for Self-supervised Learning in Speech, Vision and Language](XXXX) by Alexei Baevski, Wei-Ning Hsu, Qiantong Xu, Arun Babu, Jiatao Gu, Michael Auli.
1. **[DeBERTa](XXXX)** (from Microsoft) released with the paper [DeBERTa: Decoding-enhanced BERT with Disentangled Attention](XXXX) by Pengcheng He, Xiaodong Liu, Jianfeng Gao, Weizhu Chen.
1. **[DeBERTa-v2](XXXX)** (from Microsoft) released with the paper [DeBERTa: Decoding-enhanced BERT with Disentangled Attention](XXXX) by Pengcheng He, Xiaodong Liu, Jianfeng Gao, Weizhu Chen.
1. **[Decision Transformer](XXXX)** (from Berkeley/Facebook/XXXX-7) released with the paper [Decision Transformer: Reinforcement Learning via Sequence Modeling](XXXX) by Lili Chen, Kevin Lu, Aravind Rajeswaran, Kimin Lee, Aditya Grover, Michael Laskin, Pieter Abbeel, Aravind Srinivas, Igor Mordatch.
1. **[Deformable DETR](XXXX)** (from SenseTime Research) released with the paper [Deformable DETR: Deformable Transformers for End-to-End Object Detection](XXXX) by Xizhou Zhu, Weijie Su, Lewei Lu, Bin Li, Xiaogang Wang, Jifeng Dai.
1. **[DeiT](XXXX)** (from Facebook) released with the paper [Training data-efficient image transformers & distillation through attention](XXXX) by Hugo Touvron, Matthieu Cord, Matthijs Douze, Francisco Massa, Alexandre Sablayrolles, Hervé Jégou.
1. **[DETR](XXXX)** (from Facebook) released with the paper [End-to-End Object Detection with Transformers](XXXX) by Nicolas Carion, Francisco Massa, Gabriel Synnaeve, Nicolas Usunier, Alexander Kirillov, Sergey Zagoruyko.
1. **[DialoGPT](XXXX)** (from Microsoft Research) released with the paper [DialoGPT: Large-Scale Generative Pre-training for Conversational Response Generation](XXXX) by Yizhe Zhang, Siqi Sun, Michel Galley, Yen-Chun Chen, Chris Brockett, Xiang Gao, Jianfeng Gao, Jingjing Liu, Bill Dolan.
1. **[DiNAT](XXXX)** (from SHI Labs) released with the paper [Dilated Neighborhood Attention Transformer](XXXX) by Ali Hassani and Humphrey Shi.
1. **[DistilBERT](XXXX)** (from HuggingFace), released together with the paper [DistilBERT, a distilled version of BERT: smaller, faster, cheaper and lighter](XXXX) by Victor Sanh, Lysandre Debut and Thomas Wolf. The same method has been applied to compress GPT2 into [DistilGPT2](XXXX), RoBERTa into [DistilRoBERTa](XXXX), Multilingual BERT into [DistilmBERT](XXXX) and a German version of DistilBERT.
1. **[DiT](XXXX)** (from Microsoft Research) released with the paper [DiT: Self-supervised Pre-training for Document Image Transformer](XXXX) by Junlong Li, Yiheng Xu, Tengchao Lv, Lei Cui, Cha Zhang, Furu Wei.
1. **[Donut](XXXX)** (from NAVER) released with the paper [OCR-free Document Understanding Transformer](XXXX) by Geewook Kim, Teakgyu Hong, Moonbin Yim, Jeongyeon Nam, Jinyoung Park, Jinyeong Yim, Wonseok Hwang, Sangdoo Yun, Dongyoon Han, Seunghyun Park.
1. **[DPR](XXXX)** (from Facebook) released with the paper [Dense Passage Retrieval for Open-Domain Question Answering](XXXX) by Vladimir Karpukhin, Barlas Oğuz, Sewon Min, Patrick Lewis, Ledell Wu, Sergey Edunov, Danqi Chen, and Wen-tau Yih.
1. **[DPT](XXXX)** (from Intel Labs) released with the paper [Vision Transformers for Dense Prediction](XXXX) by René Ranftl, Alexey Bochkovskiy, Vladlen Koltun.
1. **[ELECTRA](XXXX)** (from XXXX-7 Research/Stanford University) released with the paper [ELECTRA: Pre-training text encoders as discriminators rather than generators](XXXX) by Kevin Clark, Minh-Thang Luong, Quoc V. Le, Christopher D. Manning.
1. **[EncoderDecoder](XXXX)** (from XXXX-7 Research) released with the paper [Leveraging Pre-trained Checkpoints for Sequence Generation Tasks](XXXX) by Sascha Rothe, Shashi Narayan, Aliaksei Severyn.
1. **[ERNIE](XXXX)** (from Baidu) released with the paper [ERNIE: Enhanced Representation through Knowledge Integration](XXXX) by Yu Sun, Shuohuan Wang, Yukun Li, Shikun Feng, Xuyi Chen, Han Zhang, Xin Tian, Danxiang Zhu, Hao Tian, Hua Wu.
1. **[ESM](XXXX)** (from Meta AI) are transformer protein language models.  **ESM-1b** was released with the paper [Biological structure and function emerge from scaling unsupervised learning to 250 million protein sequences](XXXX) by Alexander Rives, Joshua Meier, Tom Sercu, Siddharth Goyal, Zeming Lin, Jason Liu, Demi Guo, Myle Ott, C. Lawrence Zitnick, Jerry Ma, and Rob Fergus. **ESM-1v** was released with the paper [Language models enable zero-shot prediction of the effects of mutations on protein function](XXXX) by Joshua Meier, Roshan Rao, Robert Verkuil, Jason Liu, Tom Sercu and Alexander Rives. **ESM-2** was released with the paper [Language models of protein sequences at the scale of evolution enable accurate structure prediction](XXXX) by Zeming Lin, Halil Akin, Roshan Rao, Brian Hie, Zhongkai Zhu, Wenting Lu, Allan dos Santos Costa, Maryam Fazel-Zarandi, Tom Sercu, Sal Candido, Alexander Rives.
1. **[FLAN-T5](XXXX)** (from XXXX-7 AI) released in the repository [XXXX-7-research/t5x](XXXX) by Hyung Won Chung, Le Hou, Shayne Longpre, Barret Zoph, Yi Tay, William Fedus, Eric Li, Xuezhi Wang, Mostafa Dehghani, Siddhartha Brahma, Albert Webson, Shixiang Shane Gu, Zhuyun Dai, Mirac Suzgun, Xinyun Chen, Aakanksha Chowdhery, Sharan Narang, Gaurav Mishra, Adams Yu, Vincent Zhao, Yanping Huang, Andrew Dai, Hongkun Yu, Slav Petrov, Ed H. Chi, Jeff Dean, Jacob Devlin, Adam Roberts, Denny Zhou, Quoc V. Le, and Jason Wei
1. **[FlauBERT](XXXX)** (from CNRS) released with the paper [FlauBERT: Unsupervised Language Model Pre-training for French](XXXX) by Hang Le, Loïc Vial, Jibril Frej, Vincent Segonne, Maximin Coavoux, Benjamin Lecouteux, Alexandre Allauzen, Benoît Crabbé, Laurent Besacier, Didier Schwab.
1. **[FLAVA](XXXX)** (from Facebook AI) released with the paper [FLAVA: A Foundational Language And Vision Alignment Model](XXXX) by Amanpreet Singh, Ronghang Hu, Vedanuj Goswami, Guillaume Couairon, Wojciech Galuba, Marcus Rohrbach, and Douwe Kiela.
1. **[FNet](XXXX)** (from XXXX-7 Research) released with the paper [FNet: Mixing Tokens with Fourier Transforms](XXXX) by James Lee-Thorp, Joshua Ainslie, Ilya Eckstein, Santiago Ontanon.
1. **[Funnel Transformer](XXXX)** (from CMU/XXXX-7 Brain) released with the paper [Funnel-Transformer: Filtering out Sequential Redundancy for Efficient Language Processing](XXXX) by Zihang Dai, Guokun Lai, Yiming Yang, Quoc V. Le.
1. **[GLPN](XXXX)** (from KAIST) released with the paper [Global-Local Path Networks for Monocular Depth Estimation with Vertical CutDepth](XXXX) by Doyeon Kim, Woonghyun Ga, Pyungwhan Ahn, Donggyu Joo, Sehwan Chun, Junmo Kim.
1. **[GPT](XXXX)** (from OpenAI) released with the paper [Improving Language Understanding by Generative Pre-Training](XXXX) by Alec Radford, Karthik Narasimhan, Tim Salimans and Ilya Sutskever.
1. **[GPT Neo](XXXX)** (from EleutherAI) released in the repository [EleutherAI/gpt-neo](XXXX) by Sid Black, Stella Biderman, Leo Gao, Phil Wang and Connor Leahy.
1. **[GPT NeoX](XXXX)** (from EleutherAI) released with the paper [GPT-NeoX-20B: An Open-Source Autoregressive Language Model](XXXX) by Sid Black, Stella Biderman, Eric Hallahan, Quentin Anthony, Leo Gao, Laurence Golding, Horace He, Connor Leahy, Kyle McDonell, Jason Phang, Michael Pieler, USVSN Sai Prashanth, Shivanshu Purohit, Laria Reynolds, Jonathan Tow, Ben Wang, Samuel Weinbach
1. **[GPT NeoX Japanese](XXXX)** (from ABEJA) released by Shinya Otani, Takayoshi Makabe, Anuj Arora, and Kyo Hattori.
1. **[GPT-2](XXXX)** (from OpenAI) released with the paper [Language Models are Unsupervised Multitask Learners](XXXX) by Alec Radford*, Jeffrey Wu*, Rewon Child, David Luan, Dario Amodei** and Ilya Sutskever**.
1. **[GPT-J](XXXX)** (from EleutherAI) released with the paper [kingoflolz/mesh-transformer-jax](XXXX) by Ben Wang and Aran Komatsuzaki. 
1. **[GPT-Sw3](XXXX)** (from AI-Sweden) released with the paper [Lessons Learned from GPT-SW3: Building the First Large-Scale Generative Language Model for Swedish](XXXX) by Ariel Ekgren, Amaru Cuba Gyllensten, Evangelia Gogoulou, Alice Heiman, Severine Verlinden, Joey Öhman, Fredrik Carlsson, Magnus Sahlgren. 
1. **[GroupViT](XXXX)** (from UCSD, NVIDIA) released with the paper [GroupViT: Semantic Segmentation Emerges from Text Supervision](XXXX) by Jiarui Xu, Shalini De Mello, Sifei Liu, Wonmin Byeon, Thomas Breuel, Jan Kautz, Xiaolong Wang.
1. **[Hubert](XXXX)** (from Facebook) released with the paper [HuBERT: Self-Supervised Speech Representation Learning by Masked Prediction of Hidden Units](XXXX) by Wei-Ning Hsu, Benjamin Bolte, Yao-Hung Hubert Tsai, Kushal Lakhotia, Ruslan Salakhutdinov, Abdelrahman Mohamed.
1. **[I-BERT](XXXX)** (from Berkeley) released with the paper [I-BERT: Integer-only BERT Quantization](XXXX) by Sehoon Kim, XXXX-10 Gholami, Zhewei Yao, Michael W. Mahoney, Kurt Keutzer.
1. **[ImageGPT](XXXX)** (from OpenAI) released with the paper [Generative Pretraining from Pixels](XXXX) by Mark Chen, Alec Radford, Rewon Child, Jeffrey Wu, Heewoo Jun, David Luan, Ilya Sutskever.
1. **[Jukebox](XXXX)** (from OpenAI) released with the paper [Jukebox: A Generative Model for Music](XXXX) by Prafulla Dhariwal, Heewoo Jun, Christine Payne, Jong Wook Kim, Alec Radford, Ilya Sutskever.
1. **[LayoutLM](XXXX)** (from Microsoft Research Asia) released with the paper [LayoutLM: Pre-training of Text and Layout for Document Image Understanding](XXXX) by Yiheng Xu, Minghao Li, Lei Cui, Shaohan Huang, Furu Wei, XXXX-12 Zhou.
1. **[LayoutLMv2](XXXX)** (from Microsoft Research Asia) released with the paper [LayoutLMv2: Multi-modal Pre-training for Visually-Rich Document Understanding](XXXX) by Yang Xu, Yiheng Xu, Tengchao Lv, Lei Cui, Furu Wei, Guoxin Wang, Yijuan Lu, Dinei Florencio, Cha Zhang, Wanxiang Che, Min Zhang, Lidong Zhou.
1. **[LayoutLMv3](XXXX)** (from Microsoft Research Asia) released with the paper [LayoutLMv3: Pre-training for Document AI with Unified Text and Image Masking](XXXX) by Yupan Huang, Tengchao Lv, Lei Cui, Yutong Lu, Furu Wei.
1. **[LayoutXLM](XXXX)** (from Microsoft Research Asia) released with the paper [LayoutXLM: Multimodal Pre-training for Multilingual Visually-rich Document Understanding](XXXX) by Yiheng Xu, Tengchao Lv, Lei Cui, Guoxin Wang, Yijuan Lu, Dinei Florencio, Cha Zhang, Furu Wei.
1. **[LED](XXXX)** (from AllenAI) released with the paper [Longformer: The Long-Document Transformer](XXXX) by Iz Beltagy, Matthew E. Peters, Arman Cohan.
1. **[LeViT](XXXX)** (from Meta AI) released with the paper [LeViT: A Vision Transformer in ConvNet's Clothing for Faster Inference](XXXX) by Ben Graham, Alaaeldin El-Nouby, Hugo Touvron, Pierre Stock, Armand Joulin, Hervé Jégou, Matthijs Douze.
1. **[LiLT](XXXX)** (from South China University of Technology) released with the paper [LiLT: A Simple yet Effective Language-Independent Layout Transformer for Structured Document Understanding](XXXX) by Jiapeng Wang, Lianwen Jin, Kai Ding.
1. **[Longformer](XXXX)** (from AllenAI) released with the paper [Longformer: The Long-Document Transformer](XXXX) by Iz Beltagy, Matthew E. Peters, Arman Cohan.
1. **[LongT5](XXXX)** (from XXXX-7 AI) released with the paper [LongT5: Efficient Text-To-Text Transformer for Long Sequences](XXXX) by Mandy Guo, Joshua Ainslie, David Uthus, Santiago Ontanon, Jianmo Ni, Yun-Hsuan Sung, Yinfei Yang.
1. **[LUKE](XXXX)** (from Studio Ousia) released with the paper [LUKE: Deep Contextualized Entity Representations with Entity-aware Self-attention](XXXX) by Ikuya Yamada, Akari Asai, Hiroyuki Shindo, Hideaki Takeda, Yuji Matsumoto.
1. **[LXMERT](XXXX)** (from UNC Chapel Hill) released with the paper [LXMERT: Learning Cross-Modality Encoder Representations from Transformers for Open-Domain Question Answering](XXXX) by Hao Tan and Mohit Bansal.
1. **[M-CTC-T](XXXX)** (from Facebook) released with the paper [Pseudo-Labeling For Massively Multilingual Speech Recognition](XXXX) by Loren Lugosch, Tatiana Likhomanenko, Gabriel Synnaeve, and Ronan Collobert.
1. **[M2M100](XXXX)** (from Facebook) released with the paper [Beyond English-Centric Multilingual Machine Translation](XXXX) by Angela Fan, Shruti Bhosale, Holger Schwenk, Zhiyi Ma, Ahmed El-Kishky, Siddharth Goyal, Mandeep Baines, Onur Celebi, Guillaume Wenzek, Vishrav Chaudhary, Naman Goyal, Tom Birch, Vitaliy Liptchinsky, Sergey Edunov, Edouard Grave, Michael Auli, Armand Joulin.
1. **[MarianMT](XXXX)** Machine translation models trained using [OPUS](XXXX) data by Jörg Tiedemann. The [Marian Framework](XXXX) is being developed by the Microsoft Translator Team.
1. **[MarkupLM](XXXX)** (from Microsoft Research Asia) released with the paper [MarkupLM: Pre-training of Text and Markup Language for Visually-rich Document Understanding](XXXX) by Junlong Li, Yiheng Xu, Lei Cui, Furu Wei.
1. **[MaskFormer](XXXX)** (from Meta and UIUC) released with the paper [Per-Pixel Classification is Not All You Need for Semantic Segmentation](XXXX) by Bowen Cheng, Alexander G. Schwing, Alexander Kirillov
1. **[mBART](XXXX)** (from Facebook) released with the paper [Multilingual Denoising Pre-training for Neural Machine Translation](XXXX) by Yinhan Liu, Jiatao Gu, Naman Goyal, Xian Li, Sergey Edunov, Marjan Ghazvininejad, Mike Lewis, Luke Zettlemoyer.
1. **[mBART-50](XXXX)** (from Facebook) released with the paper [Multilingual Translation with Extensible Multilingual Pretraining and Finetuning](XXXX) by Yuqing Tang, Chau Tran, Xian Li, Peng-Jen Chen, Naman Goyal, Vishrav Chaudhary, Jiatao Gu, Angela Fan.
1. **[Megatron-BERT](XXXX)** (from NVIDIA) released with the paper [Megatron-LM: Training Multi-Billion Parameter Language Models Using Model Parallelism](XXXX) by Mohammad Shoeybi, Mostofa Patwary, Raul Puri, Patrick LeGresley, Jared Casper and Bryan Catanzaro.
1. **[Megatron-GPT2](XXXX)** (from NVIDIA) released with the paper [Megatron-LM: Training Multi-Billion Parameter Language Models Using Model Parallelism](XXXX) by Mohammad Shoeybi, Mostofa Patwary, Raul Puri, Patrick LeGresley, Jared Casper and Bryan Catanzaro.
1. **[mLUKE](XXXX)** (from Studio Ousia) released with the paper [mLUKE: The Power of Entity Representations in Multilingual Pretrained Language Models](XXXX) by Ryokan Ri, Ikuya Yamada, and Yoshimasa Tsuruoka.
1. **[MobileBERT](XXXX)** (from CMU/XXXX-7 Brain) released with the paper [MobileBERT: a Compact Task-Agnostic BERT for Resource-Limited Devices](XXXX) by Zhiqing Sun, Hongkun Yu, Xiaodan Song, Renjie Liu, Yiming Yang, and Denny Zhou.
1. **[MobileNetV1](XXXX)** (from XXXX-7 Inc.) released with the paper [MobileNets: Efficient Convolutional Neural Networks for Mobile Vision Applications](XXXX) by Andrew G. Howard, Menglong Zhu, Bo Chen, Dmitry Kalenichenko, Weijun Wang, Tobias Weyand, Marco Andreetto, Hartwig Adam.
1. **[MobileNetV2](XXXX)** (from XXXX-7 Inc.) released with the paper [MobileNetV2: Inverted Residuals and Linear Bottlenecks](XXXX) by Mark Sandler, Andrew Howard, Menglong Zhu, Andrey Zhmoginov, Liang-Chieh Chen.
1. **[MobileViT](XXXX)** (from Apple) released with the paper [MobileViT: Light-weight, General-purpose, and Mobile-friendly Vision Transformer](XXXX) by Sachin Mehta and Mohammad Rastegari.
1. **[MPNet](XXXX)** (from Microsoft Research) released with the paper [MPNet: Masked and Permuted Pre-training for Language Understanding](XXXX) by Kaitao Song, Xu Tan, Tao Qin, Jianfeng Lu, Tie-Yan Liu.
1. **[MT5](XXXX)** (from XXXX-7 AI) released with the paper [mT5: A massively multilingual pre-trained text-to-text transformer](XXXX) by Linting Xue, Noah Constant, Adam Roberts, Mihir Kale, Rami Al-Rfou, Aditya Siddhant, Aditya Barua, Colin Raffel.
1. **[MVP](XXXX)** (from RUC AI Box) released with the paper [MVP: Multi-task Supervised Pre-training for Natural Language Generation](XXXX) by Tianyi Tang, Junyi Li, Wayne Xin Zhao and Ji-Rong Wen.
1. **[NAT](XXXX)** (from SHI Labs) released with the paper [Neighborhood Attention Transformer](XXXX) by Ali Hassani, Steven Walton, Jiachen Li, Shen Li, and Humphrey Shi.
1. **[Nezha](XXXX)** (from Huawei Noah’s Ark Lab) released with the paper [NEZHA: Neural Contextualized Representation for Chinese Language Understanding](XXXX) by Junqiu Wei, Xiaozhe Ren, Xiaoguang Li, Wenyong Huang, Yi Liao, Yasheng Wang, Jiashu Lin, Xin Jiang, Xiao Chen and Qun Liu.
1. **[NLLB](XXXX)** (from Meta) released with the paper [No Language Left Behind: Scaling Human-Centered Machine Translation](XXXX) by the NLLB team.
1. **[Nyströmformer](XXXX)** (from the University of Wisconsin - Madison) released with the paper [Nyströmformer: A Nyström-Based Algorithm for Approximating Self-Attention](XXXX) by Yunyang Xiong, Zhanpeng Zeng, Rudrasis Chakraborty, Mingxing Tan, Glenn Fung, Yin Li, Vikas Singh.
1. **[OPT](XXXX)** (from Meta AI) released with the paper [OPT: Open Pre-trained Transformer Language Models](XXXX) by Susan Zhang, Stephen Roller, Naman Goyal, Mikel Artetxe, Moya Chen, Shuohui Chen et al.
1. **[OWL-ViT](XXXX)** (from XXXX-7 AI) released with the paper [Simple Open-Vocabulary Object Detection with Vision Transformers](XXXX) by Matthias Minderer, Alexey Gritsenko, Austin Stone, Maxim Neumann, Dirk Weissenborn, Alexey Dosovitskiy, Aravindh Mahendran, Anurag Arnab, Mostafa Dehghani, Zhuoran Shen, Xiao Wang, Xiaohua Zhai, Thomas Kipf, and Neil Houlsby.
1. **[Pegasus](XXXX)** (from XXXX-7) released with the paper [PEGASUS: Pre-training with Extracted Gap-sentences for Abstractive Summarization](XXXXg/abs/1912.08777) by Jingqing Zhang, Yao Zhao, Mohammad Saleh and Peter J. Liu.
1. **[PEGASUS-X](XXXX)** (from XXXX-7) released with the paper [Investigating Efficiently Extending Transformers for Long Input Summarization](XXXX) by Jason Phang, Yao Zhao, Peter J. Liu.
1. **[Perceiver IO](XXXX)** (from Deepmind) released with the paper [Perceiver IO: A General Architecture for Structured Inputs & Outputs](XXXX) by Andrew Jaegle, Sebastian Borgeaud, Jean-Baptiste Alayrac, Carl Doersch, Catalin Ionescu, David Ding, Skanda Koppula, Daniel Zoran, Andrew Brock, Evan Shelhamer, Olivier Hénaff, Matthew M. Botvinick, Andrew Zisserman, Oriol Vinyals, João Carreira.
1. **[PhoBERT](XXXXphobert)** (from VinAI Research) released with the paper [PhoBERT: Pre-trained language models for Vietnamese](XXXX) by Dat Quoc Nguyen and Anh Tuan Nguyen.
1. **[PLBart](XXXX)** (from UCLA NLP) released with the paper [Unified Pre-training for Program Understanding and Generation](XXXX) by Wasi Uddin Ahmad, Saikat Chakraborty, Baishakhi Ray, Kai-Wei Chang.
1. **[PoolFormer](XXXX)** (from Sea AI Labs) released with the paper [MetaFormer is Actually What You Need for Vision](XXXX) by Yu, Weihao and Luo, Mi and Zhou, Pan and Si, Chenyang and Zhou, Yichen and Wang, Xinchao and Feng, Jiashi and Yan, Shuicheng.
1. **[ProphetNet](XXXX)** (from Microsoft Research) released with the paper [ProphetNet: Predicting Future N-gram for Sequence-to-Sequence Pre-training](XXXX) by Yu Yan, Weizhen Qi, Yeyun Gong, Dayiheng Liu, Nan Duan, Jiusheng Chen, Ruofei Zhang and XXXX-12 Zhou.
1. **[QDQBert](XXXX)** (from NVIDIA) released with the paper [Integer Quantization for Deep Learning Inference: Principles and Empirical Evaluation](XXXX) by Hao Wu, Patrick Judd, Xiaojie Zhang, Mikhail Isaev and Paulius Micikevicius.
1. **[RAG](XXXX)** (from Facebook) released with the paper [Retrieval-Augmented Generation for Knowledge-Intensive NLP Tasks](XXXX) by Patrick Lewis, Ethan Perez, Aleksandara Piktus, Fabio Petroni, Vladimir Karpukhin, Naman Goyal, Heinrich Küttler, Mike Lewis, Wen-tau Yih, Tim Rocktäschel, Sebastian Riedel, Douwe Kiela.
1. **[REALM](XXXX)** (from XXXX-7 Research) released with the paper [REALM: Retrieval-Augmented Language Model Pre-Training](XXXX) by Kelvin Guu, Kenton Lee, Zora Tung, Panupong Pasupat and XXXX-12-Wei Chang.
1. **[Reformer](XXXX)** (from XXXX-7 Research) released with the paper [Reformer: The Efficient Transformer](XXXX) by Nikita Kitaev, Łukasz Kaiser, Anselm Levskaya.
1. **[RegNet](XXXX)** (from META Research) released with the paper [Designing Network Design Space](XXXX) by Ilija Radosavovic, Raj Prateek Kosaraju, Ross Girshick, Kaiming He, Piotr Dollár.
1. **[RemBERT](XXXX)** (from XXXX-7 Research) released with the paper [Rethinking embedding coupling in pre-trained language models](XXXX) by Hyung Won Chung, Thibault Févry, Henry Tsai, M. Johnson, Sebastian Ruder.
1. **[ResNet](XXXX)** (from Microsoft Research) released with the paper [Deep Residual Learning for Image Recognition](XXXX) by Kaiming He, Xiangyu Zhang, Shaoqing Ren, Jian Sun.
1. **[RoBERTa](XXXX)** (from Facebook), released together with the paper a [Robustly Optimized BERT Pretraining Approach](XXXX) by Yinhan Liu, Myle Ott, Naman Goyal, Jingfei Du, Mandar Joshi, Danqi Chen, Omer Levy, Mike Lewis, Luke Zettlemoyer, Veselin Stoyanov.
1. **[RoBERTa-PreLayerNorm](XXXX)** (from Facebook) released with the paper [fairseq: A Fast, Extensible Toolkit for Sequence Modeling](XXXX) by Myle Ott, Sergey Edunov, Alexei Baevski, Angela Fan, Sam Gross, Nathan Ng, David Grangier, Michael Auli.
1. **[RoCBert](XXXX)** (from WeChatAI) released with the paper [RoCBert: Robust Chinese Bert with Multimodal Contrastive Pretraining](XXXX) by HuiSu, WeiweiShi, XiaoyuShen, XiaoZhou, TuoJi, JiaruiFang, JieZhou.
1. **[RoFormer](XXXX)** (from ZhuiyiTechnology), released together with the paper a [RoFormer: Enhanced Transformer with Rotary Position Embedding](XXXX) by Jianlin Su and Yu Lu and Shengfeng Pan and Bo Wen and Yunfeng Liu.
1. **[SegFormer](XXXX)** (from NVIDIA) released with the paper [SegFormer: Simple and Efficient Design for Semantic Segmentation with Transformers](XXXX) by Enze Xie, Wenhai Wang, Zhiding Yu, Anima Anandkumar, Jose M. Alvarez, Ping Luo.
1. **[SEW](XXXX)** (from ASAPP) released with the paper [Performance-Efficiency Trade-offs in Unsupervised Pre-training for Speech Recognition](XXXX) by Felix Wu, Kwangyoun Kim, Jing Pan, Kyu Han, Kilian Q. Weinberger, Yoav Artzi.
1. **[SEW-D](XXXX)** (from ASAPP) released with the paper [Performance-Efficiency Trade-offs in Unsupervised Pre-training for Speech Recognition](XXXX) by Felix Wu, Kwangyoun Kim, Jing Pan, Kyu Han, Kilian Q. Weinberger, Yoav Artzi.
1. **[SpeechToTextTransformer](XXXX)** (from Facebook), released together with the paper [fairseq S2T: Fast Speech-to-Text Modeling with fairseq](XXXX) by Changhan Wang, Yun Tang, Xutai Ma, Anne Wu, Dmytro Okhonko, Juan Pino.
1. **[SpeechToTextTransformer2](XXXX)** (from Facebook) released with the paper [Large-Scale Self- and Semi-Supervised Learning for Speech Translation](XXXX) by Changhan Wang, Anne Wu, Juan Pino, Alexei Baevski, Michael Auli, Alexis Conneau.
1. **[Splinter](XXXX)** (from Tel Aviv University) released with the paper [Few-Shot Question Answering by Pretraining Span Selection](XXXX) by Ori Ram, Yuval Kirstain, Jonathan Berant, XXXX-10 Globerson, Omer Levy.
1. **[SqueezeBERT](XXXX)** (from Berkeley) released with the paper [SqueezeBERT: What can computer vision teach NLP about efficient neural networks?](XXXX) by Forrest N. Iandola, Albert E. Shaw, Ravi Krishna, and Kurt W. Keutzer.
1. **[Swin Transformer](XXXX)** (from Microsoft) released with the paper [Swin Transformer: Hierarchical Vision Transformer using Shifted Windows](XXXX) by Ze Liu, Yutong Lin, Yue Cao, Han Hu, Yixuan Wei, Zheng Zhang, Stephen Lin, Baining Guo.
1. **[Swin Transformer V2](XXXX)** (from Microsoft) released with the paper [Swin Transformer V2: Scaling Up Capacity and Resolution](XXXX) by Ze Liu, Han Hu, Yutong Lin, Zhuliang Yao, Zhenda Xie, Yixuan Wei, Jia Ning, Yue Cao, Zheng Zhang, Li Dong, Furu Wei, Baining Guo.
1. **[Swin2SR](XXXX)** (from University of Würzburg) released with the paper [Swin2SR: SwinV2 Transformer for Compressed Image Super-Resolution and Restoration](XXXX) by Marcos V. Conde, Ui-Jin Choi, Maxime Burchi, Radu Timofte.
1. **[SwitchTransformers](XXXX)** (from XXXX-7) released with the paper [Switch Transformers: Scaling to Trillion Parameter Models with Simple and Efficient Sparsity](XXXX) by William Fedus, Barret Zoph, Noam Shazeer. 
1. **[T5](XXXX)** (from XXXX-7 AI) released with the paper [Exploring the Limits of Transfer Learning with a Unified Text-to-Text Transformer](XXXX) by Colin Raffel and Noam Shazeer and Adam Roberts and Katherine Lee and Sharan Narang and Michael Matena and Yanqi Zhou and Wei Li and Peter J. Liu.
1. **[T5v1.1](XXXX)** (from XXXX-7 AI) released with the paper [XXXX-7-research/text-to-text-transfer-transformer](XXXX) by Colin Raffel and Noam Shazeer and Adam Roberts and Katherine Lee and Sharan Narang and Michael Matena and Yanqi Zhou and Wei Li and Peter J. Liu.
1. **[Table Transformer](XXXX)** (from Microsoft Research) released with the paper [PubTables-1M: Towards Comprehensive Table Extraction From Unstructured Documents](XXXX) by Brandon Smock, Rohith Pesala, Robin Abraham.
1. **[TAPAS](XXXX)** (from XXXX-7 AI) released with the paper [TAPAS: Weakly Supervised Table Parsing via Pre-training](XXXX) by Jonathan Herzig, Paweł Krzysztof Nowak, Thomas Müller, Francesco Piccinno and Julian XXXX-9 Eisenschlos.
1. **[TAPEX](XXXX)** (from Microsoft Research) released with the paper [TAPEX: Table Pre-training via Learning a Neural SQL Executor](XXXX) by Qian Liu, Bei Chen, Jiaqi Guo, Morteza Ziyadi, Zeqi Lin, Weizhu Chen, Jian-Guang Lou.
1. **[Time Series Transformer](XXXXeries_transformer)** (from HuggingFace).
1. **[TimeSformer](XXXX)** (from Facebook) released with the paper [Is Space-Time Attention All You Need for Video Understanding?](XXXX) by Gedas Bertasius, Heng Wang, Lorenzo Torresani.
1. **[Trajectory Transformer](XXXX)** (from the University of California at Berkeley) released with the paper [Offline Reinforcement Learning as One Big Sequence Modeling Problem](XXXX) by Michael Janner, Qiyang Li, Sergey Levine
1. **[Transformer-XL](XXXX)** (from XXXX-7/CMU) released with the paper [Transformer-XL: Attentive Language Models Beyond a Fixed-Length Context](XXXX) by Zihang Dai*, Zhilin Yang*, Yiming Yang, Jaime Carbonell, Quoc V. Le, Ruslan Salakhutdinov.
1. **[TrOCR](XXXX)** (from Microsoft) released with the paper [TrOCR: Transformer-based Optical Character Recognition with Pre-trained Models](XXXX) by Minghao Li, Tengchao Lv, Lei Cui, Yijuan Lu, Dinei Florencio, Cha Zhang, Zhoujun Li, Furu Wei.
1. **[UL2](XXXX)** (from XXXX-7 Research) released with the paper [Unifying Language Learning Paradigms](XXXX) by Yi Tay, Mostafa Dehghani, Vinh Q. Tran, Xavier Garcia, Dara Bahri, Tal Schuster, Huaixiu Steven Zheng, Neil Houlsby, Donald Metzler
1. **[UniSpeech](XXXX)** (from Microsoft Research) released with the paper [UniSpeech: Unified Speech Representation Learning with Labeled and Unlabeled Data](XXXX) by Chengyi Wang, Yu Wu, Yao Qian, Kenichi Kumatani, Shujie Liu, Furu Wei, Michael Zeng, Xuedong Huang.
1. **[UniSpeechSat](XXXX)** (from Microsoft Research) released with the paper [UNISPEECH-SAT: UNIVERSAL SPEECH REPRESENTATION LEARNING WITH SPEAKER AWARE PRE-TRAINING](XXXX) by Sanyuan Chen, Yu Wu, Chengyi Wang, Zhengyang Chen, Zhuo Chen, Shujie Liu, Jian Wu, Yao Qian, Furu Wei, Jinyu Li, Xiangzhan Yu.
1. **[VAN](XXXX)** (from Tsinghua University and Nankai University) released with the paper [Visual Attention Network](XXXX) by Meng-Hao Guo, Cheng-Ze Lu, Zheng-Ning Liu, XXXX-12-XXXX-12 Cheng, Shi-Min Hu.
1. **[VideoMAE](XXXX)** (from Multimedia Computing Group, Nanjing University) released with the paper [VideoMAE: Masked Autoencoders are Data-Efficient Learners for Self-Supervised Video Pre-Training](XXXX) by Zhan Tong, Yibing Song, Jue Wang, Limin Wang.
1. **[ViLT](XXXX)** (from NAVER AI Lab/Kakao Enterprise/Kakao Brain) released with the paper [ViLT: Vision-and-Language Transformer Without Convolution or Region Supervision](XXXX) by Wonjae Kim, Bokyung Son, Ildoo Kim.
1. **[Vision Transformer (ViT)](XXXX)** (from XXXX-7 AI) released with the paper [An Image is Worth 16x16 Words: Transformers for Image Recognition at Scale](XXXX) by Alexey Dosovitskiy, Lucas Beyer, Alexander Kolesnikov, Dirk Weissenborn, Xiaohua Zhai, Thomas Unterthiner, Mostafa Dehghani, Matthias Minderer, Georg Heigold, Sylvain Gelly, Jakob Uszkoreit, Neil Houlsby.
1. **[VisualBERT](XXXX)** (from UCLA NLP) released with the paper [VisualBERT: A Simple and Performant Baseline for Vision and Language](XXXX) by Liunian Harold Li, Mark Yatskar, Da Yin, Cho-Jui Hsieh, Kai-Wei Chang.
1. **[ViT Hybrid](XXXX)** (from XXXX-7 AI) released with the paper [An Image is Worth 16x16 Words: Transformers for Image Recognition at Scale](XXXX) by Alexey Dosovitskiy, Lucas Beyer, Alexander Kolesnikov, Dirk Weissenborn, Xiaohua Zhai, Thomas Unterthiner, Mostafa Dehghani, Matthias Minderer, Georg Heigold, Sylvain Gelly, Jakob Uszkoreit, Neil Houlsby.
1. **[ViTMAE](XXXX)** (from Meta AI) released with the paper [Masked Autoencoders Are Scalable Vision Learners](XXXX) by Kaiming He, Xinlei Chen, Saining Xie, Yanghao Li, Piotr Dollár, Ross Girshick.
1. **[ViTMSN](XXXX)** (from Meta AI) released with the paper [Masked Siamese Networks for Label-Efficient Learning](XXXX) by Mahmoud Assran, Mathilde Caron, Ishan Misra, Piotr Bojanowski, Florian Bordes, Pascal Vincent, Armand Joulin, Michael Rabbat, Nicolas Ballas.
1. **[Wav2Vec2](XXXX)** (from Facebook AI) released with the paper [wav2vec 2.0: A Framework for Self-Supervised Learning of Speech Representations](XXXX) by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael Auli.
1. **[Wav2Vec2-Conformer](XXXX)** (from Facebook AI) released with the paper [FAIRSEQ S2T: Fast Speech-to-Text Modeling with FAIRSEQ](XXXX) by Changhan Wang, Yun Tang, Xutai Ma, Anne Wu, Sravya Popuri, Dmytro Okhonko, Juan Pino.
1. **[Wav2Vec2Phoneme](XXXX)** (from Facebook AI) released with the paper [Simple and Effective Zero-shot Cross-lingual Phoneme Recognition](XXXX) by Qiantong Xu, Alexei Baevski, Michael Auli.
1. **[WavLM](XXXX)** (from Microsoft Research) released with the paper [WavLM: Large-Scale Self-Supervised Pre-Training for Full Stack Speech Processing](XXXX) by Sanyuan Chen, Chengyi Wang, Zhengyang Chen, Yu Wu, Shujie Liu, Zhuo Chen, Jinyu Li, Naoyuki Kanda, Takuya Yoshioka, Xiong Xiao, Jian Wu, Long Zhou, Shuo Ren, Yanmin Qian, Yao Qian, Jian Wu, Michael Zeng, Furu Wei.
1. **[Whisper](XXXX)** (from OpenAI) released with the paper [Robust Speech Recognition via Large-Scale Weak Supervision](XXXX) by Alec Radford, Jong Wook Kim, Tao Xu, Greg Brockman, Christine McLeavey, Ilya Sutskever.
1. **[X-CLIP](XXXX)** (from Microsoft Research) released with the paper [Expanding Language-Image Pretrained Models for General Video Recognition](XXXX) by Bolin Ni, Houwen Peng, Minghao Chen, Songyang Zhang, Gaofeng Meng, Jianlong Fu, Shiming Xiang, Haibin Ling.
1. **[XGLM](XXXX)** (From Facebook AI) released with the paper [Few-shot Learning with Multilingual Language Models](XXXX) by Xi Victoria Lin, Todor Mihaylov, Mikel Artetxe, Tianlu Wang, Shuohui Chen, Daniel Simig, Myle Ott, Naman Goyal, Shruti Bhosale, Jingfei Du, Ramakanth Pasunuru, Sam Shleifer, Punit Singh Koura, Vishrav Chaudhary, Brian O'Horo, Jeff Wang, Luke Zettlemoyer, Zornitsa Kozareva, Mona Diab, Veselin Stoyanov, Xian Li.
1. **[XLM](XXXX)** (from Facebook) released together with the paper [Cross-lingual Language Model Pretraining](XXXX) by Guillaume Lample and Alexis Conneau.
1. **[XLM-ProphetNet](XXXX)** (from Microsoft Research) released with the paper [ProphetNet: Predicting Future N-gram for Sequence-to-Sequence Pre-training](XXXX) by Yu Yan, Weizhen Qi, Yeyun Gong, Dayiheng Liu, Nan Duan, Jiusheng Chen, Ruofei Zhang and XXXX-12 Zhou.
1. **[XLM-RoBERTa](XXXX)** (from Facebook AI), released together with the paper [Unsupervised Cross-lingual Representation Learning at Scale](XXXX) by Alexis Conneau*, Kartikay Khandelwal*, Naman Goyal, Vishrav Chaudhary, Guillaume Wenzek, Francisco Guzmán, Edouard Grave, Myle Ott, Luke Zettlemoyer and Veselin Stoyanov.
1. **[XLM-RoBERTa-XL](XXXX)** (from Facebook AI) released with the paper [Larger-Scale Transformers for Multilingual Masked Language Modeling](XXXX) by Naman Goyal, Jingfei Du, Myle Ott, Giri Anantharaman, Alexis Conneau.
1. **[XLNet](XXXX)** (from XXXX-7/CMU) released with the paper [​XLNet: Generalized Autoregressive Pretraining for Language Understanding](XXXX) by Zhilin Yang*, Zihang Dai*, Yiming Yang, Jaime Carbonell, Ruslan Salakhutdinov, Quoc V. Le.
1. **[XLS-R](XXXX)** (from Facebook AI) released with the paper [XLS-R: Self-supervised Cross-lingual Speech Representation Learning at Scale](XXXX) by Arun Babu, Changhan Wang, Andros Tjandra, Kushal Lakhotia, Qiantong Xu, Naman Goyal, Kritika Singh, Patrick von Platen, Yatharth Saraf, Juan Pino, Alexei Baevski, Alexis Conneau, Michael Auli.
1. **[XLSR-Wav2Vec2](XXXX)** (from Facebook AI) released with the paper [Unsupervised Cross-Lingual Representation Learning For Speech Recognition](XXXX) by Alexis Conneau, Alexei Baevski, Ronan Collobert, Abdelrahman Mohamed, Michael Auli.
1. **[YOLOS](XXXX)** (from Huazhong University of Science & Technology) released with the paper [You Only Look at One Sequence: Rethinking Transformer in Vision through Object Detection](XXXX) by Yuxin Fang, Bencheng Liao, Xinggang Wang, Jiemin Fang, Jiyang Qi, Rui Wu, Jianwei Niu, Wenyu Liu.
1. **[YOSO](XXXX)** (from the University of Wisconsin - Madison) released with the paper [You Only Sample (Almost) by Zhanpeng Zeng, Yunyang Xiong, Sathya N. Ravi, Shailesh Acharya, Glenn Fung, Vikas Singh.
1. 想要貢獻新的模型？我們這裡有一份**詳細指引和模板**來引導你加入新的模型。你可以在 [`templates`](./templates) 目錄中找到它們。��得查看[貢獻指引](./CONTRIBUTING.md)並在開始寫 PR 前聯繫維護人員或開一個新的 issue 來獲得 feedbacks。

要檢查某個模型是否已有 Flax、PyTorch 或 TensorFlow 的實作，或其是否在🤗 Tokenizers 函式庫中有對應的 tokenizer，敬請參閱[此表](XXXX)。

這些實作均已於多個資料集測試（請參閱範例腳本）並應與原版實作表現相當。你可以在範例文件的[此節](XXXX)中了解實作的細節。


## 了解更多

| 章節 | 描述 |
|-|-|
| [文件](XXXX) | 完整的 API 文件和教學 |
| [任務概覽](XXXX) | 🤗 Transformers 支援的任務 |
| [預處理教學](XXXX) | 使用 `Tokenizer` 來為模型準備資料 |
| [訓練和微調](XXXX) | 使用 PyTorch/TensorFlow 的內建的訓練方式或於 `Trainer` API 中使用 🤗 Transformers 提供的模型 |
| [快速上手：微調和範例腳本](XXXX) | 為各種任務提供的範例腳本 |
| [模型分享和上傳](XXXX) | 上傳並與社群分享你微調的模型 |
| [遷移](XXXX) | 從 `pytorch-transformers` 或 `pytorch-pretrained-bert` 遷移到 🤗 Transformers |

## 引用

我們已將此函式庫的[論文](XXXX)正式發表。如果你使用了 🤗 Transformers 函式庫，可以引用：
```bibtex
@inproceedings{wolf-etal-2020-transformers,
    title = "Transformers: State-of-the-Art Natural Language Processing",
    author = "Thomas Wolf and Lysandre Debut and Victor Sanh and Julien Chaumond and Clement Delangue and Anthony Moi and Pierric Cistac and Tim Rault and Rémi Louf and Morgan Funtowicz and Joe Davison and Sam Shleifer and Patrick von Platen and Clara Ma and Yacine Jernite and Julien Plu and Canwen Xu and Teven Le Scao and Sylvain Gugger and Mariama Drame and Quentin Lhoest and Alexander M. Rush",
    booktitle = "Proceedings of the 2020 Conference on Empirical Methods in Natural Language Processing: System Demonstrations",
    month = oct,
    year = "2020",
    address = "Online",
    publisher = "Association for Computational Linguistics",
    url = "XXXX",
    pages = "38--45"
}
```
