Readme for the source code of Label-Smoothed Backdoor Attack
===
The structure of the source code:

```
├── attacks
    ├── attacks.py                    #define attack strategies (hard, smooth, clean)
    ├── backdoors.py                  #define backdoor injection functions
├── defenses                          #define defense methods (public implementation)
    ├── neural_cleanse 
    ├── DBD
    ├── NAD
├── defenses.py 					  #personally implemented defense methods (STRIP, ShrinkPad) 
├──classifier_models                  #define different existing classification models
├── networks                          #define personal models for MNIST 
    ├── __init__.py
    ├── models.py
├── utils                             #define dataloaders
    ├── __init__.py
    ├── dataloader.py
    ├── utils.py
├── main.py                           #entrance for model training and evaluation
├── config.py                         #define default configurations
├── run_script.sh                     #define example command for running the experiments
├── run_train_ae.sh                   #define example command for training the autoencoder


├── requirements.txt 
├── README.md                         #this file
```

Run
---

### Install paddle
- with gpu
  ```bash
  pip install paddlepaddle-gpu==2.2.0 
  ```

Please refer [here](https://www.paddlepaddle.org.cn/documentation/docs/zh/develop/install/index_cn.html) if you encounter any problem during installation.

### Install requirements
```bash
python -m pip install -r requirements.py
```

### Download the datasets
Usually, it will automatically download the tested datasets except for gtsrb. Run the following script to download gtsrb.
bash gtsrb_download.sh

Note that the place of datasets should be consistent with the setting of "data_root" in config.py
### Train AutoEncoder

sh run_train_ae.sh {image_save_to_dir} {model_save_to_dir} {dataset}

e.g.

for cifar10

sh run_train_ae.sh ./result_cifar10/ ~/ckpt_cifar10/ cifar10

for mnist

sh run_train_ae.sh ./result_mnist/ ~/ckpt_mnist/ mnist

./result_mnist/ This folder contains the generated easy pattern and easy_pattern_imgs.pkl from the first epoch.

### Run

Please refer to run_script.sh