# DBD
This a paddle implementation of our paper "[Backdoor Defense via Decoupling the Training
Process](https://openreview.net/pdf?id=TySnJ-0RdKI)".

**Table of Contents:**
- [DBD](#dbd)
  - [Setup](#setup)
    - [Environments](#environments)
    - [Log and checkpoint directories](#log-and-checkpoint-directories)
  - [Usage](#usage)
    - [DBD](#dbd-1)
  - [Results](#results)
- [License](#license)
- [Citation](#citation)

## Setup
### Environments
We recommend conda as the package manager to setup the environment used in our experiments. Create
the environment `dbd` from the [environment.yml](./environment.yml) file and activate it:
```
conda env create -f environment.yml && conda activate dbd
```


**Note:** Make sure `dataset_dir` contains the sub-string `cifar`.

### Log and checkpoint directories
Create `saved_dir` and `storage_dir` specified in the [YAML configuration
files](./config) to save logs and checkpoints respectively:
```
mkdir saved_data && mkdir storage
``` 

## Usage
We give examples of DBD on CIFAR-10/CELEBA/GTSRB/CELEBA
datasets under BadNets/WaNet/SIG/AETCB attack. Other settings can also be found in the [YAML
configuration files](./config). Please have an overview before running the codes.


### DBD
1. Self-Supervised Learning

    We provide different scripts to train different purified feature extractors, e.g. badnets on cifar10:
    ```
    python simclr.py --config config/defense/simclr/badnets/cifar10.yaml \
                     --resume False \
                     --gpu gpu:0
    ```
2. Semi-Supervised Fine-tuning

    Run the following script to finetune a clean model:
    ```
    python mixmatch_finetune.py --config config/defense/mixmatch_finetune/badnets/cifar10.yaml \
                                --resume False \
                                --gpu gpu:0
    ```

### Results
|   Method   | BadNets BA (%) | BadNets ASR (%) | Blended BA (%) | Blended ASR (%) |
|:----------:|:--------------:|:---------------:|:--------------:|:---------------:|
| No Defense |     95.13      |       100       |     94.26      |      98.15      |
|    DBD     |     92.50      |      0.88       |     92.60      |      0.31       |

# License
Our codes is released under [GNU General Public License v3.0](./LICENSE).

# Citation
If our work or this repo is useful for your research, please cite our paper as follows:
```
@inproceedings{huang2022backdoor,
  title={Backdoor Defense via Decoupling the Training Process},
  author={Kunzhe Huang, Yiming Li, Baoyuan Wu, Zhan Qin and Kui Ren},
  booktitle={ICLR},
  year={2022}
}
```
