import argparse

def get_arguments():
    parser = argparse.ArgumentParser()

    # various path
    parser.add_argument('--checkpoint_root', type=str, default='./weight/erasing_net', help='models weight are saved here')
    parser.add_argument("--trigger_dir", type=str, default="/root/projects/AttackDefence/output") # put data under this folder

    parser.add_argument('--log_root', type=str, default='./results', help='logs are saved here')
    # parser.add_argument('--dataset', type=str, default='CIFAR10', help='name of image dataset')
    # parser.add_argument('--s_model', type=str, default='./weight/s_net/WRN-16-1-S-model_best.pth.tar', help='path of student model')
    # parser.add_argument('--t_model', type=str, default='./weight/t_net/WRN-16-1-T-model_best.pth.tar', help='path of teacher model')

    parser.add_argument("--data_root", type=str, default="/root/projects/AttackDefence/data/AttackDefence")
    parser.add_argument("--checkpoints", type=str, default="/root/projects/AttackDefence/checkpoints")
    # parser.add_argument("--checkpoints", type=str, default="/root/projects/AttackDefence/source/Warping-based_Backdoor_Attack-release/checkpoints")
    parser.add_argument("--temps", type=str, default="./afs/temps")
    parser.add_argument("--device", type=str, default="gpu")
    parser.add_argument("--continue_training", action="store_true", default=False)
    parser.add_argument("--fine_tune", type=int, default=0)

    parser.add_argument("--dataset", type=str, default="cifar10")
    parser.add_argument("--attack_mode", type=str, default="all2one")
    parser.add_argument('--attack_ratio', type=float, default=0.01)
    parser.add_argument('--attack_method', type=str, default='consistent')
    parser.add_argument('--attack_type', type=str, default='WaNet')
    parser.add_argument('--attack_locs', type=str, default='top-left,top-right,bottom-left,bottom-right')
    parser.add_argument('--attack_modes', type=str, default='all_col')

    parser.add_argument('--trigger', type=str, default='sig')
    parser.add_argument("--train_mode", type=str, default="eval")

    parser.add_argument('--alpha', type=float, default=0.05)
    parser.add_argument('--freqs', type=str, default='2,4,8,16')


    parser.add_argument("--bs", type=int, default=128)
    parser.add_argument("--lr_C", type=float, default=1e-2)
    parser.add_argument("--schedulerC_milestones", type=list, default=[100, 200, 300, 400])
    parser.add_argument("--schedulerC_lambda", type=float, default=0.1)
    parser.add_argument("--fine_tune_epochs", type=int, default=10)
    parser.add_argument("--num_workers", type=float, default=6)
    parser.add_argument("--target_label", type=int, default=2)
    parser.add_argument("--label_smoothing", type=float, default=0.4)
    parser.add_argument("--cross_ratio", type=float, default=2)  # rho_a = pc, rho_n = pc * cross_ratio
    parser.add_argument("--model_check_metric", type=str, default='Acc')
    parser.add_argument("--random_rotation", type=int, default=10)
    parser.add_argument("--random_crop", type=int, default=4)

    parser.add_argument("--s", type=str, default="0.5,0.55,0.6,0.65")
    parser.add_argument("--k", type=str, default="3,4,5,6")
    parser.add_argument(
        "--grid-rescale", type=float, default=1
    )  # scale grid values to avoid pixel values going out of [-1, 1]. For example, grid-rescale = 0.98


    # training hyper parameters
    parser.add_argument('--print_freq', type=int, default=50, help='frequency of showing training results on console')
    parser.add_argument('--epochs', type=int, default=10, help='number of total epochs to run')
    parser.add_argument('--batch_size', type=int, default=64, help='The size of batch')
    parser.add_argument('--lr', type=float, default=0.01, help='initial learning rate')
    parser.add_argument('--momentum', type=float, default=0.9, help='momentum')
    parser.add_argument('--weight_decay', type=float, default=1e-4, help='weight decay')
    parser.add_argument('--num_class', type=int, default=10, help='number of classes')
    parser.add_argument('--ratio', type=float, default=0.1, help='ratio of training data')
    parser.add_argument('--beta1', type=int, default=1000, help='beta of low layer')
    parser.add_argument('--beta2', type=int, default=1000, help='beta of middle layer')
    parser.add_argument('--beta3', type=int, default=1000, help='beta of high layer')
    parser.add_argument('--beta4', type=int, default=1000, help='beta of high layer')
    parser.add_argument('--p', type=float, default=2.0, help='power for AT')
    parser.add_argument('--threshold_clean', type=float, default=90.0, help='threshold of save weight')
    parser.add_argument('--threshold_bad', type=float, default=90.0, help='threshold of save weight')
    # parser.add_argument('--cuda', type=int, default=1)
    # parser.add_argument('--device', type=str, default='cuda')
    parser.add_argument('--save', type=int, default=1)

    # others
    parser.add_argument('--seed', type=int, default=2, help='random seed')
    parser.add_argument('--note', type=str, default='try', help='note for this run')

    # net and dataset choosen
    parser.add_argument('--data_name', type=str, default='CIFAR10', help='name of dataset')
    parser.add_argument('--t_name', type=str, default='WRN-16-1', help='name of teacher')
    parser.add_argument('--s_name', type=str, default='WRN-16-1', help='name of student')

    # backdoor attacks
    parser.add_argument('--inject_portion', type=float, default=0.1, help='ratio of backdoor samples')
    # parser.add_argument('--target_label', type=int, default=5, help='class of target label')
    parser.add_argument('--trigger_type', type=str, default='gridTrigger', help='type of backdoor trigger')
    parser.add_argument('--target_type', type=str, default='all2one', help='type of backdoor label')
    parser.add_argument('--trig_w', type=int, default=3, help='width of trigger pattern')
    parser.add_argument('--trig_h', type=int, default=3, help='height of trigger pattern')

    return parser
