import argparse


def get_argument():
    parser = argparse.ArgumentParser()

    # Directory option

    parser.add_argument("--data_root", type=str, default="/root/projects/AttackDefence/data/AttackDefence")
    parser.add_argument("--train_mode", type=str, default="train")
    parser.add_argument("--checkpoints", type=str, default="/root/projects/AttackDefence/checkpoints")
    parser.add_argument("--device", type=str, default="gpu:2")
    parser.add_argument("--result", type=str, default="./results/smooth/")
    parser.add_argument("--dataset", type=str, default="mnist")
    parser.add_argument("--attack_mode", type=str, default="all2one")
    parser.add_argument("--temps", type=str, default="./temps")

    # ---------------------------- For Neural Cleanse --------------------------
    # Model hyperparameters
    parser.add_argument("--bs", type=int, default=64)
    parser.add_argument("--lr", type=float, default=1e-1)
    parser.add_argument("--init_cost", type=float, default=1e-3)
    parser.add_argument("--atk_succ_threshold", type=float, default=98.0)
    parser.add_argument("--early_stop", type=bool, default=True)
    parser.add_argument("--early_stop_threshold", type=float, default=99.0)
    parser.add_argument("--early_stop_patience", type=int, default=25)
    parser.add_argument("--patience", type=int, default=5)
    parser.add_argument("--cost_multiplier", type=float, default=2)
    parser.add_argument("--epoch", type=int, default=20)
    parser.add_argument("--num_workers", type=int, default=8)

    parser.add_argument("--attack_ratio", type=float, default=0.01)
    parser.add_argument("--attack_method", type=str, default='smooth')
    parser.add_argument('--attack_type', type=str, default='BadNet')

    parser.add_argument("--target_label", type=int)
    parser.add_argument("--total_label", type=int)
    parser.add_argument("--EPSILON", type=float, default=1e-7)

    parser.add_argument("--to_file", type=bool, default=True)
    parser.add_argument("--n_times_test", type=int, default=1)

    parser.add_argument("--use_norm", type=int, default=1)

    parser.add_argument("--k", type=int)

    return parser
