import os
from openai import AsyncOpenAI
import base64
import asyncio
from typing import List, Tuple, Dict, Any
import json
import time


class GPT4Model:
    def __init__(self, seed, model_name="gpt-4"):
        self.model_name = model_name
        self.api_key =  # TODO
        self.client = AsyncOpenAI(api_key=self.api_key)
        self.seed = seed

    def encode_image(self, image_path):
        with open(image_path, "rb") as image_file:
            return base64.b64encode(image_file.read()).decode('utf-8')

    async def send_request(self, messages):
        while True:
            try:
                response = await self.client.chat.completions.create(
                    model=self.model_name,
                    messages=messages,
                    seed=self.seed,
                    max_tokens=600,
                    temperature=0
                )
                return response.choices[0].message.content
            except Exception as e:
                # Check if the exception is a 400 error and matches the specific message
                if hasattr(e, 'response') and e.response.status_code == 400:
                    error_message = e.response.json().get('error', {}).get('message', '')
                    if 'content that is not allowed by our safety system' in error_message:
                        return "Safety error"
                    else:
                        print(f"Error: {e}")
                    time.sleep(30)  # Sleep for 30 seconds before retrying
                else:
                    raise  # If it's not a 400 error, re-raise the exception

    async def answer_question(self, prompt: str, image_path: str, system_message: str):
        base64_image = self.encode_image(image_path)
        messages = [
            {"role": "system", "content": system_message},
            {"role": "user",
             "content": [
                 {"type": "text", "text": prompt},
                 {"type": "image_url",
                     "image_url": {"url": f"data:image/jpeg;base64,{base64_image}"},
                  }
             ]}
        ]

        text_response = await self.send_request(messages)
        return text_response

    async def answer_question_fewshot(self, prompt: str, image_path: str, system_message: str, fewshot_path: str):
        base64_image = self.encode_image(image_path)
        base64_fewshot_image = self.encode_image(fewshot_path)

        messages = [
            {"role": "system", "content": system_message},
            {"role": "user",
             "content": [
                 {"type": "text", "text": prompt},
                 {"type": "image_url", "image_url": {
                     "url": f"data:image/jpeg;base64,{base64_fewshot_image}"}},
                 {"type": "image_url", "image_url": {
                     "url": f"data:image/jpeg;base64,{base64_image}"}}
             ]}
        ]

        text_response = await self.send_request(messages)
        return text_response

    async def answer_question_without_image(self, prompt: str, system_message: str):
        print(prompt)
        messages = [
            {"role": "system", "content": system_message},
            {"role": "user",
             "content": [
                 {"type": "text", "text": prompt}
             ]}
        ]
        response = await self.client.chat.completions.create(model=self.model_name,
                                                             messages=messages,
                                                             seed=self.seed,
                                                             max_tokens=600,
                                                             temperature=0)
        return response.choices[0].message.content

    async def answer_identification_prompt(self,  prompt: str, image_path: str):
        base64_image = self.encode_image(image_path)
        messages = [
            {"role": "user",
                "content": [
                    {"type": "text", "text": prompt},
                    {"type": "image_url",
                        "image_url": {"url": f"data:image/jpeg;base64,{base64_image}"},
                     }
                ]}
        ]
        response = await self.client.chat.completions.create(model=self.model_name,
                                                             messages=messages,
                                                             seed=self.seed,
                                                             max_tokens=300,
                                                             temperature=0)
        return response.choices[0].message.content

    async def answer_identification_prompt_fewshot_example(self, prompt_main, image_path_main, fewshot_examples):

        base64_image_main = self.encode_image(image_path_main)
        messages = []
        for example in fewshot_examples:
            prompt_example, image_path_example, answer_example = example[
                'prompt'], example['image_path'], example['cot_answer']
            base64_image_example = self.encode_image(image_path_example)
            messages.append({"role": "user",
                             "content": [{"type": "text", "text": prompt_example},
                                         {"type": "image_url", "image_url": {"url": f"data:image/jpeg;base64,{base64_image_example}"}}]
                             })
            messages.append({"role": "assistant", "content": answer_example})
        messages.append({"role": "user",
                         "content": [{"type": "text", "text": prompt_main},
                                     {"type": "image_url", "image_url": {"url": f"data:image/jpeg;base64,{base64_image_main}"}}]
                         })
        response = await self.client.chat.completions.create(model=self.model_name,
                                                             messages=messages,
                                                             seed=self.seed,
                                                             max_tokens=600,
                                                             temperature=0)
        return response.choices[0].message.content
