import argparse
from evaluation.dqa_answer_generation import main
import asyncio
from constants import DATASETS_INFO

if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        description='Run the evaluation script with a specified dataset and model.')

    parser.add_argument('dataset_name', type=str,
                        help='The name of the dataset')
    parser.add_argument('model_name', type=str,
                        help='The name of the model to use for evaluation')
    parser.add_argument('--sample_path', type=str, default="",
                        help='The path to question ids')
    parser.add_argument('--log_path', type=str, default="",
                        help='The path to logfile')
    parser.add_argument('--image_type', type=str, default="original_image",
                        help='Change the image type to include with the question. Options: original_image, no_object, question_object_masked')
    parser.add_argument('--cot', action='store_true',
                        help="Use COT.")
    parser.add_argument('--fewshot', action='store_true',
                        help="Use ICL.")

    # Parse the arguments
    args = parser.parse_args()

    # Run the main function with parsed arguments
    asyncio.run(main(args.dataset_name, args.model_name,
                args.sample_path, args.log_path, args.image_type, args.cot, args.fewshot))
