
# Dataset DQA Evaluation

This repository contains scripts and tools for generating and evaluating datasets. 

The main script for generating datasets is: `generate_dataset_with_qa.py`

The main script for getting answers from LVLMs in json format is `run_dataset_dqa.py`.

Put Foodwebs dataset in the datasets folder and colored_icons_final from IconQA in the dataset_generation_with_options folder.


## Generating the Dataset

```bash
python -m dataset_generation_with_options.generate_dataset_with_qa.py icon_dataset_relationship_directionless_1000 1000 relationship_directionless --relationship_file "dataset_generation_with_options/knowledge_g.txt"
```

### Command Breakdown

- `python -m generate_dataset_with_qa.py`: Executes the `generate_dataset_with_qa` module.
- `"icon_dataset_relationship_directionless_1000"`: The name of the dataset to evaluate, this is how it'll be saved.
- `1000`: The size of the dataset
- `relationship_directionless`: The key to the diagram type. For more information you can explore the code. The options are [image, text, abs_position, rel_position, relationship_directionless] right now. Image here means icon setting.
- `--relationship_file "dataset_generation_with_options/knowledge_g.txt"`: The path to the knowledge graph, if required

## Generating LVLM outputs

First look into the `constants.py` file and add the necessary diagram folder path and informations.

For GPT models: Add 'GPT_API_KEY' in your environment.
For Gemini models: Get a Vertex AI account and enter your project name in gemini.py

To run the dataset question answering, use the following command:

```bash
python -m run_dataset_dqa "icon_dqa_relationship_directionless" "gpt-4o" --log_path "gpt4o_outputs/icon_dqa/gpt4o_relationship_directionless_evaluation.json" --cot --fewshot
```

### Command Breakdown

- `python -m run_dataset_dqa`: Executes the `run_dataset_dqa` module.
- `"icon_dqa_relationship_directionless"`: The key of the dataset to evaluate, this key is looked up at `constants.py`
- `"gpt-4o"`: The model to use for evaluation. Can be picked from [`"gpt-4o"`, `"gpt-4-vision-preview"`, `"gemini-1.5-pro"`]
- `--log_path "gpt4o_outputs/icon_dqa/gpt4o_relationship_directionless_evaluation_cot.json"`: Specifies the path where the log file will be saved, you can say whatever you want here make sure you don't overwrite :/
- `--cot`: Use this flag if you want COT.
- `--fewshot`: Use this flag if you want ICL. Make sure the dataset has a fewshot composite image specified in `constants.py`

## Evaluating the outputs

I recommend checking out the Notebook: `notebooks/Evaluation DQA` but if you want to get results seperately:

```bash
cd evaluation
python -m dqa_evaluation FILEPATH --q_component entity_abstract --q_type count
```

### Command Breakdown

- `python -m dqa_evaluation`: Executes the `dqa_evaluation` module.
- `FILEPATH`: Path of the output json file of LVLM.
- `"--q_component entity_abstract"`: The specific component you want to evaluate can be specified (For Foodwebs)
- `"--q_type count"`: The specific type of question you want to evaluate can be picked from [count, existence] (For Synthetic Dataset) 
### Prerequisites

Ensure you have the following dependencies installed:

- Python 3.x (Python 3.11.5 for my case)

```bash
pip install -r requirements.txt
```

