from abc import ABC, abstractmethod


class DatasetParser(ABC):
    def __init__(self, dataset_file: str, sample_file: str = "", image_folder: str = ""):
        self.dataset_file = dataset_file
        self.image_folder = image_folder
        self.load_data(sample_file)

    @abstractmethod
    def load_data(self):
        raise NotImplementedError("Subclasses must implement this method")

    @abstractmethod
    def next(self, *args, **kwargs):
        raise NotImplementedError("Subclasses must implement this method")
