import vertexai
from vertexai.generative_models import GenerativeModel, Part, Image
import asyncio
from typing import List, Tuple, Dict, Any
import json
import time

PROJECT_NAME =  # TODO


class GeminiModel:
    def __init__(self, model_name="gemini-1.5-pro"):
        vertexai.init(project=PROJECT_NAME,
                      location="us-central1")
        self.model_name = model_name

    async def send_request(self, model, text_part, image_part, generation_configuration):
        while True:
            try:
                response = model.generate_content(
                    [text_part, image_part], generation_config=generation_configuration)
                return response
            except Exception as e:
                print(e)
                time.sleep(30)

    async def answer_question(self, prompt: str, image_path: str, system_message: str):
        model = GenerativeModel(
            model_name=self.model_name, system_instruction=system_message)
        generation_configuration = {
            "max_output_tokens": 600,
            "temperature": 0
        }
        image_part = Part.from_image(Image.load_from_file(image_path))
        text_part = Part.from_text(prompt)
        response = await self.send_request(model, text_part, image_part, generation_configuration)
        try:
            return response.text
        except ValueError:
            return ""

    async def answer_question_fewshot(self, prompt: str, image_path: str, system_message: str, fewshot_path: str):
        model = GenerativeModel(
            model_name=self.model_name, system_instruction=system_message)
        generation_configuration = {
            "max_output_tokens": 600,
            "temperature": 0
        }

        # Load the images
        main_image_part = Part.from_image(Image.load_from_file(image_path))
        fewshot_image_part = Part.from_image(
            Image.load_from_file(fewshot_path))

        # Load the text part
        text_part = Part.from_text(prompt)

        # Create a combined input list with the fewshot example first
        input_parts = [text_part, fewshot_image_part, main_image_part]

        response = model.generate_content(
            input_parts, generation_config=generation_configuration)

        try:
            return response.text
        except ValueError:
            return ""
