# A Theoretical Analysis on Feature Learning in Neural Networks: Emergence from Inputs and Advantage over Fixed Features
This repository contains the Pytorch implementation of our experiments in the paper "A Theoretical Analysis on Feature Learning in Neural Networks: Emergence from Inputs and Advantage over Fixed Features". Accepted by ICLR2022. 

## Environment Setting
Python version >= 3.9
Pytorch >= 1.10.2 (guide is [here](https://pytorch.org/))
Install other used packages:
```
pip install -r requirements.txt --ignore-installed
```

## Running 
```
python classfication.py --conf ./conf/parity.yaml # simulation data with parity labeling
python classfication.py --conf ./conf/interval.yaml # simulation data with interval labeling
python classfication.py --conf ./conf/mnist.yaml # real dataset
python resnet_cifar10.py # run resnet on cifar10
``` 
In *parity.yaml*/*interval.yaml* , change ["model"]["type"] to "adp"/"one"/"two"/"ntk"/"fix" meaning Network/One Step/Two Step/NTK/RF in the paper Appendix E.1, and change ["data"]["structure"] to True/False meaning input data with or without structure.

The result can be found in the folder *exp*. 

For more detail see Appendix E in the paper.