#!/bin/bash

CONTAINER_NAME=""


# Path to the JSON file
json_file="test_config_current.json"



json_data=$(python3 -c "import json; print(json.dumps(json.load(open('$json_file'))))")
echo $json_data
length=$(python3 -c "print(len($json_data))")

gpu=0



#    # If m < d, skip the rest of this iteration
#    if [ $m -lt $d ]; then
#      continue
#    fi
#    echo $m $d
    # Otherwise, perform some operation with m and d
   for i in $(seq 0 $(($length-1))); do
        # Extract 'a' and 'b' values
        dataset=$(python3 -c "import json; print(json.loads('$json_data')[$i].get('dataset', ''))")
        train_mode=$(python3 -c "import json; print(json.loads('$json_data')[$i].get('train_mode', ''))")
        test_mode=$(python3 -c "import json; print(json.loads('$json_data')[$i].get('test_mode', ''))")

        # Extract 'buffer_size' or use a default value of 0 if it doesn't exist
        buffer_size=$(python3 -c "import json; print(json.loads('$json_data')[$i].get('buffer_size', 0))")
        ewc_lambda=$(python3 -c "import json; print(json.loads('$json_data')[$i].get('ewc_lambda', 0.0))")
        prefix=$(python3 -c "import json; print(json.loads('$json_data')[$i].get('prefix', ''))")

        for m in {1..16}; do
        # Determine the GPU to use for this iteration
        (( gpu++ ))
	      (( gpu%=8 ))
	      echo $gpu, $prefix, $CONTAINER_NAME

	      runai exec $CONTAINER_NAME -- /bin/sh -c "cd ROOTDIR/titer/scripts && CUDA_VISIBLE_DEVICES=$gpu ./run_test.sh $gpu $train_mode $test_mode $ewc_lambda $buffer_size $m $dataset $prefix > ROOTDIR/titer_ours_outputs/logs/${prefix}_${dataset}_${train_mode}_${test_mode}_${ewc_lambda}_${buffer_size}_${m}.log 2>&1 &" &

	      done


  done





