#!/bin/bash

# Initialize variables
TRAIN_MODE="sgd"
EWC_LAMBDA=0.001
BUFFER_SIZE=400
DATA_SET="ICEWS1807"
LAYER=2
HEAD=4

# Initialize counters and container names
cuda_counter=0
container_usage_counter=0
CONTAINER_NAME=""

# Hyperparameter values to search over
neighbors=("10" "15" "20" "25")
lmbdas=("0.3" "0.5" "0.7")
mus=("0.3" "0.5" "0.7")
degrees=("True")
fractions=("0.2" "0.5" "0.8" "1") #fractions=("0" "0.5" "1")
probs=("mean" "max") #probs=(""mean")

# Loop over hyperparameters
for neighbor in "${neighbors[@]}"; do
  for lmbda in "${lmbdas[@]}"; do
    for mu in "${mus[@]}"; do
      for degree in "${degrees[@]}"; do
        for fraction in "${fractions[@]}"; do
          for prob in "${probs[@]}"; do
            if [ "$prob" == "mean" ] && [ "$fraction" == "0.0" ]; then
              echo "skipping ...."
              continue
            fi

        PREFIX="IM_True_neighbors_${neighbor}_lmbda_${lmbda}_mu_${mu}_degree_${degree}_weighted_True_prob_${prob}_fraction_${fraction}_
#        PREFIX="name_sampling_weighted_True_prob_${prob}_fraction_${fraction}_"
        echo $CONTAINER_NAME $cuda_counter $PREFIX $DATA_SET
        # Run the command
        runai exec $CONTAINER_NAME -- /bin/sh -c "cd ROOTDIR/titer/scripts && ./run_train.sh -c $cuda_counter -t $TRAIN_MODE -e $EWC_LAMBDA -b $BUFFER_SIZE -d $DATA_SET -l $LAYER -h $HEAD -p $PREFIX 1 > ROOTDIR/logs/train_$PREFIX${DATA_SET}_${TRAIN_MODE}.log 2>&1 &"

        # Increment counters
        let "cuda_counter = (cuda_counter + 1) % 8"


          done
        done
      done
    done
  done
done
