#!/bin/bash
rsync -av 'ROOTDIR/titer/' 'HOMEDIR/titer' --exclude '/wandb' --exclude '/titer_ours_outputs'
cd 'HOMEDIR/titer/'

CUDA=$1
TRAIN_MODE=$2 # "sgd", "er", "ewc", "er_ewc"
TEST_MODE=$3 # "ind", "all"
EWC_LAMBDA=$4
BUFFER_SIZE=$5
MODEL=$6
DATA_SET=$7
PREFIX=$8


if [[ "$DATA_SET" == *"ICEWS1807"* ]]; then
  END=15
else
  END=33
fi

DATA_DIR="data/$DATA_SET"
PARENT_OUTPUT_DIR="titer_ours_outputs/$DATA_SET"
CHECKPOINT_SAVE_PATH="$PARENT_OUTPUT_DIR/checkpoints_${PREFIX}${TRAIN_MODE}_${EWC_LAMBDA}_${BUFFER_SIZE}"
echo $CHECKPOINT_SAVE_PATH
echo $DATA_DIR


if [ ! -d "$DATA_DIR" ];then
  echo "copying datase"
  mkdir -p "$DATA_DIR"
  cp -r "ROOTDIR/datasets/$DATA_SET" "HOMEDIR/titer/data/"
fi

# make the parent output dir if not exists
if [ ! -d "$PARENT_OUTPUT_DIR" ];then
  mkdir -p "$PARENT_OUTPUT_DIR"
fi

rsync -av "ROOTDIR/$CHECKPOINT_SAVE_PATH/" "$CHECKPOINT_SAVE_PATH"


# Test for all
if [[ "$TEST_MODE" == "all" ]]; then
#CUDA_VISIBLE_DEVICES=$CUDA python continual_test.py --data_path $DATA_DIR --cuda --IM --checkpoint_path $CHECKPOINT_SAVE_PATH --start_model $MODEL --end $END
CUDA_VISIBLE_DEVICES=$CUDA python continual_test.py --data_path $DATA_DIR --cuda --checkpoint_path $CHECKPOINT_SAVE_PATH --start_model $MODEL --end $END --prefix $PREFIX

# Test for inductive
else
CUDA_VISIBLE_DEVICES=$CUDA python continual_test.py --data_path $DATA_DIR --cuda --test_inductive --IM --checkpoint_path $CHECKPOINT_SAVE_PATH --start_model $MODEL --end $END
#CUDA_VISIBLE_DEVICES=$CUDA python continual_test.py --data_path $DATA_DIR --cuda --test_inductive --checkpoint_path $CHECKPOINT_SAVE_PATH --start_model $MODEL --end $END

fi


# Create rank dir if not exists
cp -r "$CHECKPOINT_SAVE_PATH/ranks" "ROOTDIR/$CHECKPOINT_SAVE_PATH/"
cp -r "logs/" "ROOTDIR/titer_ours_outputs/"

#echo 'hi'