import requests, json, os, sys
from query_generator_onto import parse_triple
from utils.wikidata_types import get_wikidata_types
from utils.wikidata import Wikidata

def query_wikidata(query):
    url = 'https://query.wikidata.org/sparql'
    headers = {
        'Accept': 'application/sparql-results+json',
        'User-Agent': 'fccbc90d5a6aad243121263c4cbddd8c'
    }
    response = requests.get(url, headers=headers, params={'query': query})
    response.raise_for_status()
    return response.json()



def main():
    with open('onto_data.json', 'r') as f:
        data = json.load(f)

    wikidata =Wikidata()

    new_data = []
    # sparql_taxon_prey = """
    # SELECT ?taxon ?taxonLabel ?food ?foodLabel WHERE {
    #     ?taxon wdt:P31 wd:Q16521.
    #     ?taxon wdt:P1034 ?food.
    #     SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }}
    #     LIMIT 1000
    # """
    # axiom = "FOR_ALL ?A:animal ?B:animal, MainFoodSource(?A:animal, ?B:animal) => PreysOn(?A:bird, ?B:animal)"
    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
    #     taxon = result['taxonLabel']['value']
    #     #body = result['bodyLabel']['value']
    #     food = result['foodLabel']['value']
    #     if taxon.startswith('Q') or food.startswith('Q'):
    #         continue
        
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'MainFoodSource({taxon}, {food})'],
    #             'axiomatic_format': f"""MainFoodSource({taxon}, {food}) => PreysOn({taxon}, {food})""",
    #             'types': {taxon: 'animal', food: 'animal'} })

    # problematic_queries = []
    # for entry in data:
    #     if entry['axiom'] == axiom and int(entry['query_id']) < 1564:
    #         print(entry['query_id'])
    #         ent = list(entry['types'].keys())[0]
    #         if 'forest' not in entry['types'][ent]:
    #             continue
    #         types = get_wikidata_types(ent)
            
    #         if types:
    #             if isinstance(types, dict):
    #                 types = types[ent]
    #             if 'forest' in types:
    #                 entry['types'][ent] = 'forest'

    #             elif 'desert' in types:
    #                 entry['types'][ent] = 'desert'
    #             elif 'mountain' in types:
    #                 entry['types'][ent] = 'mountain'
    #             elif 'river' in types:
    #                 entry['types'][ent] = 'river'
    #             elif 'museum' in types:
    #                 entry['types'][ent] = 'museum'
    #             else:
    #                 problematic_queries.append(entry['query_id'])
            
    #         else:
    #             problematic_queries.append(entry['query_id'])

    

    # print(problematic_queries)





    # sparql query for deserts located in Asia

#     sparql_taxon_hierarchy = """
#         SELECT ?taxon ?taxonLabel ?intermediateTaxon ?intermediateTaxonLabel ?higherTaxon ?higherTaxonLabel WHERE {
#   ?taxon wdt:P31 wd:Q16521;   # Instance of taxon
#          wdt:P279 ?intermediateTaxon.  # Subclass of an intermediate taxon
#   ?intermediateTaxon wdt:P279 ?higherTaxon.  # Intermediate taxon is subclass of a higher taxon
#   SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }
# }
#     """

#     axiom = "FOR_ALL ?A:animal ?B:taxon ?C:taxon, PartOf(?A:animal, ?B:taxon) && PartOf(?B:taxon, ?C:taxon) => PartOf(?A:animal, ?C:taxon)"
#     results = query_wikidata(sparql_taxon_hierarchy)
#     for result in results['results']['bindings']:
#         taxon = result['taxonLabel']['value']
#         #body = result['bodyLabel']['value']
#         int_taxon = result['intermediateTaxonLabel']['value']
#         higher_taxon = result['higherTaxonLabel']['value']
#         if taxon.startswith('Q') or int_taxon.startswith('Q') or higher_taxon.startswith('Q'):
#             continue
        
#         new_data.append(
#             {
#                 'query_id': f'{(len(data))+len(new_data)}',
#                 'axiom': axiom,
#                 'triples': [ f'PartOf({taxon}, {int_taxon})', f'PartOf({int_taxon}, {higher_taxon})'],
#                 'axiomatic_format': f"""PartOf({taxon}, {int_taxon}) && PartOf({int_taxon}, {higher_taxon}) => PartOf({taxon}, {higher_taxon})""",
#                 'types': {taxon: 'animal', int_taxon: 'taxon', higher_taxon: 'taxon'} })

    # sparql_taxon_prey = """
    # SELECT ?taxon ?taxonLabel ?country ?countryLabel WHERE {
    #     ?taxon wdt:P31 wd:Q5591854.
    #     ?taxon wdt:P495 ?country.
    #     SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }}
    #     LIMIT 400
    # """
    # axiom = "FOR_ALL ?A:breed ?B:animal ?C:country, SubClassOf(?A:breed, ?B:animal) && LivesIn(?A:breed, ?C:country) => LivesIn(?B:animal, ?C:country)"
    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
    #     taxon = result['taxonLabel']['value']
    #     animal = 'grade horse'
    #     #body = result['bodyLabel']['value']
    #     country = result['countryLabel']['value']
    #     if taxon.startswith('Q') or country.startswith('Q'):
    #         continue
        
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'SubClassOf({taxon}, {animal})', f'LivesIn({taxon}, {country})'],
    #             'axiomatic_format': f"""SubClassOf({taxon}, {animal}) && LivesIn({taxon}, {country}) => LivesIn({animal}, {country})""",
    #             'types': {taxon: 'breed', animal: 'animal', country: 'country'} })

#     sparql_taxon_prey = """
#     SELECT DISTINCT ?item ?itemLabel WHERE {
#   SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE]". }
#   {
#     SELECT DISTINCT ?item WHERE {
#       ?item p:P279 ?statement0.
#       ?statement0 (ps:P279/(wdt:P279*)) wd:Q16521.
#       ?item p:P279 ?statement1.
#       ?statement1 (ps:P279/(wdt:P279*)) wd:Q729.
#     }
#     LIMIT 100
#   }
# }
#     """
#     axiom = "FOR_ALL ?A:animal ?B:taxon, Subclass(?A:animal, ?B:taxon) => PartOf(?A:animal, ?B:taxon)"
#     results = query_wikidata(sparql_taxon_prey)
#     for result in results['results']['bindings']:
#         taxon = result['taxonLabel']['value']
#         animal = 'grade horse'
#         #body = result['bodyLabel']['value']
#         country = result['countryLabel']['value']
#         if taxon.startswith('Q') or country.startswith('Q'):
#             continue
        
#         new_data.append(
#             {
#                 'query_id': f'{(len(data))+len(new_data)}',
#                 'axiom': axiom,
#                 'triples': [ f'SubClassOf({taxon}, {animal})', f'LivesIn({taxon}, {country})'],
#                 'axiomatic_format': f"""SubClassOf({taxon}, {animal}) && LivesIn({taxon}, {country}) => LivesIn({animal}, {country})""",
#                 'types': {taxon: 'breed', animal: 'animal', country: 'country'} })


    # sparql_taxon_prey = """
    #     SELECT ?bacteria ?bacteriaLabel WHERE {
    #     ?bacteria wdt:P2597 wd:Q857288.
    #     SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }}
    #     LIMIT 1000
    # """
    # axiom = "FOR_ALL ?A:bacteria ?B:taxon, Subclass(?A:bacteria, ?B:taxon) && GramPositive(?B:taxon) => ResistantToAntibiotics(?A:bacteria)"
    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
        
    #     bacteria = result['bacteriaLabel']['value']
    #     taxon = f"{bacteria} bacteria"
    #     if taxon.startswith('Q') or bacteria.startswith('Q'):
    #         continue
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'SubClassOf({bacteria}, {taxon})', f'GramPositive({taxon})'],
    #             'axiomatic_format': f"""SubClassOf({bacteria}, {taxon}) && GramPositive({taxon}) => ResistantToAntibiotics({bacteria})""",
    #             'types': {taxon: 'taxon', bacteria: 'bacteria'} })

    # sparql_taxon_prey = """
    #     SELECT ?bacteria ?bacteriaLabel WHERE {
    #     ?bacteria wdt:P2597 wd:Q632006.
    #     SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }}
    #     LIMIT 1000
    # """
    # axiom = "FOR_ALL ?A:bacteria ?B:taxon, Subclass(?A:bacteria, ?B:taxon) && GramNegative(?B:taxon) => UnResistantToAntibiotics(?A:bacteria)"
    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
        
    #     bacteria = result['bacteriaLabel']['value']
    #     taxon = f"{bacteria} bacteria"
    #     if taxon.startswith('Q') or bacteria.startswith('Q'):
    #         continue
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'SubClassOf({bacteria}, {taxon})', f'GramNegative({taxon})'],
    #             'axiomatic_format': f"""SubClassOf({bacteria}, {taxon}) && GramNegative({taxon}) => UnResistantToAntibiotics({bacteria})""",
    #             'types': {taxon: 'taxon', bacteria: 'bacteria'} })

    # sparql_taxon_prey = """
    #     SELECT ?bacteria ?bacteriaLabel ?anti ?antiLabel WHERE {
    #     ?bacteria wdt:P2597 wd:Q632006.
    #     ?anti wdt:P2868 wd:Q12187.
    #     SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }}
    #     LIMIT 1000
    # """
    # axiom = "FOR_ALL ?A:bacteria ?B:antibiotic, UnResistantToAntibiotics(?A:bacteria) => CanBeUsedToTreat(?A:bacteria, ?B:antibiotic)"
    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
        
    #     bacteria = result['bacteriaLabel']['value']
    #     anti = result['antiLabel']['value']
    #     if anti.startswith('Q') or bacteria.startswith('Q'):
    #         continue
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'UnResistantToAntibiotics({bacteria})'],
    #             'axiomatic_format': f"""UnResistantToAntibiotics({bacteria}) => CanBeUsedToTreat({bacteria}, {anti})""",
    #             'types': {anti: 'anti biotic', bacteria: 'bacteria'} })

    # sparql_taxon_prey = """
    #     SELECT ?food ?foodLabel ?dish ?dishLabel ?dishtype ?dishtypeLabel WHERE {
    #     ?food wdt:P279 ?dish.
    #     ?dish wdt:P31 wd:Q19861951.
    #     ?dish wdt:P279 ?dishtype.
    #     SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }}
    #     LIMIT 1000
    # """
    # axiom = "FOR_ALL ?A:food ?B:food category ?C:food category, PartOf(?A:food, ?B:food category) && PartOf(?B:food category, ?C:food category) => PartOf(?A:food, ?C:food category)"
    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
    #     food = result['foodLabel']['value']
    #     dish = result['dishLabel']['value']
    #     dishtype = result['dishtypeLabel']['value']
    #     if food.startswith('Q') or dish.startswith('Q') or dishtype.startswith('Q'):
    #         continue
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'PartOf({food}, {dish})', f'PartOf({dish}, {dishtype})'],
    #             'axiomatic_format': f"""PartOf({food}, {dish}) && PartOf({dish}, {dishtype}) => PartOf({food}, {dishtype})""",
    #             'types': {food: 'food', dish: 'food category', dishtype: 'food category'} })

    # sparql_taxon_prey = """
    #     SELECT ?food ?foodLabel ?product ?productLabel WHERE {
    #     ?food wdt:P31 wd:Q746549.
    #     ?food wdt:P527 ?product.
    #     ?product wdt:P279 wd:Q629103.
    #     SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }}
    #     LIMIT 1000
    # """
    # axiom = "FOR_ALL ?A:food ?B:animal product, PartOf(?A:food, ?B:animal product) => ContainsAnimalProduct(?A:food)"
    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
    #     food = result['foodLabel']['value']
    #     product = result['productLabel']['value']
    #     if food.startswith('Q') or product.startswith('Q'):
    #         continue
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'PartOf({product}, {food})'],
    #             'axiomatic_format': f"""PartOf({product}, {food}) => ContainsAnimalProduct({food})""",
    #             'types': {food: 'food', product: 'animal product'} })

    # sparql_taxon_prey = """
    #     SELECT ?food ?foodLabel ?location ?locationLabel WHERE {
    #     ?food wdt:P31 wd:Q746549.
    #     ?food wdt:P495 ?location.
    #     SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }}
    #     LIMIT 1000
    # """
    # axiom = "FOR_ALL ?A:food ?B:place or location, OriginatesFrom(?A:food, ?B:country) => ConsumedByPeopleIn(?A:food, ?B:place or location)"
    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
    #     food = result['foodLabel']['value']
    #     location = result['locationLabel']['value']
    #     if food.startswith('Q') or location.startswith('Q'):
    #         continue
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'OriginatesFrom({food}, {location})'],
    #             'axiomatic_format': f"""OriginatesFrom({food}, {location}) => ConsumedByPeopleIn({food}, {location})""",
    #             'types': {food: 'food', location: 'location'} })

    # sparql_taxon_prey = """
    #      SELECT ?car ?carLabel ?company ?companyLabel ?loc ?locLabel WHERE {
    #      ?car wdt:P31 wd:Q3231690.
    #      ?car wdt:P176 ?company.
    #      ?company wdt:P17 wd:Q218.
    #      SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }}
    #      LIMIT 1000
    # """
    # axiom = "FOR_ALL ?A:vehicle ?B:company ?C:country, ManufacturedBy(?A:vehicle, ?B:company) && LocatedIn(?B:company, ?C:country) => ManufacturedIn(?A:vehicle, ?C:country)",

    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
    #     car = result['carLabel']['value']
    #     company = result['companyLabel']['value']
    #     country = 'Romania'
    #     if car.startswith('Q') or company.startswith('Q'):
    #         continue
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'ManufacturedBy({car}, {company})', f'LocatedIn({company}, {country})'],
    #             'axiomatic_format': f"""ManufacturedBy({car}, {company}) && LocatedIn({company}, {country}) => ManufacturedIn({car}, {country})""",
    #             'types': {car: 'vehicle', company: 'company', country: 'country'} })

    # sparql_taxon_prey = """
    #      SELECT ?car ?carLabel ?company ?companyLabel ?loc ?locLabel WHERE {
    #      ?car wdt:P31 wd:Q3231690.
    #      ?car wdt:P176 ?company.
    #      ?company wdt:P17 wd:Q218.
    #      SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }}
    #      LIMIT 1000
    # """
    # axiom = "FOR_ALL ?A:vehicle ?B:company ?C:country, ManufacturedBy(?A:vehicle, ?B:company) && LocatedIn(?B:company, ?C:country) => ManufacturedIn(?A:vehicle, ?C:country)",

    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
    #     car = result['carLabel']['value']
    #     company = result['companyLabel']['value']
    #     country = 'Romania'
    #     if car.startswith('Q') or company.startswith('Q'):
    #         continue
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'ManufacturedBy({car}, {company})', f'LocatedIn({company}, {country})'],
    #             'axiomatic_format': f"""ManufacturedBy({car}, {company}) && LocatedIn({company}, {country}) => ManufacturedIn({car}, {country})""",
    #             'types': {car: 'vehicle', company: 'company', country: 'country'} })


    # sparql_taxon_prey = """
    #      SELECT ?vehicle ?vehicleLabel ?army ?armyLabel ?loc ?locLabel WHERE {
    #      ?vehicle wdt:P31 wd:Q104843.
    #      ?vehicle wdt:P137 ?army.
    #      ?army wdt:P17 ?loc.
    #      SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }}
    #      LIMIT 1000
    # """
    # axiom =  "FOR_ALL ?A:vehicle ?B:Army ?C:Place or location, OperatedBy(?A:vehicle, ?B:Army) && BelongsTo(?B:Army, ?C:place or location) => BelongsTo(?A:vehicle, ?C:place or location)"

    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
    #     vehicle = result['vehicleLabel']['value']
    #     army = result['armyLabel']['value']
    #     loc = result['locLabel']['value']
    #     if vehicle.startswith('Q') or army.startswith('Q') or loc.startswith('Q'):
    #         continue
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'OperatedBy({vehicle}, {army})', f'BelongsTo({army}, {loc})'],
    #             'axiomatic_format': f"""OperatedBy({vehicle}, {army}) && BelongsTo({army}, {loc}) => BelongsTo({vehicle}, {loc})""",
    #             'types': {vehicle: 'vehicle', army: 'army', loc: 'country'} })


    # sparql_taxon_prey = """
    #      SELECT ?vehicle ?vehicleLabel ?army ?armyLabel ?loc ?locLabel WHERE {
    #      ?vehicle wdt:P31 wd:Q104843.
    #      ?vehicle wdt:P137 ?army.
    #      ?army wdt:P17 ?loc.
    #      SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }}
    #      LIMIT 1000
    # """
    # axiom =  "FOR_ALL ?A:vehicle ?B:country ?C:country D:battle, BelongsTo(?A:vehicle, ?B:country) && UsedIn(?A:vehicle, ?D:battle) && Fought(?B:country, ?C:country) => UsedAgainst(?A:vehicle, ?C:country)"

    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
    #     vehicle = result['vehicleLabel']['value']
    #     army = result['armyLabel']['value']
    #     loc = result['locLabel']['value']
    #     if vehicle.startswith('Q') or army.startswith('Q') or loc.startswith('Q'):
    #         continue
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'OperatedBy({vehicle}, {army})', f'BelongsTo({army}, {loc})'],
    #             'axiomatic_format': f"""OperatedBy({vehicle}, {army}) && BelongsTo({army}, {loc}) => BelongsTo({vehicle}, {loc})""",
    #             'types': {vehicle: 'vehicle', army: 'army', loc: 'country'} })


    # sparql_taxon_prey = """
    #      SELECT ?chemical ?chemicalLabel ?condition ?conditionLabel ?specialty ?specialtyLabel WHERE {
    #      ?chemical wdt:P31 wd:Q113145171.
    #      ?chemical wdt:P2175 ?condition.
    #      ?condition wdt:P1995 ?specialty.
    #      ?army wdt:P17 ?loc.
    #      SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }}
    #      LIMIT 1000
    # """
    # axiom =  "FOR_ALL ?A:chemical entity ?B:disease ?C:medical specialty, Treats(?A:chemical entity, ?B:disease) && KnowsAbout(?B:disease, ?C:medical specialty) => KnowsAbout(?A:chemical entity, ?C:medical specialty)"

    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
    #     chemical = result['chemicalLabel']['value']
    #     condition = result['conditionLabel']['value']
    #     specialty = result['specialtyLabel']['value']
    #     if chemical.startswith('Q') or condition.startswith('Q') or specialty.startswith('Q'):
    #         continue
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'Treats({chemical}, {condition})', f'KnowsAbout({condition}, {specialty})'],
    #             'axiomatic_format': f"""Treats({chemical}, {condition}) && KnowsAbout({condition}, {specialty}) => KnowsAbout({chemical}, {specialty})""",
    #             'types': {chemical: 'chemical entity', condition: 'disease', specialty: 'medical specialty'} })

    # sparql_taxon_prey = """
    #      SELECT ?chemical ?chemicalLabel ?chemical2 ?chemical2Label ?condition ?conditionLabel WHERE {
    #      ?chemical wdt:P31 wd:Q113145171.
    #      ?chemical2 wdt:P31 wd:Q113145171.
    #      ?chemical wdt:P2175 ?condition.
    #      ?chemical2 wdt:P2175 ?condition.
    #      FILTER(?chemical != ?chemical2).
    #      SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }}
    #      LIMIT 1000
    # """
    # axiom = "FOR_ALL ?A:chemical entity ?B:chemical entity ?C:disease, Treats(?A:chemical entity, ?C:disease) && Treats(?B:chemical entity, ?C:disease) => HaveSimilarEffects(?A:chemical entity, ?B:chemical entity)"
    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
    #     chemical = result['chemicalLabel']['value']
    #     chemical2 = result['chemical2Label']['value']
    #     condition = result['conditionLabel']['value']
    #     if chemical.startswith('Q') or condition.startswith('Q') or chemical2.startswith('Q'):
    #         continue
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'Treats({chemical}, {condition})', f'Treats({chemical2}, {condition})'],
    #             'axiomatic_format': f"""Treats({chemical}, {condition}) && Treats({chemical2}, {condition}) => HaveSimilarEffects({chemical}, {chemical2})""",
    #             'types': {chemical: 'chemical entity', chemical2: 'chemical entity', condition: 'disease'} })
    
    # sparql_taxon_prey = """
    #      SELECT ?condition ?conditionLabel ?chemical ?chemicalLabel ?symptom ?symptomLabel WHERE {
    #      ?condition wdt:P31 wd:Q112193867.
    #      ?condition wdt:P2176 ?chemical.
    #      ?condition wdt:P780 ?symptom.
    #      SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }}
    #      LIMIT 2000
    # """
    # axiom = "FOR_ALL ?A:disease ?B:symptom ?C:treatment, Causes(?A:disease, ?B:symptom) && Treats(?C:treatment, ?A:disease) => Treats(?C:treatment, ?B:symptom)"
    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
    #     chemical = result['chemicalLabel']['value']
    #     symptom = result['symptomLabel']['value']
    #     condition = result['conditionLabel']['value']
    #     if chemical.startswith('Q') or condition.startswith('Q') or symptom.startswith('Q'):
    #         continue
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'Causes({condition}, {symptom})', f'Treats({chemical}, {condition})'],
    #             'axiomatic_format': f"""Causes({condition}, {symptom}) && Treats({chemical}, {condition}) => Treats({chemical}, {symptom})""",
    #             'types': {chemical: 'chemical entity', condition: 'disease', symptom: 'symptom'} })

    # sparql_taxon_prey = """
    #      SELECT ?condition ?conditionLabel ?specialty ?specialtyLabel ?symptom ?symptomLabel WHERE {
    #      ?condition wdt:P31 wd:Q112193867.
    #      ?condition wdt:P1995 ?specialty.
    #      ?condition wdt:P780 ?symptom.
    #      SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }}
    #      LIMIT 1000
    # """
    # axiom = "FOR_ALL ?A:disease ?B:symptom ?C:medical specialty, Causes(?A:disease, ?B:symptom) && Studies(?B:disease, ?C:medical specialty) => Studies(?A:symptom, ?C:medical specialty)"
    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
    #     specialty = result['specialtyLabel']['value']
    #     symptom = result['symptomLabel']['value']
    #     condition = result['conditionLabel']['value']
    #     if specialty.startswith('Q') or condition.startswith('Q') or symptom.startswith('Q'):
    #         continue
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'Causes({condition}, {symptom})', f'Studies({symptom}, {specialty})'],
    #             'axiomatic_format': f"""Causes({condition}, {symptom}) && Studies({symptom}, {specialty}) => Studies({condition}, {specialty})""",
    #             'types': {specialty: 'medical specialty', condition: 'disease', symptom: 'symptom'} })

    # sparql_taxon_prey = """
    #      SELECT ?player ?playerLabel ?club ?clubLabel ?country ?countryLabel WHERE {
    #      ?player wdt:P106 wd:Q937857.
    #      ?player wdt:P54 ?club.
    #      ?club wdt:P17 wd:Q881.
    #      SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }}
    #      LIMIT 1000
    # """
    # axiom = "FOR_ALL ?A:human ?B:sport club ?C:country, MemberOf(?A:human, ?B:sport club) && LocatedIn(?B:sport club, ?C:country) => PlayedIn(?A:human, ?C:country"
    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
    #     player = result['playerLabel']['value']
    #     club = result['clubLabel']['value']
    #     country = 'Vietnam'
    #     if player.startswith('Q') or club.startswith('Q') or country.startswith('Q'):
    #         continue
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'MemberOf({player}, {club})', f'LocatedIn({club}, {country})'],
    #             'axiomatic_format': f"""MemberOf({player}, {club}) && LocatedIn({club}, {country}) => PlayedIn({player}, {country})""",
    #             'types': {player: 'human', club: 'sport club', country: 'country'} })
        
    # sparql_taxon_prey = """
    #      SELECT ?player ?playerLabel ?club ?clubLabel ?league ?leagueLabel WHERE {
    #      ?player wdt:P106 wd:Q937857.
    #      ?player wdt:P54 ?club.
    #      ?club wdt:P118 ?league.
    #      ?league wdt:P17 wd:Q794.
    #      SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }}
    #      LIMIT 1000
    # """
    # axiom = "FOR_ALL ?A:human ?B:sport club ?C:sport league, MemberOf(?A:human, ?B:sport club) && PlayedIn(?B:sport club, ?C:sport league) => PlayedIn(?A:human, ?C:sport league)"
    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
    #     player = result['playerLabel']['value']
    #     club = result['clubLabel']['value']
    #     country = 'Iran'
    #     if player.startswith('Q') or club.startswith('Q') or country.startswith('Q'):
    #         continue
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'MemberOf({player}, {club})', f'PlayedIn({club}, {country})'],
    #             'axiomatic_format': f"""MemberOf({player}, {club}) && PlayedIn({club}, {country}) => PlayedIn({player}, {country})""",
    #             'types': {player: 'human', club: 'sport club', country: 'country'} })
    
    # sparql_taxon_prey = """
    #      SELECT ?league ?leagueLabel ?sport ?sportLabel ?stuff ?stuffLabel WHERE {
    #     ?league wdt:P31 wd:Q15991290.
    #     ?league wdt:P641 ?sport.
    #     ?sport wdt:P2283 ?stuff.
    #     SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }}
    #      LIMIT 1000
    # """
    # axiom = "FOR_ALL ?A:sport league ?B:sport ?C:product, PartOf(?A:sport league, ?B:sport) && UsedIn(?B:sport, ?C:product) => UsedIn(?A:sport league, ?C:product)"
    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
    #     league = result['leagueLabel']['value']
    #     sport = result['sportLabel']['value']
    #     stuff = result['stuffLabel']['value']
    #     if league.startswith('Q') or sport.startswith('Q') or stuff.startswith('Q'):
    #         continue
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'PartOf({league}, {sport})', f'UsedIn({sport}, {stuff})'],
    #             'axiomatic_format': f"""PartOf({league}, {sport}) && UsedIn({sport}, {stuff}) => UsedIn({league}, {stuff})""",
    #             'types': {league: 'sport league', sport: 'sport', stuff: 'product'} })

    # sparql_taxon_prey = """
    # SELECT ?club ?clubLabel ?league ?leagueLabel ?stuff ?stuffLabel WHERE {
    # ?club wdt:P118 ?league.
    # ?league wdt:P641 ?sport.
    # ?sport wdt:P2283 ?stuff.
    # SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }
    # }
    # LIMIT 1000
    # """
    # axiom = "FOR_ALL ?A:sport club ?B:sport league, PartOf(?A:sport club, ?B:sport league) && UsedIn(?B:sport league, ?C:product) => UsedBy(?A:sport club, ?C:product)"
    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
    #     club = result['clubLabel']['value']
    #     league = result['leagueLabel']['value']
    #     stuff = result['stuffLabel']['value']
    #     if league.startswith('Q') or club.startswith('Q') or stuff.startswith('Q'):
    #         continue
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'PartOf({club}, {league})', f'UsedIn({league}, {stuff})'],
    #             'axiomatic_format': f"""PartOf({club}, {league}) && UsedIn({league}, {stuff}) => UsedBy({club}, {stuff})""",
    #             'types': {club: 'sport club', league: 'sport league', stuff: 'product'} })
        
    # sparql_taxon_prey = """
    # SELECT ?club ?clubLabel ?league ?leagueLabel ?stuff ?stuffLabel WHERE {
    # ?club wdt:P118 ?league.
    # ?league wdt:P641 ?sport.
    # ?sport wdt:P2283 ?stuff.
    # SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }
    # }
    # LIMIT 1000
    # """
    # axiom = "FOR_ALL ?A:human ?B:sport club ?C:business, MemberOf(?A:human, ?B:sport club) && OwnedBy(?B:sport club, ?C:business) => WorkedFor(?A:human, ?C:business)"
    # results = query_wikidata(sparql_taxon_prey)
    # for result in results['results']['bindings']:
    #     club = result['clubLabel']['value']
    #     league = result['leagueLabel']['value']
    #     stuff = result['stuffLabel']['value']
    #     if league.startswith('Q') or club.startswith('Q') or stuff.startswith('Q'):
    #         continue
    #     new_data.append(
    #         {
    #             'query_id': f'{(len(data))+len(new_data)}',
    #             'axiom': axiom,
    #             'triples': [ f'PartOf({club}, {league})', f'UsedIn({league}, {stuff})'],
    #             'axiomatic_format': f"""PartOf({club}, {league}) && UsedIn({league}, {stuff}) => UsedBy({club}, {stuff})""",
    #             'types': {club: 'sport club', league: 'sport league', stuff: 'product'} })
#     sparql_taxon_prey = """
  
#      SELECT ?drug ?drugLabel WHERE {
#      ?drug wdt:P2175 wd:Q19597369.
#      SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }
#      }
#      LIMIT 400
# """
#     axiom = "FOR_ALL ?A:bacteria ?B:taxon ?C:antibiotic, SubclassOf(?A:bacteria, ?B:taxon) && GramNegative(?B:taxon) && TreatsGramNegative(?C:antibiotic) => UnResistantTo(?A:bacteria, ?C:antibiotic)"
#     results = query_wikidata(sparql_taxon_prey)
#     for result in results['results']['bindings']:
#         antibiotic = result['drugLabel']['value']
#         if antibiotic.startswith('Q'):
#             continue
#         new_data.append(
#             {
#                 'query_id': f'{(len(data))+len(new_data)}',
#                 'axiom': axiom,
#                 'triples': [ f'TreatsGramNegative({antibiotic})'],
#                 'axiomatic_format': f'TreatsGramNegative({antibiotic})',
#                 'types': {antibiotic: 'anti biotic'} })

    
    
    
    # adjusting originates from queries



    # for i, entry in enumerate(data):
    #     triples = entry['triples']
    #     if 'OriginatesFrom' in triples[0]:
    #         print(i)
    #         data.remove(entry)
    #         _, food, country = parse_triple(triples[0])
    #         country_id = wikidata.get_id(country)
    #         sparql_query = f'''
    #         SELECT ?city ?cityLabel WHERE {{
    #         ?city p:P31 ?statement0.
    #         ?statement0 (ps:P31/(wdt:P279*)) wd:Q515.
    #         ?city p:P17 ?statement1.
    #         ?statement1 (ps:P17/(wdt:P279*)) wd:{country_id}.
    #         SERVICE wikibase:label {{ bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }}
    #         }}
    #         LIMIT 10
    #         '''
    #         results = query_wikidata(sparql_query)
    #         for result in results['results']['bindings']:
    #             city = result['cityLabel']['value']
    #             if city.startswith('Q'):
    #                 continue
    #             new_data.append(
    #                 {
    #                     'query_id': f'{(len(data))+len(new_data)}',
    #                     'axiom': entry['axiom'],
    #                     'triples': [ f'OriginatesFrom({food}, {country})', f'PartOf({city}, {country})'],
    #                     'axiomatic_format': entry['axiomatic_format'],
    #                     'types': {food:'food', city: 'city', country: 'country'} })


    
    term2types = {}
    for entry in data:
        for object_name in entry['types'].keys():
            term2types[object_name] = entry['types'][object_name]

    with open('data/term2types.json', 'w', encoding='utf-8') as f:
        json.dump(term2types, f, indent=4, ensure_ascii=False)



    print(len(new_data))
    #data.extend(new_data)
    with open('onto_data.json', 'w', encoding='utf-8') as f:
        json.dump(data, f, indent=4, ensure_ascii=False)

    # # forming the a-box and t-box files
    #a_box_set = set()
    a_box = []
    for entry in data:
        triples = entry['triples']
        for triple in triples:
            #a_box_set.add(triple)
            if triple not in a_box:
                a_box.append(triple)


    #a_box = list(a_box_set)
    with open('a-box-onto.json', 'w', encoding='utf-8') as f:
        json.dump(a_box, f, indent=4, ensure_ascii=False)

if __name__ == '__main__':
    main()

