import os
from openai import OpenAI
from groq import Groq
from dotenv import load_dotenv
import google.generativeai as genai
from tenacity import (
    retry,
    stop_after_attempt,
    wait_random_exponential,
)

load_dotenv()
GOOGLE_API_KEY=os.getenv('GOOGLE_API_KEY')
GROQ_API_KEY=os.getenv('GROQ_API_KEY')
genai.configure(api_key=GOOGLE_API_KEY)
client = OpenAI()

# TODO: don't need class, make this a method

class LLM:

    @retry(wait=wait_random_exponential(min=1, max=60), stop=stop_after_attempt(6))
    def __call__(self, messages, model="gemini"):
        if "gpt" in model:
            client = OpenAI()
            model = "gpt-3.5-turbo"
            completion = client.chat.completions.create(
            model=model, messages=messages)
            return completion.choices[0].message.content 
        
        elif "gemini" in model:
            model = genai.GenerativeModel('gemini-1.5-flash')
            response = model.generate_content(messages)
            return response.text
        
        elif "groq" not in model:
            prompt = messages[0] + " " + messages[1]
            client = OpenAI(base_url="https://gpuXXX:XXXX/v1", api_key="EMPTY")
            completion = client.completions.create(
                model = "/model-weights/Meta-Llama-3-8B",
                prompt=prompt
            )
            return completion.choices[0].text

        elif "groq" in model:
            client = Groq(api_key=GROQ_API_KEY)
            completion = client.chat.completions.create(
                model= "mixtral-8x7b-32768", messages=messages)
            return completion.choices[0].message.content
