# -*- coding: utf-8 -*-
import sklearn.datasets as ds
from data.defaults import simple_load_fold, convert_fixed_point

num_classes = -1

california = ds.fetch_california_housing()

feature_names = california.feature_names
target_names = california.target_names
cols = target_names + feature_names
del(california)

def load(fixed_point=False):
    data = ds.fetch_california_housing(as_frame=True)

    yX = data.data.copy()
    yX.insert(0, target_names[0], data.target)
    
    return convert_fixed_point(yX) if fixed_point else yX
        

load_fold = simple_load_fold(load)
