## To run the experiments

### Setup

Create a virtual environment (Python 3.10) and run the following command from the `experiments` directory:

```shell
pip install -r requirements.txt
```

### NRGBoost

To run hyperparameter tuning run from the `experiments` directory:
```
python nrgb/run.py dataset_name
```

To run independent sampling from the best model run:
```
python nrgb/sample_indepedent.py dataset_name
```

To run autocorrelated sampling from the best model run:
```
python nrgb/sample_autocorrelated.py dataset_name
```
The latter is faster but produces autocorrelated samples.

## DEF

To run hyperparameter tuning for DEF (ISE) run from the `experiments` directory:
```
python def/run.py dataset_name -c brier 
```

To run hyperparameter tuning for DEF (KL) run from the `experiments` directory:
```
python def/run.py dataset_name -c likelihood 
```

To run sampling from the best model run:
```
python def/sample.py dataset_name -c (brier or likelihood)
```
