#/bin/bash

# Warehouse-A
for ((i=0; i<20; i++))
do
    ma_cac_rnn_V.py --save_dir='ma_cac_warehouse_A' \
                    --run_id=$i \
                    --env_id='OSD-D-v7' \
                    --n_agent=3 \
                    --env_terminate_step=200 \
                    --a_lr=0.0003 \
                    --c_lr=0.003 \
                    --train_freq=4 \
                    --n_env=4 \
                    --c_target_update_freq=16 \
                    --n_step_TD=3 \
                    --grad_clip_norm=0 \
                    --eps_start=1.0 \
                    --eps_end=0.01 \
                    --eps_stable_at=10_000 \
                    --total_epi=40_000 \
                    --gamma=1.0 \
                    --seed=$((10*i+1)) \
                    --a_rnn_layer_size=64 \
                    --c_rnn_layer_size=64 \
                    --h0_speed_ps 18 18 18 18 \
                    --h1_speed_ps 18 18 18 18 \
                    --d_pen=-20.0 \
                    --tb_m_speed=0.8 \
                    --sample_epi \
                    --eval_policy &
done

# Warehouse-B
for ((i=0; i<20; i++))
do
    ma_cac_rnn_V.py --save_dir='ma_cac_warehouse_B' \
                    --run_id=$i \
                    --env_id='OSD-T-v1' \
                    --n_agent=4 \
                    --env_terminate_step=250 \
                    --a_lr=0.0003 \
                    --c_lr=0.003 \
                    --train_freq=8 \
                    --n_env=8 \
                    --c_target_update_freq=64 \
                    --n_step_TD=3 \
                    --grad_clip_norm=0 \
                    --eps_start=1.0 \
                    --eps_end=0.01 \
                    --eps_stable_at=10_000 \
                    --total_epi=90_000 \
                    --gamma=1.0 \
                    --seed=$((10*i+1)) \
                    --a_rnn_layer_size=64 \
                    --c_rnn_layer_size=64 \
                    --h0_speed_ps 40 40 40 40 \
                    --h1_speed_ps 40 40 40 40 \
                    --h2_speed_ps 40 40 40 40 \
                    --d_pen=-20.0 \
                    --tb_m_speed=0.8 \
                    --sample_epi \
                    --eval_policy & 
done

# Warehouse-C
for ((i=0; i<20; i++))
do
    ma_cac_rnn_V.py --save_dir='ma_cac_warehouse_C' \
                    --run_id=$i \
                    --env_id='OSD-T-v0' \
                    --n_agent=3 \
                    --env_terminate_step=250 \
                    --a_lr=0.0005 \
                    --c_lr=0.001 \
                    --train_freq=4 \
                    --n_env=4 \
                    --c_target_update_freq=64 \
                    --n_step_TD=3 \
                    --grad_clip_norm=0 \
                    --eps_start=1.0 \
                    --eps_end=0.05 \
                    --eps_stable_at=10_000 \
                    --total_epi=90_000 \
                    --gamma=1.0 \
                    --seed=$((10*i+1)) \
                    --a_rnn_layer_size=64 \
                    --c_rnn_layer_size=64 \
                    --h0_speed_ps 30 30 30 30 \
                    --h1_speed_ps 40 40 40 40 \
                    --h2_speed_ps 40 40 40 40 \
                    --d_pen=-20.0 \
                    --tb_m_speed=0.8 \
                    --sample_epi \
                    --eval_policy & 
done
