We provide the code for all experiments from the main text of the paper. We also provide code for our differentiable iLQR library, our in-house Adam implementation, and the Cmdargs library used to get arguments from the command line. All results described in the paper can be generated using the code found in this folder.  Code can be run using the instructions below. 

**Description of the code** : 
In the following, we describe the different files, starting from the folder structure and mentioning the key files necessary to reproduce results described in the paper.  
The .ml files are the ones containing the code, and the .mli and _typ.ml files contain signatures for the different modules. 
*VAE folder* : 
-> the VAE folder contains the main components of our iLQR-VAE library. 
-> in variational.ml, we define all the functions called in the scripts. The iLQRsolve function relies on the separate differentiable iLQR library.
-> the code for the dynamics, likelihoods and priors are included in the corresponding files
*SRC* : 
-> the src folder contains the code used to run the experiments describe in the paper. 
-> The code used to generate the data from Fig 1. is in  "autonomous.ml".
-> The code used to generate figure 3 is in the "lorenz"* files.
-> The code used to analyze the data from Fig 4A is in the "monkey*" files.


**How to run it** 
- *Dependencies* : other than the Dilqr and Adam libraries, which can be installed using "dune build @install" and "dune build install", the code relies on the Base library, the Owl library, the Owl-Opt library and the Owl-parameters library. All of these can be installed using the opam package manager. 
- *Running* Files and can be run by calling dune exec src/file.exe -- -arg1 ... -arg2 ... where "file" refers to the file being run and arg1, arg2 refer to arguments that need to be specified in the command line (those should be clear from the individual files). Alternatively, the code is written in a way that allows easily parallelization if MPI is installed, calling mpirun.

