include module type of Dynamics_typ

module Integrate (D : Dynamics_T) : sig
  val integrate : prms:D.P.p -> n:int -> u:AD.t -> AD.t
end

module Linear (X : sig
  val n_beg : int Option.t
end) : sig
  include Dynamics_T with type 'a P.prm = 'a Linear_P.prm

  val init
    :  dt_over_tau:float
    -> alpha:float
    -> beta:float
    -> Owl_parameters.setter
    -> int
    -> int
    -> P.p

  val unpack_a : prms:P.p -> AD.t
end

module Nonlinear (X : sig
  val phi : AD.t -> AD.t
  val d_phi : AD.t -> AD.t
end) : sig
  include Dynamics_T with type 'a P.prm = 'a Nonlinear_P.prm

  val init : ?radius:float -> n:int -> m:int -> Owl_parameters.setter -> P.p
  val enlarge : prms:P.p -> int -> P.p
end

module Two_area (X : sig
  val phi : AD.t -> AD.t
  val d_phi : AD.t -> AD.t
end) : sig
  include Dynamics_T with type 'a P.prm = 'a Two_area_P.prm

  val init : ?b:Owl.Mat.mat -> radius:float -> Owl_parameters.setter -> int -> int -> P.p
end

module Nonlinear_Init (X : sig
  val phi : AD.t -> AD.t
  val d_phi : AD.t -> AD.t
  val n_beg : int
end) : sig
  include Dynamics_T with type 'a P.prm = 'a Nonlinear_Init_P.prm

  val init
    :  ?radius:float
    -> n:int
    -> m:int
    -> Owl_parameters.setter
    -> Owl_parameters.t P.prm

  val enlarge : prms:P.p -> int -> P.p
end

module Two_area_mixed (X : sig
  val phi : AD.t -> AD.t
  val d_phi : AD.t -> AD.t
end) : sig
  include Dynamics_T with type 'a P.prm = 'a Two_area_mixed_P.prm

  val init : ?b:Owl.Mat.mat -> radius:float -> Owl_parameters.setter -> int -> int -> P.p
  val unpack_a : prms:P.p -> AD.t * AD.t * AD.t
end

module Nonlinear_2 (X : sig
  val phi : AD.t -> AD.t
  val d_phi : AD.t -> AD.t
  val n_beg : int Option.t
end) : sig
  include Dynamics_T with type 'a P.prm = 'a Nonlinear_2_P.prm

  val init : ?radius:float -> n:int -> m:int -> Owl_parameters.setter -> P.p
end

module Mini_GRU (X : sig
  val phi : AD.t -> AD.t
  val d_phi : AD.t -> AD.t
  val sigma : AD.t -> AD.t
  val d_sigma : AD.t -> AD.t
  val n_beg : int Option.t
end) : sig
  include Dynamics_T with type 'a P.prm = 'a Mini_GRU_P.prm

  val init : ?radius:float -> n:int -> m:int -> Owl_parameters.setter -> P.p
end

module Mini_GRU_IO (X : sig
  val phi : AD.t -> AD.t
  val d_phi : AD.t -> AD.t
  val sigma : AD.t -> AD.t
  val d_sigma : AD.t -> AD.t
  val n_beg : int Option.t
end) : sig
  include Dynamics_T with type 'a P.prm = 'a Mini_GRU_IO_P.prm

  val init : ?radius:float -> n:int -> m:int -> Owl_parameters.setter -> P.p
end
