include module type of Elbobo_typ

module Matrix_column_prior :
  ELBOBO_T
    with type 'a P_prior.prm = 'a Matrix_P.Prior.prm
     and type 'a P_posterior.prm = 'a Matrix_P.Posterior.prm
     and type sample = AD.t

module Matrix_scalar_prior :
  ELBOBO_T
    with type 'a P_prior.prm = 'a Matrix_P.Prior.prm
     and type 'a P_posterior.prm = 'a Matrix_P.Posterior.prm
     and type sample = AD.t

module Pair (E1 : sig
  include ELBOBO_T

  val label : string
end) (E2 : sig
  include ELBOBO_T

  val label : string
end) :
  ELBOBO_T
    with type 'a P_prior.prm = ('a E1.P_prior.prm, 'a E2.P_prior.prm) Pair_P.prm_
     and type 'a P_posterior.prm =
          ('a E1.P_posterior.prm, 'a E2.P_posterior.prm) Pair_P.prm_
     and type sample = (AD.t, AD.t) Pair_P.prm_

module ARD :
  ELBOBO_T
    with type 'a P_prior.prm = 'a ARD_P.Prior.prm
     and type 'a P_posterior.prm = 'a ARD_P.Posterior.prm
     and type sample = AD.t * AD.t Option.t * AD.t Array.t

module NONE :
  ELBOBO_T
    with type 'a P_prior.prm = unit
     and type 'a P_posterior.prm = unit
     and type sample = unit

module ARD_GRU :
  ELBOBO_T
    with type 'a P_prior.prm = 'a ARD_GRU_P.Prior.prm
     and type 'a P_posterior.prm = 'a ARD_GRU_P.Posterior.prm
     and type sample = AD.t * AD.t * AD.t Option.t * AD.t Array.t
