open Base

let save_bin ~out:filename m =
  let output = Stdio.Out_channel.create filename in
  Caml.Marshal.to_channel output m [ Caml.Marshal.No_sharing ];
  Stdio.Out_channel.close output


let read_bin filename =
  let input = Stdio.In_channel.create filename in
  let m = Caml.Marshal.from_channel input in
  Stdio.In_channel.close input;
  m


let invert_scalar s =
  let inv_s = AD.Maths.(F 1. / Owl_parameters.extract s) in
  let open Owl_parameters in
  match s with
  | Pinned _ -> Pinned inv_s
  | Learned_bounded (_, Some lb, None) ->
    Learned_bounded (inv_s, Some lb, Some Float.(1. / lb))
  | Learned _ -> failwith "you are wrong (learned)"
  | _ -> failwith "you are wrong"


let time_this ~label f =
  let t0 = Unix.gettimeofday () in
  let res = f () in
  let t = Unix.gettimeofday () -. t0 in
  C.print_endline (Printf.sprintf "[%s] %f seconds\n%!" label t);
  res
