# Rethinking Of Metric Based Contrastive Learning Method’s Generalization Capability



<img src="picture.png" alt="picture" style="zoom:67%;" />



## **Dataset:**

There are a variety of datasets in our code, such as  CIFAR-10、CIFAR-100、DTD、Flowers102、Food101、aircraft、Pets、SVHN and so on. All of them can be used when you download them.

## Setup:

- Linux
- NVIDIA GPU (Tested on NVIDIA RTX A6000 and NVIDIA A40)
- torch >=  1.12
- CUDA >= 11.1

## Code:

- **train.py:** Used to train the model and Print out the information during training
- **train_horovod.py:** It's used when you're using horovod with multiple GPUs
- **stragety.py:** Provides a stragety for calculating the loss
- **Valid.py:** Used to evaluate models
- **Save.py:** Used to save logs, images and models
- **options.py:** Contains all the options for the argparser.
- **LARC.py: **LARS optimizer
- **Dataset.py:** Contains the PyTorch DatasetSet definition for loading data.
- **Model.py:** Define the model, including random initialization, supervised pre-training, unsupervised pre-training model, etc
- **Optimizers.py:** Defining the optimizer
- **Vits.py:** Vision Transformer.
- **Augmentation:** This folder contains the data augmentation section

## Training:

The running code is described as follows:

```
python train.py --batchsize (Select the batchsize) --log_root (The address where the log is stored) --log_name (Log Name) --lr (learning rate) --save_epoch (The model is stored every few epochs) --is_picture (Whether the drawing) --topology (Whether to use the topology loss) --CLoptimizer (What optimizer to use) --task (objective-task) --beta (The value of the hyperparameter beta) --pretrain_param (Choose supervised, unsupervised, or random initialization) --backbone (What model to use) --Epoch (How many epochs are trained) --warm_up (It starts after a few epochs) --stragety (What kind of loss is used) --lars (Whether to use LARS) --lr_policy (What learning rate change method to use) --resume_on (Whether to use the stored model for recovery)
```

### fine-tuning:

#### Supervised:

supervised pre-training on CIFAR-10 with empirical loss

```python
python train.py --batchsize 200 --log_root log/Cifar10_super/loss_1 --log_name Cifar10_super --lr 0.00005 --save_epoch 10 --is_picture 1 --topology 0 --CLoptimizer AdamW --task CIFAR10 --beta 0.3 --experince_aug 0 --pretrain_param super --backbone resnet50 --Epoch 80 --warm_up 5 --stragety CosineSimilarity --lars 0 --lr_policy cosine --resume_on 0
```



supervised pre-training on CIFAR-10 with UBGEAN 

```python
python train.py --batchsize 200 --log_root log/Cifar10_super/loss_2 --log_name Cifar10_super --lr 0.00005 --save_epoch 10 --is_picture 1 --topology 1 --CLoptimizer AdamW --task CIFAR10 --beta 0.3 --experince_aug 0 --pretrain_param super --backbone resnet50 --Epoch 80 --warm_up 5 --stragety CosineSimilarity --lars 0 --lr_policy cosine --resume_on 0
```



#### SimSiam:

supervised pre-training on CIFAR-10 with empirical loss

```python
python train.py --batchsize 200 --log_root log/Cifar10_nosuper/loss_1 --log_name Cifar10_nosuper --lr 0.00005 --save_epoch 10 --is_picture 1 --topology 0 --CLoptimizer AdamW --task CIFAR10 --beta 0.3 --experince_aug 0 --pretrain_param nosuper --backbone resnet50 --Epoch 80 --warm_up 5 --stragety CosineSimilarity --lars 0 --lr_policy cosine --resume_on 0
```

supervised pre-training on CIFAR-10 with UBGEAN 

```python
python train.py --batchsize 200 --log_root log/Cifar10_super/loss_2 --log_name Cifar10_nosuper --lr 0.00005 --save_epoch 10 --is_picture 1 --topology 1 --CLoptimizer AdamW --task CIFAR10 --beta 0.3 --experince_aug 0 --pretrain_param nosuper --backbone resnet50 --Epoch 80 --warm_up 5 --stragety CosineSimilarity --lars 0 --lr_policy cosine --resume_on 0
```



### Random initialization:

Random initialize on CIFAR10 with empirical loss

```python
python train.py --batchsize 200 --log_root log/Cifar10_none/loss_1 --log_name Cifar10_none --lr 0.00005 --save_epoch 10 --is_picture 1 --topology 0 --CLoptimizer AdamW --task CIFAR10 --beta 0.3 --experince_aug 0 --pretrain_param none --backbone resnet50 --Epoch 80 --warm_up 5 --stragety CosineSimilarity --lars 0 --lr_policy cosine --resume_on 0
```



Random initialize on CIFAR10 with UBGEAN 

```python
python train.py --batchsize 200 --log_root log/Cifar10_none/loss_2 --log_name Cifar10_none --lr 0.00005 --save_epoch 10 --is_picture 1 --topology 1 --CLoptimizer AdamW --task CIFAR10 --beta 0.3 --experince_aug 0 --pretrain_param nosuper --backbone resnet50 --Epoch 80 --warm_up 5 --stragety CosineSimilarity --lars 0 --lr_policy cosine --resume_on 0
```









