import argparse
import sys


def print_options(parser, opt, file=sys.stdout):
    """Print and save options
    It will print both current options and default values(if different).
    It will save options into a text file / [checkpoints_dir] / opt.txt
    """
    message = ''
    message += '----------------- Options ---------------\n'
    for k, v in sorted(vars(opt).items()):
        comment = ''
        default = parser.get_default(k)
        if v != default:
            comment = '\t[default: %s]' % str(default)
        message += '{:>25}: {:<30}{}\n'.format(str(k), str(v), comment)
    message += '----------------- End -------------------'
    print(message, file=file)


def parse_args():
    parser = argparse.ArgumentParser(description='CL-master')
    parser.add_argument('--task', type=str, default="CIFAR10", help='task we choose')  
    parser.add_argument('--stragety', type=str, default="MSE", help='type of Experience loss') 
    parser.add_argument('--stragety_Contrast', type=str, default="CosineSimilarity", help='type of UBGEAN loss')
    parser.add_argument('--data_dir', type=str, default="./data", help='root of datasets')  # Data set path
    parser.add_argument('--batchsize', type=int, default=356)
    parser.add_argument('--lr', type=float, default=3e-4)
    parser.add_argument('--backbone', type=str, default="resnet18")
    parser.add_argument('--CLoptimizer', type=str, default="SGD")
    parser.add_argument('--Q', type=float, default=0.05)
    parser.add_argument('--Epoch', type=int, default=100)
    parser.add_argument('--pretrain_param', type=str, default='none')
    parser.add_argument('--topology', type=int, default=0)
    parser.add_argument('--log_root', type=str, default='none') # Address for saving logs. If None, the log is not saved.
    parser.add_argument('--log_name', type=str, default='none') # The name of the log, the picture will be the same as that
    parser.add_argument('--is_picture', type=int, default=0) # Whether to save the image, if yes, the image will be stored in the same folder as the log, and the name is the same as the log
    parser.add_argument('--top_k', type=int, default=1) # top-k accuracy rate
    parser.add_argument('--save_epoch', type=int, default=20, help='Number of epoches to save model.')
    parser.add_argument('--niter', type=int, default=1, help='T_max of lr_scheduler.CosineAnnealingLR')
    parser.add_argument('--beta', type=float, default=0.3, help='The coefficient of the second loss')
    parser.add_argument('--lr_policy', type=str, default='cosine')
    parser.add_argument('--experince_aug', type=int, default=0)
    parser.add_argument('--warm_up', type=int, default=0)
    parser.add_argument('--lars', type=int, default=1, help='Use LARS')
    
    parser.add_argument('--begin_select_epoch',type=int,default=1,help='select best model from which epoch')
    parser.add_argument('--update_gate',type=int,default=0.01,help='save model if its acc improved 0.005')
    parser.add_argument('--save_best_function',type=int,default=0,help='turn on the best model save function if it is 1')
    parser.add_argument('--save_across_epoch',type=int,default=10,help='even though we do not have enough improvememt to meet update_gate, but we need to save model across the epoches')
    
    parser.add_argument('--use_adasum', type=int, default=0)
    parser.add_argument('--fp16-allreduce', action='store_true', default=False,
                    help='use fp16 compression during allreduce')
    parser.add_argument('--seed', type=int, default=42, metavar='S',
                    help='random seed (default: 42)')
    parser.add_argument('--gradient-predivide-factor', type=float, default=1.0,
                    help='apply gradient predivide factor in optimizer (default: 1.0)')
    parser.add_argument('--no_cuda', action='store_true', default=False,
                    help='disables CUDA training')
    parser.add_argument('--batches_per_allreduce', type=int, default=1,
                    help='number of batches processed locally before executing allreduce across workers; it multiplies total batch size.')
    parser.add_argument('--base_lr', type=float, default=3e-4,
                    help='learning rate for a single GPU')
    parser.add_argument('--gradient_predivide_factor', type=float, default=1.0,
                    help='apply gradient predivide factor in optimizer (default: 1.0)')
    parser.add_argument('--log-interval', type=int, default=20, metavar='N',
                    help='how many batches to wait before logging training status')
    
    parser.add_argument('--annotation-ratio', default=0.01, type=float,
                    help='annotation ratio of the data (default: 0.01)')
    parser.add_argument('--test-time-aug', action = 'store_true', default = False,
                    help='test time augmentation')
    parser.add_argument('--valid-only-aug', action = 'store_true', default = False,
                    help='only computes the accuracy of the augmented data')
    
    parser.add_argument('--resume_on', type=int, default=0, help='turn on resume')
    parser.add_argument('--resume_on_epoch', type=int, default=0, help='turn on resume from which epoch')
    parser.add_argument('--resume_on_file', type=str, default='none', help='turn on resume from which dir file')
    
    
    
    args = parser.parse_args()
    return args, parser
