#!/bin/bash
export CUDA_DEVICE_ORDER=PCI_BUS_ID
export CUDA_VISIBLE_DEVICES=0

exec >"emb.out" 2>&1

# set the dataset here
datasets=("glue-sst2")

# set the model here
# model_names=("all-minilm-l6-v2" "all-mpnet-base-v2" "all-roberta-large-v1" "sbert_large_mt_nlu_ru")
model_names=("all-roberta-large-v1")

LM_model=("llama-3.1-8b")

for dataset in "${datasets[@]}"; do
  for model_name in "${model_names[@]}"; do
    # cmd="python embedding.py --dataset $dataset --model_name $model_name --if_qwa --if_self_emb --self_model $LM_model"
    cmd="python embedding.py --dataset $dataset --model_name $model_name"
    echo $cmd
    $cmd
  done
done
