#!/bin/bash
export CUDA_DEVICE_ORDER=PCI_BUS_ID
export CUDA_VISIBLE_DEVICES=1
log_dir="./results/log"
log_file="$log_dir/embedding_0.out"
mkdir -p "$log_dir"
exec >"$log_file" 2>&1


test_datasets=("squad_50")

model_names=("all-roberta-large-v1")

for model_name in "${model_names[@]}"; do
  if [ "$model_name" == "bm25" ]; then
    for dataset in "${test_datasets[@]}"; do
      python utils/calculate_bm25.py --dataset $dataset
    done
  else
    for dataset in "${test_datasets[@]}"; do
      for model_name in "${model_names[@]}"; do
        cmd="python embedding.py --dataset $dataset --model_name $model_name"
        echo $cmd
        $cmd
      done
    done
  fi
done
