import itertools

def params_combinations(mode='binary'):
    params = {
    'mode': [mode],
    'd': [200],
    'train_scale': [1,5,10],
    # 'l': [3,6,12],
    'l': [4,8],
    'k': [4,8],
    'p': [0.5],
    'lam': [0.5],
    'mu': [0],
    'sigma': [1],
    'alpha': [0.1, 0.5, 1, 2, 5],
    'beta': [0.1, 0.5, 1, 2, 5],
    # 'random_seed': range(42,42+3,1),
    'random_seed': [42,43,44],
    }

    params_copy = params.copy()
    if mode == 'binary' or mode == 'uniform':
        del params_copy['alpha'], params_copy['beta'], params_copy['mu'], params_copy['sigma']
    elif mode == 'beta':
        del params_copy['mu'], params_copy['sigma']
    elif mode == 'normal' or mode == 'mix_normal':
        del  params_copy['alpha'], params_copy['beta']
    elif mode == 'truncated_normal':
        del params_copy['alpha'], params_copy['beta']
    print(params_copy)
    param_combinations = [dict(zip(params_copy.keys(), v)) for v in itertools.product(*params_copy.values())]
    return param_combinations