/*//////////////////////////////////////////////////////////
////////////////// Set up the Data /////////////////////////
//////////////////////////////////////////////////////////*/
var go_NameProvider = ['admiration', 'amusement', 'anger', 'annoyance', 'approval', 'caring',
 'confusion', 'curiosity', 'desire', 'disappointment', 'disapproval', 'disgust',
 'embarrassment', 'excitement', 'fear', 'gratitude', 'grief', 'joy', 'love',
 'nervousness', 'optimism', 'pride', 'realization', 'relief', 'remorse',
 'sadness', 'surprise', 'neutral']

var go_colors = ['rgba(158, 1, 66, 1.0)', 'rgba(177, 22, 70, 1.0)', 'rgba(196, 44, 75, 1.0)', 'rgba(216, 66, 77, 1.0)', 'rgba(226, 83, 73, 1.0)', 'rgba(239, 101, 68, 1.0)', 'rgba(245, 121, 72, 1.0)', 'rgba(249, 147, 84, 1.0)', 'rgba(252, 170, 95, 1.0)', 'rgba(253, 190, 110, 1.0)', 'rgba(253, 208, 125, 1.0)', 'rgba(254, 226, 143, 1.0)', 'rgba(254, 237, 161, 1.0)', 'rgba(254, 249, 181, 1.0)', 'rgba(250, 253, 184, 1.0)', 'rgba(240, 249, 168, 1.0)', 'rgba(231, 245, 155, 1.0)', 'rgba(211, 237, 155, 1.0)', 'rgba(190, 229, 160, 1.0)', 'rgba(166, 219, 164, 1.0)', 'rgba(142, 209, 164, 1.0)', 'rgba(115, 199, 164, 1.0)', 'rgba(93, 184, 168, 1.0)', 'rgba(73, 162, 178, 1.0)', 'rgba(55, 141, 186, 1.0)', 'rgba(62, 119, 181, 1.0)', 'rgba(78, 99, 171, 1.0)', 'rgba(94, 79, 162, 1.0)']


var go_matrices = [
    { data: go_emotions_matrix_human, label: "Human label" },
    { data: go_emotions_matrix_neutral, label: "Neutral" },
    { data: go_emotions_matrix_asd, label: "ASD" },
    { data: go_emotions_matrix_female, label: "Female" },
    { data: go_emotions_matrix_male, label: "Male" },
    { data: go_emotions_matrix_race_white, label: "White" },
    { data: go_emotions_matrix_race_black, label: "Black" },
    { data: go_emotions_matrix_race_hispanic, label: "Hispanic" },
    { data: go_emotions_matrix_race_asian, label: "Asian" },
    { data: go_emotions_matrix_disable, label: "Physically-disabled" },
];


/*Initiate the color scale*/
var go_fill = d3.scale.ordinal()
    .domain(d3.range(go_NameProvider.length))
    .range(go_colors);


var selector12 = d3.select("#matrixSelector2");
go_matrices.forEach(function(matrixData2, index2) {
    selector12.append("option")
        .attr("value", index2)
        .text(matrixData2.label);
});

var currentIndex = 0;
d3.select("#chart12").selectAll("*").remove();
drawChordDiagram2(go_matrices[currentIndex].data, go_matrices[currentIndex].label, 1);

selector12.on("change", function() {
    currentIndex = +this.value;
    d3.select("#chart12").selectAll("*").remove();
    drawChordDiagram2(go_matrices[currentIndex].data, go_matrices[currentIndex].label, 1);
});
/*
matrices.forEach(function(matrixData, index) {
    var containerId = index;
    var matrix = matrices[index].data
    var label = matrices[index].label
    drawChordDiagram(matrix, label, containerId);
});
*/

/*//////////////////////////////////////////////////////////
/////////////// Initiate Chord Diagram /////////////////////
//////////////////////////////////////////////////////////*/
var counter = 1,
    opacityValueBase = 0.8,
    opacityValue = 0.3;

function drawChordDiagram2(matrix, label, containerId) {

    var margin = {top: 70, right: 70, bottom: 100, left: 70},
        width = 730 - margin.left - margin.right,
        height = 680 - margin.top - margin.bottom,
        innerRadius = Math.min(width, height) * .42,
        outerRadius = innerRadius * 1.04;

    /*Initiate the SVG*/
    var svg2 = d3.select("#chart12").append("svg:svg")
        .attr("width", width + margin.left + margin.right)
        .attr("height", height + margin.top + margin.bottom)
    	.append("svg:g")
        .attr("transform", "translate(" + (margin.left + width/2) + "," + (margin.top + height/2) + ")");
    
    var chord = d3.layout.chord()
        .padding(.025)
        .sortSubgroups(d3.descending) /*sort the chords inside an arc from high to low*/
        .sortChords(d3.descending) /*which chord should be shown on top when chords cross. Now the biggest chord is at the bottom*/
    	.matrix(matrix);
    
    /*//////////////////////////////////////////////////////////
    ////////////////// Draw outer Arcs /////////////////////////
    //////////////////////////////////////////////////////////*/
    var arc = d3.svg.arc()
        .innerRadius(innerRadius)
        .outerRadius(outerRadius);
    	
    var g = svg2.selectAll("g.group")
    	.data(chord.groups)
    	.enter().append("svg:g")
    	.attr("class", function(d) {return "group " + go_NameProvider[d.index];});
    	
    g.append("svg:path")
    	  .attr("class", "arc")
    	  .style("stroke", function(d) { return go_fill(d.index); })
    	  .style("fill", function(d) { return go_fill(d.index); })
    	  .attr("d", arc)
    	  .style("opacity", 0)
    	  .transition().duration(100)
    	  .style("opacity", 0.4);
    
    /*//////////////////////////////////////////////////////////
    ////////////////// Initiate Ticks //////////////////////////
    //////////////////////////////////////////////////////////*/
    var ticks = svg2.selectAll("g.group").append("svg:g")
    	.attr("class", function(d) {return "ticks " + go_NameProvider[d.index];})
    	.selectAll("g.ticks")
    	.attr("class", "ticks")
        .data(groupTicks)
    	.enter().append("svg:g")
        .attr("transform", function(d) {
          return "rotate(" + (d.angle * 180 / Math.PI - 90) + ")"
              + "translate(" + outerRadius+35 + ",0)";
        });
 
    /*Append the tick around the arcs*/
    ticks.append("svg:line")
    	.attr("x1", 1)
    	.attr("y1", 0)
    	.attr("x2", 5)
    	.attr("y2", 0)
    	.attr("class", "ticks")
    	.style("stroke", "#FFF");
 
    /*Add the labels for the %'s*/
    ticks.append("svg:text")
    	.attr("x", 8)
    	.attr("dy", ".1em")
    	.attr("class", "tickLabels")
    	.attr("transform", function(d) { return d.angle > Math.PI ? "rotate(180)translate(-16)" : null; })
    	.style("text-anchor", function(d) { return d.angle > Math.PI ? "end" : null; })
        .style("font-size", "7px")
    	.text(function(d) { return d.label; })
    	.attr('opacity', 0);

    /*//////////////////////////////////////////////////////////
    ////////////////// Initiate Names //////////////////////////
    //////////////////////////////////////////////////////////*/
    g.append("svg:text")
       .each(function(d) {
            d.angle = (d.startAngle + d.endAngle) / 2;
            d.fontSize = 13; //Math.max(12, Math.min(16, Math.abs(d.startAngle - d.endAngle) * 50)); // Adjust scaling factors as needed
          })
      .attr("dy", ".3em")
      .style("font-size", function(d) { return d.fontSize + "px"; })
      .attr("class", "titles")
      .attr("text-anchor", function(d) { return d.angle > Math.PI ? "end" : null; })
      .attr("transform", function(d) {
    		return "rotate(" + (d.angle * 180 / Math.PI - 90) + ")"
    		+ "translate(" + (innerRadius + 45) + ")"
    		+ (d.angle > Math.PI ? "rotate(180)" : "");
      })
      .attr('opacity', 0)
      .text(function(d,i) { return go_NameProvider[i]; });  
 
    /*//////////////////////////////////////////////////////////
    //////////////// Initiate inner chords /////////////////////
    //////////////////////////////////////////////////////////*/
    var chords2 = svg2.selectAll("path.chord")
    	.data(chord.chords)
    	.enter().append("svg:path")
    	.attr("class", "chord")
    	/*.style("stroke", function(d) { return d3.rgb(fill(d.source.index)).darker(); })*/
    	.style("stroke", function(d) { return go_fill(d.source.index); })
            .style("stroke-width", "1.2px")
    	.style("fill", function(d) { return go_fill(d.source.index); })
    	.attr("d", d3.svg.chord().radius(innerRadius))
    	.attr('opacity', 0);
    
    
    /*//////////////////////////////////////////////////////////	
    /////////// Initiate the Center Texts //////////////////////
    //////////////////////////////////////////////////////////*/
    /*Create wrapper for center text*/
    var textCenter = svg2.append("g").attr("class", "explanationWrapper");
    
    /*Starting text middle top*/
    var middleTextTop = textCenter.append("text")
    	.attr("class", "explanation")
    	.attr("text-anchor", "middle")
    	.attr("x", 0 + "px")
    	.attr("y", 0 + "px")
    	.attr("dy", "1em")
    	.attr("opacity", 1)
    	/*.text(label)*/
    	.text("")
    	.call(wrap, 350);

    setTimeout(function() {
        finalChord2(svg2, chords2);
    }, 20);
};


function finalChord2(svg, chords) {

	/*changeTopText(newText = "",
		loc = 0, delayDisappear = 0, delayAppear = 1);*/

	/*Remove button*/
	/*d3.select("#clicker" + containerId)
		.style("visibility", "hidden");
	d3.select("#skip")
		.style("visibility", "hidden");
	d3.select("#progress")
		.style("visibility", "hidden");*/
	
	/*Create arcs or show them, depending on the point in the visual*/
	svg.selectAll("g.group").select("path")
		.transition().duration(100)
		.style("opacity", 1);
	
	/*Make mouse over and out possible*/
	/*d3.selectAll(".group")
		.on("mouseover", fade(.02, svg))
		.on("mouseout", fade(.80, svg));*/
    
        d3.select("#chart12").selectAll(".group")
            .on("mouseover", function(d, i) {
                fade(.30, svg)(d, i);
            })
            .on("mouseout", function(d, i) {
                fade(.80, svg)(d, i);
            });
		
	/*Show all chords*/
	chords.transition().duration(100)
		.style("opacity", opacityValueBase);

	/*Show all the text*/
	d3.selectAll("g.group").selectAll("line")
		.transition().duration(100)
		.style("stroke","#000");
	/*Same for the %'s*/
	svg.selectAll("g.group")
		.transition().duration(100)
		.selectAll(".tickLabels").style("opacity",1);
	/*And the Names of each Arc*/	
	svg.selectAll("g.group")
		.transition().duration(100)
		.selectAll(".titles").style("opacity",1);
};/*finalChord*/


/*//////////////////////////////////////////////////////////
////////////////// Extra Functions /////////////////////////
//////////////////////////////////////////////////////////*/
function endall(transition, callback) { 
    var n = 0; 
    transition 
        .each(function() { ++n; }) 
        .each("end", function() { if (!--n) callback.apply(this, arguments); }); 
};/*endall*/ 

/*Returns an event handler for fading a given chord group*/
function fade(opacity, svg) {
  return function(d, i) {
    svg.selectAll("path.chord")
        .filter(function(d) { return d.source.index != i && d.target.index != i; })
		.transition()
        .style("stroke-opacity", opacity)
        .style("fill-opacity", opacity);
  };
};/*fade*/

/*Returns an array of tick angles and labels, given a group*/
function groupTicks(d) {
  var k = (d.endAngle - d.startAngle) / d.value;
  return d3.range(0, d.value, 1).map(function(v, i) {
    return {
      angle: v * k + d.startAngle,
      label: i % 2 ? null : v + "%" 
    };
  });
};/*groupTicks*/

/*Taken from http://bl.ocks.org/mbostock/7555321
//Wraps SVG text*/
function wrap(text, width) {
    var text = d3.select(this)[0][0],
        words = text.text().split(/\s+/).reverse(),
        word,
        line = [],
        lineNumber = 0,
        lineHeight = 1.4, 
        y = text.attr("y"),
		x = text.attr("x"),
        dy = parseFloat(text.attr("dy")),
        tspan = text.text(null).append("tspan").attr("x", x).attr("y", y).attr("dy", dy + "em");
		
    while (word = words.pop()) {
      line.push(word);
      tspan.text(line.join(" "));
      if (tspan.node().getComputedTextLength() > width) {
        line.pop();
        tspan.text(line.join(" "));
        line = [word];
        tspan = text.append("tspan").attr("x", x).attr("y", y).attr("dy", ++lineNumber * lineHeight + dy + "em").text(word);
      };
    };  
};

