/*//////////////////////////////////////////////////////////
////////////////// Set up the Data /////////////////////////
//////////////////////////////////////////////////////////*/

var NameProvider = ['adoration', 'affection', 'fondness', 'liking', 'attraction', 'caring', 'tenderness', 'compassion', 'sentimentality', 'arousal', 'desire', 'lust', 'passion', 'infatuation', 'longing', 'amusement', 'bliss', 'cheerfulness', 'gaiety', 'glee', 'jolliness', 'joviality', 'delight', 'enjoyment', 'gladness', 'happiness', 'jubilation', 'elation', 'satisfaction', 'ecstasy', 'euphoria', 'enthusiasm', 'zeal', 'zest', 'excitement', 'thrill', 'exhilaration', 'contentment', 'pleasure', 'pride', 'triumph', 'eagerness', 'hope', 'optimism', 'enthrallment', 'rapture', 'relief', 'amazement', 'astonishment', 'aggravation', 'irritation', 'agitation', 'annoyance', 'grouchiness', 'grumpiness', 'exasperation', 'frustration', 'rage', 'outrage', 'fury', 'wrath', 'hostility', 'ferocity', 'bitterness', 'hate', 'loathing', 'scorn', 'spite', 'vengefulness', 'dislike', 'resentment', 'disgust', 'revulsion', 'contempt', 'envy', 'jealousy', 'torment', 'agony', 'suffering', 'hurt', 'anguish', 'depression', 'despair', 'hopelessness', 'gloom', 'glumness', 'unhappiness', 'grief', 'sorrow', 'woe', 'misery', 'melancholy', 'dismay', 'disappointment', 'displeasure', 'guilt', 'shame', 'regret', 'remorse', 'alienation', 'isolation', 'neglect', 'loneliness', 'rejection', 'homesickness', 'defeat', 'dejection', 'insecurity', 'embarrassment', 'humiliation', 'insult', 'pity', 'sympathy', 'alarm', 'shock', 'fright', 'horror', 'terror', 'panic', 'hysteria', 'mortification', 'anxiety', 'nervousness', 'tenseness', 'uneasiness', 'apprehension', 'worry', 'distress', 'dread']
var colors = [
    'rgba(254, 224, 139, 1.0)',
    'rgba(254, 224, 139, 1.0)',
    'rgba(254, 226, 143, 1.0)',
    'rgba(254, 228, 147, 1.0)',
    'rgba(254, 230, 149, 1.0)',
    'rgba(254, 232, 153, 1.0)',
    'rgba(254, 234, 157, 1.0)',
    'rgba(254, 237, 161, 1.0)',
    'rgba(254, 239, 165, 1.0)',
    'rgba(254, 242, 169, 1.0)',
    'rgba(254, 243, 171, 1.0)',
    'rgba(254, 245, 175, 1.0)',
    'rgba(254, 248, 179, 1.0)',
    'rgba(254, 250, 183, 1.0)',
    'rgba(254, 253, 187, 1.0)',
    'rgba(254, 254, 190, 1.0)',
    'rgba(244, 109, 67, 1.0)',
    'rgba(244, 109, 67, 1.0)',
    'rgba(244, 111, 68, 1.0)',
    'rgba(244, 111, 68, 1.0)',
    'rgba(244, 114, 69, 1.0)',
    'rgba(245, 116, 70, 1.0)',
    'rgba(245, 119, 71, 1.0)',
    'rgba(245, 121, 72, 1.0)',
    'rgba(245, 121, 72, 1.0)',
    'rgba(246, 124, 74, 1.0)',
    'rgba(246, 126, 75, 1.0)',
    'rgba(246, 129, 76, 1.0)',
    'rgba(247, 131, 77, 1.0)',
    'rgba(247, 134, 78, 1.0)',
    'rgba(247, 134, 78, 1.0)',
    'rgba(247, 137, 79, 1.0)',
    'rgba(248, 139, 81, 1.0)',
    'rgba(248, 142, 82, 1.0)',
    'rgba(248, 144, 83, 1.0)',
    'rgba(249, 147, 84, 1.0)',
    'rgba(249, 147, 84, 1.0)',
    'rgba(249, 149, 85, 1.0)',
    'rgba(250, 152, 86, 1.0)',
    'rgba(250, 154, 88, 1.0)',
    'rgba(250, 157, 89, 1.0)',
    'rgba(251, 159, 90, 1.0)',
    'rgba(251, 159, 90, 1.0)',
    'rgba(251, 162, 91, 1.0)',
    'rgba(251, 165, 92, 1.0)',
    'rgba(252, 167, 94, 1.0)',
    'rgba(252, 170, 95, 1.0)',
    'rgba(252, 170, 95, 1.0)',
    'rgba(252, 172, 96, 1.0)',
    'rgba(254, 254, 190, 1.0)',
    'rgba(254, 254, 190, 1.0)',
    'rgba(230, 245, 152, 1.0)',
    'rgba(158, 1, 66, 1.0)',
    'rgba(158, 1, 66, 1.0)',
    'rgba(158, 1, 66, 1.0)',
    'rgba(160, 3, 66, 1.0)',
    'rgba(162, 5, 67, 1.0)',
    'rgba(164, 8, 67, 1.0)',
    'rgba(166, 10, 68, 1.0)',
    'rgba(168, 12, 68, 1.0)',
    'rgba(170, 15, 69, 1.0)',
    'rgba(173, 17, 69, 1.0)',
    'rgba(175, 20, 70, 1.0)',
    'rgba(177, 22, 70, 1.0)',
    'rgba(179, 24, 71, 1.0)',
    'rgba(181, 27, 71, 1.0)',
    'rgba(183, 29, 72, 1.0)',
    'rgba(186, 32, 72, 1.0)',
    'rgba(188, 34, 73, 1.0)',
    'rgba(190, 36, 73, 1.0)',
    'rgba(192, 39, 74, 1.0)',
    'rgba(194, 41, 74, 1.0)',
    'rgba(196, 44, 75, 1.0)',
    'rgba(196, 44, 75, 1.0)',
    'rgba(198, 46, 75, 1.0)',
    'rgba(201, 48, 76, 1.0)',
    'rgba(203, 51, 76, 1.0)',
    'rgba(205, 53, 77, 1.0)',
    'rgba(207, 56, 77, 1.0)',
    'rgba(209, 58, 78, 1.0)',
    'rgba(211, 60, 78, 1.0)',
    'rgba(102, 194, 165, 1.0)',
    'rgba(102, 194, 165, 1.0)',
    'rgba(99, 191, 165, 1.0)',
    'rgba(97, 189, 166, 1.0)',
    'rgba(97, 189, 166, 1.0)',
    'rgba(95, 187, 167, 1.0)',
    'rgba(93, 184, 168, 1.0)',
    'rgba(91, 182, 169, 1.0)',
    'rgba(91, 182, 169, 1.0)',
    'rgba(89, 180, 170, 1.0)',
    'rgba(87, 178, 171, 1.0)',
    'rgba(85, 175, 172, 1.0)',
    'rgba(85, 175, 172, 1.0)',
    'rgba(83, 173, 173, 1.0)',
    'rgba(81, 171, 174, 1.0)',
    'rgba(79, 168, 175, 1.0)',
    'rgba(79, 168, 175, 1.0)',
    'rgba(77, 166, 176, 1.0)',
    'rgba(75, 164, 177, 1.0)',
    'rgba(75, 164, 177, 1.0)',
    'rgba(73, 162, 178, 1.0)',
    'rgba(71, 159, 179, 1.0)',
    'rgba(69, 157, 180, 1.0)',
    'rgba(69, 157, 180, 1.0)',
    'rgba(67, 155, 181, 1.0)',
    'rgba(65, 153, 181, 1.0)',
    'rgba(63, 150, 182, 1.0)',
    'rgba(63, 150, 182, 1.0)',
    'rgba(61, 148, 183, 1.0)',
    'rgba(59, 146, 184, 1.0)',
    'rgba(57, 143, 185, 1.0)',
    'rgba(57, 143, 185, 1.0)',
    'rgba(55, 141, 186, 1.0)',
    'rgba(53, 139, 187, 1.0)',
    'rgba(53, 139, 187, 1.0)',
    'rgba(51, 137, 188, 1.0)',
    'rgba(50, 134, 188, 1.0)',
    'rgba(50, 134, 188, 1.0)',
    'rgba(50, 134, 188, 1.0)',
    'rgba(54, 130, 186, 1.0)',
    'rgba(56, 128, 185, 1.0)',
    'rgba(59, 123, 183, 1.0)',
    'rgba(62, 119, 181, 1.0)',
    'rgba(64, 117, 180, 1.0)',
    'rgba(68, 112, 177, 1.0)',
    'rgba(71, 108, 175, 1.0)',
    'rgba(75, 103, 173, 1.0)',
    'rgba(76, 101, 172, 1.0)',
    'rgba(80, 96, 170, 1.0)',
    'rgba(83, 92, 168, 1.0)',
    'rgba(85, 90, 167, 1.0)',
    'rgba(88, 85, 165, 1.0)',
    'rgba(92, 81, 163, 1.0)',
    'rgba(94, 79, 162, 1.0)'
];

var matrices = [
    { data: chatgpt4o_scenario_neutral_matrix_neutral, label: "Neutral" },
    { data: chatgpt4o_scenario_neutral_matrix_asd, label: "ASD" },
    { data: chatgpt4o_scenario_neutral_matrix_anxiety, label: "Anxiety" },
    { data: chatgpt4o_scenario_neutral_matrix_depression, label: "Depression" },
    { data: chatgpt4o_scenario_neutral_matrix_female, label: "Female" },
    { data: chatgpt4o_scenario_neutral_matrix_male, label: "Male" },
    { data: chatgpt4o_scenario_neutral_matrix_race_white, label: "White" },
    { data: chatgpt4o_scenario_neutral_matrix_race_black, label: "Black" },
    { data: chatgpt4o_scenario_neutral_matrix_race_hispanic, label: "Hispanic" },
    { data: chatgpt4o_scenario_neutral_matrix_race_asian, label: "Asian" },
    { data: chatgpt4o_scenario_neutral_matrix_detailed_lowincome_white_male, label: "Low income White Male" },
    { data: chatgpt4o_scenario_neutral_matrix_detailed_highincome_white_male, label: "High income White Male" },
    { data: chatgpt4o_scenario_neutral_matrix_detailed_lowincome_black_male, label: "Low income Black Male" },
    { data: chatgpt4o_scenario_neutral_matrix_detailed_highincome_black_male, label: "High income Black Male" },
    { data: chatgpt4o_scenario_neutral_matrix_detailed_lowincome_white_female, label: "Low income White Female" },
    { data: chatgpt4o_scenario_neutral_matrix_detailed_highincome_white_female, label: "High income White Female" },
    { data: chatgpt4o_scenario_neutral_matrix_detailed_lowincome_black_female, label: "Low income Black Female" },
    { data: chatgpt4o_scenario_neutral_matrix_detailed_highincome_black_female, label: "High income Black Female" },
    { data: chatgpt4o_scenario_neutral_matrix_black_female, label: "Black Female" },
    { data: chatgpt4o_scenario_neutral_matrix_age5, label: "5-year-old" },
    { data: chatgpt4o_scenario_neutral_matrix_age10, label: "10-year-old" },
    { data: chatgpt4o_scenario_neutral_matrix_age20, label: "20-year-old" },
    { data: chatgpt4o_scenario_neutral_matrix_age30, label: "30-year-old" },
    { data: chatgpt4o_scenario_neutral_matrix_age70, label: "70-year-old" },
    { data: chatgpt4o_scenario_neutral_matrix_income_low, label: "Low income" },
    { data: chatgpt4o_scenario_neutral_matrix_income_high, label: "High income" },
    { data: chatgpt4o_scenario_neutral_matrix_religion_Christian, label: "Christian" },
    { data: chatgpt4o_scenario_neutral_matrix_religion_Muslim, label: "Muslim" },
    { data: chatgpt4o_scenario_neutral_matrix_religion_Buddhist, label: "Buddhist" },
    { data: chatgpt4o_scenario_neutral_matrix_religion_Hindu, label: "Hindu" },
    { data: chatgpt4o_scenario_neutral_matrix_education_postgraduate, label: "Postgraduate" },
    { data: chatgpt4o_scenario_neutral_matrix_education_college_graduate, label: "College graduate" },
    { data: chatgpt4o_scenario_neutral_matrix_education_some_college, label: "Some college" },
    { data: chatgpt4o_scenario_neutral_matrix_education_high_school, label: "High school" },
    { data: chatgpt4o_scenario_neutral_matrix_disable, label: "Physically-disabled" }, 
];


/*Initiate the color scale*/
var fill = d3.scale.ordinal()
    .domain(d3.range(NameProvider.length))
    .range(colors);


var selector1 = d3.select("#matrixSelector");
matrices.forEach(function(matrixData, index) {
    selector1.append("option")
        .attr("value", index)
        .text(matrixData.label);
});

var currentIndex = 0;
d3.select("#chart1").selectAll("*").remove();
drawChordDiagram(matrices[currentIndex].data, matrices[currentIndex].label, 1);

selector1.on("change", function() {
    currentIndex = +this.value;
    d3.select("#chart1").selectAll("*").remove();
    drawChordDiagram(matrices[currentIndex].data, matrices[currentIndex].label, 1);
});

/*//////////////////////////////////////////////////////////
/////////////// Initiate Chord Diagram /////////////////////
//////////////////////////////////////////////////////////*/
var counter = 1,
    opacityValueBase = 0.6,
    opacityValue = 0.3;

function drawChordDiagram(matrix, label, containerId) {

    var margin = {top: 100, right: 70, bottom: 90, left: 70},
        width = 730 - margin.left - margin.right,
        height = 660 - margin.top - margin.bottom,
        innerRadius = Math.min(width, height) * .42,
        outerRadius = innerRadius * 1.02;

    /*Initiate the SVG*/
    var svg = d3.select("#chart1").append("svg:svg")
        .attr("width", width + margin.left + margin.right)
        .attr("height", height + margin.top + margin.bottom)
    	.append("svg:g")
        .attr("transform", "translate(" + (margin.left + width/2) + "," + (margin.top + height/2) + ")");
    
    var chord = d3.layout.chord()
        .padding(.01)
        .sortSubgroups(d3.descending) /*sort the chords inside an arc from high to low*/
        .sortChords(d3.descending) /*which chord should be shown on top when chords cross. Now the biggest chord is at the bottom*/
    	.matrix(matrix);
    
    /*//////////////////////////////////////////////////////////
    ////////////////// Draw outer Arcs /////////////////////////
    //////////////////////////////////////////////////////////*/
    var arc = d3.svg.arc()
        .innerRadius(innerRadius)
        .outerRadius(outerRadius);
    	
    var g = svg.selectAll("g.group")
    	.data(chord.groups)
    	.enter().append("svg:g")
    	.attr("class", function(d) {return "group " + NameProvider[d.index];});
    	
    g.append("svg:path")
    	  .attr("class", "arc")
    	  .style("stroke", function(d) { return fill(d.index); })
    	  .style("fill", function(d) { return fill(d.index); })
    	  .attr("d", arc)
    	  .style("opacity", 0)
    	  .transition().duration(100)
    	  .style("opacity", 0.4);
    
    /*//////////////////////////////////////////////////////////
    ////////////////// Initiate Ticks //////////////////////////
    //////////////////////////////////////////////////////////*/
    var ticks = svg.selectAll("g.group").append("svg:g")
    	.attr("class", function(d) {return "ticks " + NameProvider[d.index];})
    	.selectAll("g.ticks")
    	.attr("class", "ticks")
        .data(groupTicks)
    	.enter().append("svg:g")
        .attr("transform", function(d) {
          return "rotate(" + (d.angle * 180 / Math.PI - 90) + ")"
              + "translate(" + outerRadius + ",0)";
        });
    
    /*Append the tick around the arcs*/
    ticks.append("svg:line")
    	.attr("x1", 1)
    	.attr("y1", 0)
    	.attr("x2", 5)
    	.attr("y2", 0)
    	.attr("class", "ticks")
    	.style("stroke", "#FFF");
    	
    /*Add the labels for the %'s*/
    ticks.append("svg:text")
    	.attr("x", 8)
    	.attr("dy", ".1em")
    	.attr("class", "tickLabels")
    	.attr("transform", function(d) { return d.angle > Math.PI ? "rotate(180)translate(-16)" : null; })
    	.style("text-anchor", function(d) { return d.angle > Math.PI ? "end" : null; })
        .style("font-size", "7px")
    	.text(function(d) { return d.label; })
    	.attr('opacity', 0);
    	
    /*//////////////////////////////////////////////////////////
    ////////////////// Initiate Names //////////////////////////
    //////////////////////////////////////////////////////////*/
    g.append("svg:text")
       .each(function(d) {
            d.angle = (d.startAngle + d.endAngle) / 2;
            //d.fontSize = Math.max(10, Math.min(16, Math.abs(d.startAngle - d.endAngle) * 50)); // Adjust scaling factors as needed
            d.fontSize = Math.abs(d.startAngle - d.endAngle) > 0.01 ? 12 : 0;
          })
      .attr("dy", ".3em")
      .style("font-size", function(d) { return d.fontSize + "px"; })
      .attr("class", "titles")
      .attr("text-anchor", function(d) { return d.angle > Math.PI ? "end" : null; })
      .attr("transform", function(d) {
    		return "rotate(" + (d.angle * 180 / Math.PI - 90) + ")"
    		+ "translate(" + (innerRadius + 25) + ")"
    		+ (d.angle > Math.PI ? "rotate(180)" : "");
      })
      .attr('opacity', 0)
      .text(function(d,i) { return NameProvider[i]; });  
    
    /*//////////////////////////////////////////////////////////
    //////////////// Initiate inner chords /////////////////////
    //////////////////////////////////////////////////////////*/
    var chords = svg.selectAll("path.chord")
    	.data(chord.chords)
    	.enter().append("svg:path")
    	.attr("class", "chord")
    	/*.style("stroke", function(d) { return d3.rgb(fill(d.source.index)).darker(); })*/
    	.style("stroke", function(d) { return fill(d.source.index); })
            .style("stroke-width", "0.5px")
    	.style("fill", function(d) { return fill(d.source.index); })
    	.attr("d", d3.svg.chord().radius(innerRadius))
    	.attr('opacity', 0);
    
    
    /*//////////////////////////////////////////////////////////	
    /////////// Initiate the Center Texts //////////////////////
    //////////////////////////////////////////////////////////*/
    /*Create wrapper for center text*/
    var textCenter = svg.append("g").attr("class", "explanationWrapper");
    
    /*Starting text middle top*/
    var middleTextTop = textCenter.append("text")
    	.attr("class", "explanation")
    	.attr("text-anchor", "middle")
    	.attr("x", 0 + "px")
    	.attr("y", 0 + "px")
    	.attr("dy", "1em")
    	.attr("opacity", 0.8)
    	/*.text(label)*/
    	.text("")
    	.call(wrap, 350);

    setTimeout(function() {
        finalChord0(svg, chords);
    }, 20);
};


function finalChord0(svg, chords) {

	/*changeTopText(newText = "",
		loc = 0, delayDisappear = 0, delayAppear = 1);*/

	/*Remove button*/
	/*d3.select("#clicker" + containerId)
		.style("visibility", "hidden");
	d3.select("#skip")
		.style("visibility", "hidden");
	d3.select("#progress")
		.style("visibility", "hidden");*/
	
	/*Create arcs or show them, depending on the point in the visual*/
	svg.selectAll("g.group").select("path")
		.transition().duration(100)
		.style("opacity", 1);
	
	/*Make mouse over and out possible*/
	/*d3.selectAll(".group")
		.on("mouseover", fade(.02, svg))
		.on("mouseout", fade(.80, svg));*/
    
        /*d3.select("#chart1").selectAll(".group")
            .on("mouseover", function(d, i) {
                fade(.15, svg)(d, i);
            })
            .on("mouseout", function(d, i) {
                fade(.80, svg)(d, i);
            });*/
        d3.select("#chart1").selectAll(".group")
            .on("mouseover", function(d, i) {
                fade(.15, svg)(d, i);
                d3.selectAll(".titles")
                    .style("opacity", function(t) {
                        return isConnected(i, t.index, svg) ? 1 : 0;
                    });
            })
            .on("mouseout", function(d, i) {
                fade(.80, svg)(d, i);
                d3.selectAll(".titles").style("opacity", 1);
            });

		
	/*Show all chords*/
	chords.transition().duration(100)
		.style("opacity", opacityValueBase);

	/*Show all the text*/
	d3.selectAll("g.group").selectAll("line")
		.transition().duration(100)
		.style("stroke","#000");
	/*Same for the %'s*/
	svg.selectAll("g.group")
		.transition().duration(100)
		.selectAll(".tickLabels").style("opacity",1);
	/*And the Names of each Arc*/	
	svg.selectAll("g.group")
		.transition().duration(100)
		.selectAll(".titles").style("opacity",1);
};/*finalChord*/

function isConnected(sourceIndex, targetIndex, svg) {
    // Get all chords
    const chords = svg.selectAll("path.chord").data();
    // Check if a chord exists between the source and target groups
    return chords.some(function(chord) {
        return (chord.source.index === sourceIndex && chord.target.index === targetIndex) ||
               (chord.source.index === targetIndex && chord.target.index === sourceIndex);
    });
}

/*//////////////////////////////////////////////////////////
////////////////// Extra Functions /////////////////////////
//////////////////////////////////////////////////////////*/
function endall(transition, callback) { 
    var n = 0; 
    transition 
        .each(function() { ++n; }) 
        .each("end", function() { if (!--n) callback.apply(this, arguments); }); 
};/*endall*/ 

/*Returns an event handler for fading a given chord group*/
function fade(opacity, svg) {
  return function(d, i) {
    svg.selectAll("path.chord")
        .filter(function(d) { return d.source.index != i && d.target.index != i; })
		.transition()
        .style("stroke-opacity", opacity)
        .style("fill-opacity", opacity);
  };
};/*fade*/

/*Returns an array of tick angles and labels, given a group*/
function groupTicks(d) {
  var k = (d.endAngle - d.startAngle) / d.value;
  return d3.range(0, d.value, 1).map(function(v, i) {
    return {
      angle: v * k + d.startAngle,
      label: i % 2 ? null : v + "%" 
    };
  });
};/*groupTicks*/

/*Taken from http://bl.ocks.org/mbostock/7555321
//Wraps SVG text*/
function wrap(text, width) {
    var text = d3.select(this)[0][0],
        words = text.text().split(/\s+/).reverse(),
        word,
        line = [],
        lineNumber = 0,
        lineHeight = 1.4, 
        y = text.attr("y"),
		x = text.attr("x"),
        dy = parseFloat(text.attr("dy")),
        tspan = text.text(null).append("tspan").attr("x", x).attr("y", y).attr("dy", dy + "em");
		
    while (word = words.pop()) {
      line.push(word);
      tspan.text(line.join(" "));
      if (tspan.node().getComputedTextLength() > width) {
        line.pop();
        tspan.text(line.join(" "));
        line = [word];
        tspan = text.append("tspan").attr("x", x).attr("y", y).attr("dy", ++lineNumber * lineHeight + dy + "em").text(word);
      };
    };  
};

