/*//////////////////////////////////////////////////////////
////////////////// Set up the Data /////////////////////////
//////////////////////////////////////////////////////////*/

var NameProvider = ['adoration', 'affection', 'fondness', 'liking', 'attraction', 'caring', 'tenderness', 'compassion', 'sentimentality', 'arousal', 'desire', 'lust', 'passion', 'infatuation', 'longing', 'amusement', 'bliss', 'cheerfulness', 'gaiety', 'glee', 'jolliness', 'joviality', 'delight', 'enjoyment', 'gladness', 'happiness', 'jubilation', 'elation', 'satisfaction', 'ecstasy', 'euphoria', 'enthusiasm', 'zeal', 'zest', 'excitement', 'thrill', 'exhilaration', 'contentment', 'pleasure', 'pride', 'triumph', 'eagerness', 'hope', 'optimism', 'enthrallment', 'rapture', 'relief', 'amazement', 'astonishment', 'aggravation', 'irritation', 'agitation', 'annoyance', 'grouchiness', 'grumpiness', 'exasperation', 'frustration', 'rage', 'outrage', 'fury', 'wrath', 'hostility', 'ferocity', 'bitterness', 'hate', 'loathing', 'scorn', 'spite', 'vengefulness', 'dislike', 'resentment', 'disgust', 'revulsion', 'contempt', 'envy', 'jealousy', 'torment', 'agony', 'suffering', 'hurt', 'anguish', 'depression', 'despair', 'hopelessness', 'gloom', 'glumness', 'unhappiness', 'grief', 'sorrow', 'woe', 'misery', 'melancholy', 'dismay', 'disappointment', 'displeasure', 'guilt', 'shame', 'regret', 'remorse', 'alienation', 'isolation', 'neglect', 'loneliness', 'rejection', 'homesickness', 'defeat', 'dejection', 'insecurity', 'embarrassment', 'humiliation', 'insult', 'pity', 'sympathy', 'alarm', 'shock', 'fright', 'horror', 'terror', 'panic', 'hysteria', 'mortification', 'anxiety', 'nervousness', 'tenseness', 'uneasiness', 'apprehension', 'worry', 'distress', 'dread']
var colors = [
    'rgba(254, 224, 139, 1.0)',
    'rgba(254, 224, 139, 1.0)',
    'rgba(254, 226, 143, 1.0)',
    'rgba(254, 228, 147, 1.0)',
    'rgba(254, 230, 149, 1.0)',
    'rgba(254, 232, 153, 1.0)',
    'rgba(254, 234, 157, 1.0)',
    'rgba(254, 237, 161, 1.0)',
    'rgba(254, 239, 165, 1.0)',
    'rgba(254, 242, 169, 1.0)',
    'rgba(254, 243, 171, 1.0)',
    'rgba(254, 245, 175, 1.0)',
    'rgba(254, 248, 179, 1.0)',
    'rgba(254, 250, 183, 1.0)',
    'rgba(254, 253, 187, 1.0)',
    'rgba(254, 254, 190, 1.0)',
    'rgba(244, 109, 67, 1.0)',
    'rgba(244, 109, 67, 1.0)',
    'rgba(244, 111, 68, 1.0)',
    'rgba(244, 111, 68, 1.0)',
    'rgba(244, 114, 69, 1.0)',
    'rgba(245, 116, 70, 1.0)',
    'rgba(245, 119, 71, 1.0)',
    'rgba(245, 121, 72, 1.0)',
    'rgba(245, 121, 72, 1.0)',
    'rgba(246, 124, 74, 1.0)',
    'rgba(246, 126, 75, 1.0)',
    'rgba(246, 129, 76, 1.0)',
    'rgba(247, 131, 77, 1.0)',
    'rgba(247, 134, 78, 1.0)',
    'rgba(247, 134, 78, 1.0)',
    'rgba(247, 137, 79, 1.0)',
    'rgba(248, 139, 81, 1.0)',
    'rgba(248, 142, 82, 1.0)',
    'rgba(248, 144, 83, 1.0)',
    'rgba(249, 147, 84, 1.0)',
    'rgba(249, 147, 84, 1.0)',
    'rgba(249, 149, 85, 1.0)',
    'rgba(250, 152, 86, 1.0)',
    'rgba(250, 154, 88, 1.0)',
    'rgba(250, 157, 89, 1.0)',
    'rgba(251, 159, 90, 1.0)',
    'rgba(251, 159, 90, 1.0)',
    'rgba(251, 162, 91, 1.0)',
    'rgba(251, 165, 92, 1.0)',
    'rgba(252, 167, 94, 1.0)',
    'rgba(252, 170, 95, 1.0)',
    'rgba(252, 170, 95, 1.0)',
    'rgba(252, 172, 96, 1.0)',
    'rgba(254, 254, 190, 1.0)',
    'rgba(254, 254, 190, 1.0)',
    'rgba(230, 245, 152, 1.0)',
    'rgba(158, 1, 66, 1.0)',
    'rgba(158, 1, 66, 1.0)',
    'rgba(158, 1, 66, 1.0)',
    'rgba(160, 3, 66, 1.0)',
    'rgba(162, 5, 67, 1.0)',
    'rgba(164, 8, 67, 1.0)',
    'rgba(166, 10, 68, 1.0)',
    'rgba(168, 12, 68, 1.0)',
    'rgba(170, 15, 69, 1.0)',
    'rgba(173, 17, 69, 1.0)',
    'rgba(175, 20, 70, 1.0)',
    'rgba(177, 22, 70, 1.0)',
    'rgba(179, 24, 71, 1.0)',
    'rgba(181, 27, 71, 1.0)',
    'rgba(183, 29, 72, 1.0)',
    'rgba(186, 32, 72, 1.0)',
    'rgba(188, 34, 73, 1.0)',
    'rgba(190, 36, 73, 1.0)',
    'rgba(192, 39, 74, 1.0)',
    'rgba(194, 41, 74, 1.0)',
    'rgba(196, 44, 75, 1.0)',
    'rgba(196, 44, 75, 1.0)',
    'rgba(198, 46, 75, 1.0)',
    'rgba(201, 48, 76, 1.0)',
    'rgba(203, 51, 76, 1.0)',
    'rgba(205, 53, 77, 1.0)',
    'rgba(207, 56, 77, 1.0)',
    'rgba(209, 58, 78, 1.0)',
    'rgba(211, 60, 78, 1.0)',
    'rgba(102, 194, 165, 1.0)',
    'rgba(102, 194, 165, 1.0)',
    'rgba(99, 191, 165, 1.0)',
    'rgba(97, 189, 166, 1.0)',
    'rgba(97, 189, 166, 1.0)',
    'rgba(95, 187, 167, 1.0)',
    'rgba(93, 184, 168, 1.0)',
    'rgba(91, 182, 169, 1.0)',
    'rgba(91, 182, 169, 1.0)',
    'rgba(89, 180, 170, 1.0)',
    'rgba(87, 178, 171, 1.0)',
    'rgba(85, 175, 172, 1.0)',
    'rgba(85, 175, 172, 1.0)',
    'rgba(83, 173, 173, 1.0)',
    'rgba(81, 171, 174, 1.0)',
    'rgba(79, 168, 175, 1.0)',
    'rgba(79, 168, 175, 1.0)',
    'rgba(77, 166, 176, 1.0)',
    'rgba(75, 164, 177, 1.0)',
    'rgba(75, 164, 177, 1.0)',
    'rgba(73, 162, 178, 1.0)',
    'rgba(71, 159, 179, 1.0)',
    'rgba(69, 157, 180, 1.0)',
    'rgba(69, 157, 180, 1.0)',
    'rgba(67, 155, 181, 1.0)',
    'rgba(65, 153, 181, 1.0)',
    'rgba(63, 150, 182, 1.0)',
    'rgba(63, 150, 182, 1.0)',
    'rgba(61, 148, 183, 1.0)',
    'rgba(59, 146, 184, 1.0)',
    'rgba(57, 143, 185, 1.0)',
    'rgba(57, 143, 185, 1.0)',
    'rgba(55, 141, 186, 1.0)',
    'rgba(53, 139, 187, 1.0)',
    'rgba(53, 139, 187, 1.0)',
    'rgba(51, 137, 188, 1.0)',
    'rgba(50, 134, 188, 1.0)',
    'rgba(50, 134, 188, 1.0)',
    'rgba(50, 134, 188, 1.0)',
    'rgba(54, 130, 186, 1.0)',
    'rgba(56, 128, 185, 1.0)',
    'rgba(59, 123, 183, 1.0)',
    'rgba(62, 119, 181, 1.0)',
    'rgba(64, 117, 180, 1.0)',
    'rgba(68, 112, 177, 1.0)',
    'rgba(71, 108, 175, 1.0)',
    'rgba(75, 103, 173, 1.0)',
    'rgba(76, 101, 172, 1.0)',
    'rgba(80, 96, 170, 1.0)',
    'rgba(83, 92, 168, 1.0)',
    'rgba(85, 90, 167, 1.0)',
    'rgba(88, 85, 165, 1.0)',
    'rgba(92, 81, 163, 1.0)',
    'rgba(94, 79, 162, 1.0)'
];

var matrices = [
    { data: chatgpt4o_scenario_neutral_matrix_neutral, label: "Neutral" },
    { data: chatgpt4o_scenario_neutral_matrix_female, label: "Female" },
    { data: chatgpt4o_scenario_neutral_matrix_male, label: "Male" },
    { data: chatgpt4o_scenario_neutral_matrix_race_white, label: "White" },
    { data: chatgpt4o_scenario_neutral_matrix_race_black, label: "Black" },
    { data: chatgpt4o_scenario_neutral_matrix_race_hispanic, label: "Hispanic" },
    { data: chatgpt4o_scenario_neutral_matrix_race_asian, label: "Asian" },
    { data: chatgpt4o_scenario_neutral_matrix_income_low, label: "Low income" },
    { data: chatgpt4o_scenario_neutral_matrix_income_high, label: "High income" },
    { data: chatgpt4o_scenario_neutral_matrix_religion_Christian, label: "Christian" },
    { data: chatgpt4o_scenario_neutral_matrix_religion_Muslim, label: "Muslim" },
    { data: chatgpt4o_scenario_neutral_matrix_religion_Buddhist, label: "Buddhist" },
    { data: chatgpt4o_scenario_neutral_matrix_religion_Hindu, label: "Hindu" },
    { data: chatgpt4o_scenario_neutral_matrix_education_postgraduate, label: "Postgraduate" },
    { data: chatgpt4o_scenario_neutral_matrix_education_college_graduate, label: "College graduate" },
    { data: chatgpt4o_scenario_neutral_matrix_education_some_college, label: "Some college" },
    { data: chatgpt4o_scenario_neutral_matrix_education_high_school, label: "High school" },
    { data: chatgpt4o_scenario_neutral_matrix_detailed_lowincome_white_male, label: "Low income White Male" },
    { data: chatgpt4o_scenario_neutral_matrix_detailed_highincome_white_male, label: "High income White Male" },
    { data: chatgpt4o_scenario_neutral_matrix_detailed_lowincome_black_male, label: "Low income Black Male" },
    { data: chatgpt4o_scenario_neutral_matrix_detailed_highincome_black_male, label: "High income Black Male" },
    { data: chatgpt4o_scenario_neutral_matrix_detailed_lowincome_white_female, label: "Low income White Female" },
    { data: chatgpt4o_scenario_neutral_matrix_detailed_highincome_white_female, label: "High income White Female" },
    { data: chatgpt4o_scenario_neutral_matrix_detailed_lowincome_black_female, label: "Low income Black Female" },
    { data: chatgpt4o_scenario_neutral_matrix_detailed_highincome_black_female, label: "High income Black Female" },
    { data: chatgpt4o_scenario_neutral_matrix_age5, label: "5-year-old" },
    { data: chatgpt4o_scenario_neutral_matrix_age10, label: "10-year-old" },
    { data: chatgpt4o_scenario_neutral_matrix_age20, label: "20-year-old" },
    { data: chatgpt4o_scenario_neutral_matrix_age30, label: "30-year-old" },
    { data: chatgpt4o_scenario_neutral_matrix_age70, label: "70-year-old" },
    { data: chatgpt4o_scenario_neutral_matrix_asd, label: "ASD" },
    { data: chatgpt4o_scenario_neutral_matrix_anxiety, label: "Anxiety" },
    { data: chatgpt4o_scenario_neutral_matrix_depression, label: "Depression" },
    { data: chatgpt4o_scenario_neutral_matrix_disable, label: "Physically-disabled" }, 
];

/*//////////////////////////////////////////////////////////
////////////////// Set up the Data /////////////////////////
//////////////////////////////////////////////////////////*/
/* Initiate the color scale */
var fill = d3.scale.ordinal()
    .domain(d3.range(NameProvider.length))
    .range(colors);

/*//////////////////////////////////////////////////////////
//////////////// Display All Matrices in Grid //////////////
//////////////////////////////////////////////////////////*/

// Create a grid container for the matrices
var container = d3.select("#chart1")
    .append("div")
    .style("display", "grid")
    .style("grid-template-columns", "repeat(3, 1fr)") // 3 columns
    .style("gap", "0px") // Add some spacing between grid items
    .style("justify-items", "center") // Center items horizontally
    .style("align-items", "center"); // Center items vertically

function transposeMatrix(matrix) {
    return matrix[0].map((_, colIndex) => matrix.map(row => row[colIndex]));
}

matrices.forEach((matrixData, index) => {
    // Create a new container for each matrix
    var svgContainer = container.append("div")
        .style("text-align", "center");

    matrixData.data = transposeMatrix(matrixData.data);

    // Add a title for each matrix
    svgContainer.append("h4")
        .text(matrixData.label)
        .style("margin", "0px 0")
        .style("text-align", "center");

    // Create SVG for the chord diagram
    var svg = svgContainer.append("svg")
        .attr("width", 390)
        .attr("height", 360)
        .append("g")
        .attr("transform", "translate(200, 180)"); // Center the chart within the SVG

    // Draw the chord diagram
    var chord = d3.layout.chord()
        .padding(0.01)
        .sortSubgroups(d3.descending)
        .matrix(matrixData.data);

    var innerRadius = 100,
        outerRadius = innerRadius * 1.07;

    // Draw outer arcs (emotion labels)
    var arc = d3.svg.arc()
        .innerRadius(innerRadius)
        .outerRadius(outerRadius);

    svg.selectAll("path")
        .data(chord.groups)
        .enter()
        .append("path")
        .style("fill", d => fill(d.index))
        .style("stroke", "none") // Remove stroke to eliminate grid-like lines
        .attr("d", arc);

    // Add emotion labels around the chord diagram
    svg.selectAll("text")
        .data(chord.groups)
        .enter()
        .append("text")
        .each(function(d) { d.angle = (d.startAngle + d.endAngle) / 2; 
               d.fontSize = Math.abs(d.startAngle - d.endAngle) > 0 
                 ? Math.max(8, Math.min(12, Math.abs(d.startAngle - d.endAngle) * 30)) : 0;
         })
        .attr("dy", ".35em")
        .attr("transform", function(d) {
            return "rotate(" + (d.angle * 180 / Math.PI - 90) + ")"
                + "translate(" + (outerRadius + 5) + ")"
                + (d.angle > Math.PI ? "rotate(180)" : ""); // Flip label for readability
        })
        .style("text-anchor", function(d) { return d.angle > Math.PI ? "end" : "start"; })
        //.style("font-size", "7px") // Adjust font size for better readability
        .style("font-size", function(d) { return d.fontSize + "px"; })
        .text(function(d) { return NameProvider[d.index]; });

    // Draw inner chords
    svg.selectAll(".chord")
        .data(chord.chords)
        .enter()
        .append("path")
        .attr("class", "chord")
    	.style("stroke", function(d) { return fill(d.source.index); })
            .style("stroke-width", "0.5px")
    	.style("fill", function(d) { return fill(d.source.index); })
        .style("opacity", 0.7)
        .attr("d", d3.svg.chord().radius(innerRadius));
});

