#include <stdio.h>
#include <stdlib.h>
#include <papi.h>

int EventSet = PAPI_NULL;
long long values[1];

// Initialize the PAPI library, Create the Event Set, and Add events
void initializePAPI(int event) {
    // Initialize the PAPI library
    if (PAPI_library_init(PAPI_VER_CURRENT) != PAPI_VER_CURRENT) {
        fprintf(stderr, "PAPI init error!\n");
        exit(1);
    }

    // Create the Event Set
    if (PAPI_create_eventset(&EventSet) != PAPI_OK) {
        fprintf(stderr, "Error creating event set.\n");
        exit(1);
    }

    // Add the desired event
    if (PAPI_add_event(EventSet, event) != PAPI_OK) {
        fprintf(stderr, "Error adding event.\n");
        exit(1);
    }
}

// Start counting the event
void startCounting() {
    if (PAPI_start(EventSet) != PAPI_OK) {
        fprintf(stderr, "Error starting the counters.\n");
        exit(1);
    }
}

// Stop the event, read the value, and reset
long long stopAndRead() {
    if (PAPI_stop(EventSet, values) != PAPI_OK) {
        fprintf(stderr, "Error stopping the counters.\n");
        exit(1);
    }

    long long result = values[0];
  
    printf("PAPI_SP_OPS: %lld\n", values[0]);

    if (PAPI_reset(EventSet) != PAPI_OK) {
        fprintf(stderr, "Error resetting the counters.\n");
        exit(1);
    }

    return result;
}

// Cleanup: Destroy the event set
void cleanupPAPI() {
    if (PAPI_destroy_eventset(&EventSet) != PAPI_OK) {
        fprintf(stderr, "Error destroying event set.\n");
        exit(1);
    }
}

int main() {
    initializePAPI(PAPI_SP_OPS);
    startCounting();

    float sum = 0.0f;
    for (int i = 0; i < 1000000; i++) {
        sum += 0.1f * i;
    }

    stopAndRead();
    cleanupPAPI();

    return 0;
}
