set -e
IDLE_TIMEOUT_ON=${1:-"False"}

echo "start .9n_das_start_train.sh"
if [ -f $WORKSPACE/.kube/$PROJECT_NAME/.prepare.sh ];then
    echo "start exec prepare.sh"
    /bin/bash $WORKSPACE/.kube/$PROJECT_NAME/.prepare.sh "" $PROJECT_NAME $BEE_USER "False" "cfs"  
else
    echo "$WORKSPACE/.kube/$PROJECT_NAME/.prepare.sh not found!"
    exit -1
fi
if [ "$IDLE_TIMEOUT_ON"x = "True"x ]; then
echo "******* IDLE_TIMEOUT is ON*******"
set +e;
fi
if [ "$PS_SERVER" != "" ];then
    wget -P $WORKSPACE $PS_SERVER 
    sudo tar -xvf $WORKSPACE/ps_server.tar.gz -p -s -C $WORKSPACE/
    sudo chmod 777 $WORKSPACE/ps_server
    sudo chmod 777 $WORKSPACE/ps_server/*
fi

if [ "$ROLE_TYPE" == "ps9n" ];then
    wget -P $WORKSPACE https://9n-das-packages.s3-internal.cn-north-1.jdcloud-oss.com/scripts/start_filebeat.sh
    cd $WORKSPACE && chmod +x start_filebeat.sh && ./start_filebeat.sh 
fi

echo "start .start_train.sh"
if [[ -z "${MY_POD_NAME}" ]];  then
    /bin/bash $WORKSPACE/.kube/$PROJECT_NAME/.start_train.sh $WORKSPACE $HOSTNAME
else
    /bin/bash $WORKSPACE/.kube/$PROJECT_NAME/.start_train.sh $WORKSPACE $MY_POD_NAME
fi
finishCode=$?

if [ "$IDLE_TIMEOUT_ON"x = "False"x ]; then
echo "******* train finish code is ${finishCode} "
exit $finishCode
fi

echo "******* train finish code is ${finishCode} ,report_server=${REPORT_SERVER}, role_type=$ROLE_TYPE***********"
while true;
do
    sleep $(((RANDOM%10)+1));
    UPDATED_TIME=$(TZ='Asia/Shanghai' date +'%Y-%m-%d %T')
    curl -X POST "http://${REPORT_SERVER}/v1/jobs/podfinishreport/${PROJECT_NAME}" \
    -H "Content-Type: application/json; charset='utf-8'" -H "Authorization:Basic $USER_TOKEN" \
    -d "{\"role_type\": \"$ROLE_TYPE\", \"pod_name\": \"$HOSTNAME\", \"job_name\": \"$PROJECT_NAME\", \"updated_time\": \"$UPDATED_TIME\", \"finish_code\": ${finishCode}}";    returnCode=$?;
    echo "******* report code is ${returnCode} ***********"
    if [ $returnCode == 0 ]; then
        break;
    fi;
done
echo "Thread exit with code:$finishCode" >> /export/App/training_platform/PinoModel/logs/${HOSTNAME}

# start running expire monitor script
echo "Start running expire monitor..."
wget -O - https://9n-das-bin.s3-internal.cn-north-1.jdcloud-oss.com/src/v1.0/expire_monitor.sh | bash

# exit as finishCode after sleeping
exit $finishCode
