#!/bin/bash
unset TMOUT
baseDir=$(dirname $0)
WORKSPACE=${1:-"/export/App/training_platform/PinoModel"}
UNINAME=${2:-$PROJECT_NAME}
USERNAME=${3:-$BEE_USER}
ISJDOS=${4}
MFSB=${5}
#sudo /usr/sbin/sshd
ROOT_DIR='/media/cfs'

# prepare hadoop env
/bin/bash $WORKSPACE/.kube/$PROJECT_NAME/.prepare_hadoop_env.sh

if [ -d "${WORKSPACE}/lost+found" ]; then
    sudo rm -rf ${WORKSPACE}/lost+found
fi

if [ ! -d $WORKSPACE ];then
    sudo mkdir -p -m 777 $WORKSPACE
fi
sudo chmod -R 777 $WORKSPACE

# soft link
sudo mkdir -p /opt/storage/
sudo mkdir -p ${ROOT_DIR}/

sudo rm -rf /opt/storage/${USERNAME}
sudo rm -rf ${ROOT_DIR}/${USERNAME}
sudo rm -rf ${ROOT_DIR}/${GROUP_NAME}

sudo ln -s /home/${USERNAME} /opt/storage/${USERNAME}
sudo ln -s /home/${USERNAME} ${ROOT_DIR}/${USERNAME}
sudo ln -s /home/${GROUP_NAME} ${ROOT_DIR}/${GROUP_NAME}

# models and logs dir
cloud_path=/opt/storage/${USERNAME}/9n-das-outputs/${UNINAME}

if [ ! -d "${cloud_path}/models" ];then
    sudo mkdir -p -m 777 ${cloud_path}/models
fi

if [ -d "${WORKSPACE}/models" ]; then
    sudo rm -rf ${WORKSPACE}/models
fi
sudo ln -s ${cloud_path}/models ${WORKSPACE}/models

if [ ! -d "${cloud_path}/logs" ];then
    sudo mkdir -p -m 777 ${cloud_path}/logs
fi

if [ -d "${WORKSPACE}/logs" ]; then
    sudo rm -rf ${WORKSPACE}/logs
fi
sudo ln -s ${cloud_path}/logs ${WORKSPACE}/logs


sudo chmod 777 /home
sudo chmod 777 /home/${USERNAME}
sudo chmod 777 /home/${USERNAME}/9n-das-outputs

P=/home/${USERNAME}/9n-das-outputs
for f in `sudo ls $P`; do
    if [ -d $P/$f ]; then
        touch "$P/$f/.chk_permission~" >/dev/null 2>&1 || sudo chmod 777 -R $P/$f >/dev/null 2>&1;
    fi;
done
if [ -d /home/${USERNAME}/.ssh ]; then
    sudo chmod 700 /home/${USERNAME}/.ssh
    sudo chmod 600 /home/${USERNAME}/.ssh/*
    sudo chmod 700 /home/${USERNAME}/.ssh/.
    sudo chmod 700 /home/${USERNAME}/.ssh/..
fi;

