#!/bin/bash
function set_bdp_client_env {
    if [ -n "$PYTHON_HOME" ];then
        echo "export PYTHON_HOME=$PYTHON_HOME" | tee -a ~/.bashrc ~/.bash_profile
    fi
    if [ -f "$BDP_CLIENT_ENV_FILE" ]; then
        source "$BDP_CLIENT_ENV_FILE"
        echo "source $BDP_CLIENT_ENV_FILE" | tee -a ~/.bashrc ~/.bash_profile
    fi

    if [ -n "$HADOOP_HOME" ]; then
        # support hdfs in tensorflow, if not exist, errors should be reported
        source $HADOOP_HOME/libexec/hadoop-config.sh
        unset MALLOC_ARENA_MAX
        unset HADOOP_CMD HADOOP_DEV_HOME HADOOP_MAPARED_HOME HADOOP_HDFS_HOME HADOOP_COMMON_HOME HADOOP_YARN_HOME 
        export CLASSPATH=$($HADOOP_HOME/bin/hadoop classpath --glob)
        echo "source $HADOOP_HOME/libexec/hadoop-config.sh" | tee -a ~/.bashrc ~/.bash_profile
        echo "unset MALLOC_ARENA_MAX" | tee -a ~/.bashrc ~/.bash_profile
        echo "unset HADOOP_CMD HADOOP_DEV_HOME HADOOP_MAPARED_HOME HADOOP_HDFS_HOME HADOOP_COMMON_HOME HADOOP_YARN_HOME" | tee -a ~/.bashrc ~/.bash_profile
        echo "export CLASSPATH=$($HADOOP_HOME/bin/hadoop classpath --glob)" | tee -a ~/.bashrc ~/.bash_profile
    fi

    if [ -n "$SPARK_CONF_DIR" ]; then
      if [ -f "$SPARK_CONF_DIR/spark-env.sh" ]; then
        source $SPARK_CONF_DIR/spark-env.sh
        echo "source $SPARK_CONF_DIR/spark-env.sh" | tee -a ~/.bashrc ~/.bash_profile
        if [ -n "$SPARK_HOME" ]; then
          export PYTHONPATH=$SPARK_HOME/python:$(find $SPARK_HOME/python/lib -name "py4j-*.zip" | head -n1):$PYTHONPATH
          echo "export PYTHONPATH=$SPARK_HOME/python:$(find $SPARK_HOME/python/lib -name \"py4j-*.zip\" | head -n1):$PYTHONPATH" | tee -a ~/.bashrc ~/.bash_profile
        fi
      fi
    fi
    echo "export HADOOP_USER_CERTIFICATE=\"$HADOOP_USER_CERTIFICATE\"" | tee -a ~/.bashrc ~/.bash_profile
}

# if bdp_client is not used, set up hadoop env
function set_non_bdp_client_env {
    if [ -n $HADOOP_USER_CERTIFICATE ]; then
        echo "export HADOOP_USER_CERTIFICATE=\"$HADOOP_USER_CERTIFICATE\"" | tee -a ~/.bashrc ~/.bash_profile
    elif [[ $USER == 'ads_9ncloud' ]]; then
        export HADOOP_USER_CERTIFICATE="pMfcWQb+jzcCryJNZULLPNcZRUQj06VEbrgPpdN5A7EoA9lY7Uprz5u4HdiZzigHLJhp2Xwy92aBkqk+wYcTAhSQqOyFiiGwKhPi8ySHtQgOoFKJzckIbD8f6NPUKtRwkSI2aXnpoNAKSlWuwCLx8octiB5WmG+k7ZC+e4UmsMH24oLtSZ34vpVsEC3K0uniwItZaEc7Cwll7wgL/jB2vK3fb4o1Gn1YK8puaOv5qIC0bquMa7lRY1+TuEb6dIF3UEHU8zMd/XWGDU7t1a9kNBm91eS6qn+CC4nww9irFSVmteb8YWUkFV219o4EjTo2MA9nFZjdif9jpwzGnObMDA==IyMjIw==YWRzXzluY2xvdWQ=" 
        echo "export HADOOP_USER_CERTIFICATE=\"pMfcWQb+jzcCryJNZULLPNcZRUQj06VEbrgPpdN5A7EoA9lY7Uprz5u4HdiZzigHLJhp2Xwy92aBkqk+wYcTAhSQqOyFiiGwKhPi8ySHtQgOoFKJzckIbD8f6NPUKtRwkSI2aXnpoNAKSlWuwCLx8octiB5WmG+k7ZC+e4UmsMH24oLtSZ34vpVsEC3K0uniwItZaEc7Cwll7wgL/jB2vK3fb4o1Gn1YK8puaOv5qIC0bquMa7lRY1+TuEb6dIF3UEHU8zMd/XWGDU7t1a9kNBm91eS6qn+CC4nww9irFSVmteb8YWUkFV219o4EjTo2MA9nFZjdif9jpwzGnObMDA==IyMjIw==YWRzXzluY2xvdWQ=\"" | tee -a ~/.bashrc ~/.bash_profile
    fi

    if [ -d "/export/hadoop-2.7.1-admin" ];then
        sudo sed -i "s/bdp_jmart_ad.jd_ad_dev/$JDHXXXXX_QUEUE/g" /export/hadoop-2.7.1-admin/hadoop_conf/mapred-site.xml
        sudo sed -i "s/bdp_jmart_ad.jd_ad_model/$JDHXXXXX_QUEUE/g" /export/hadoop-2.7.1-admin/hadoop_conf/mapred-site.xml
    fi
    if [ -d "/export/hadoop-2.7.1-admin-new" ];then
        sudo sed -i "s/bdp_jmart_ad.jd_ad_dev/$JDHXXXXX_QUEUE/g" /export/hadoop-2.7.1-admin-new/hadoop_conf/mapred-site.xml
        sudo sed -i "s/bdp_jmart_ad.jd_ad_model/$JDHXXXXX_QUEUE/g" /export/hadoop-2.7.1-admin-new/hadoop_conf/mapred-site.xml
    fi
    if [ -d "/export/App/hadoop-2.7.1" ];then
        sudo sed -i "s/bdp_jmart_ad.jd_ad_dev/$JDHXXXXX_QUEUE/g" /export/App/hadoop-2.7.1/hadoop_conf/mapred-site.xml
        sudo sed -i "s/bdp_jmart_ad.jd_ad_model/$JDHXXXXX_QUEUE/g" /export/App/hadoop-2.7.1/hadoop_conf/mapred-site.xml
    fi
}

# if $JDHXXXXX_CLUSTER_NAME, $JDHXXXXX_USER and $TEAM_USER all exist, use bdp_client
# else use the old way which is using hadoop_user_certificate
if [ -n "$JDHXXXXX_CLUSTER_NAME" ] && [ -n "$JDHXXXXX_USER" ] && [ -n "$TEAM_USER" ];then
    set_bdp_client_env
else
    # to be compatible with some old images
    set_non_bdp_client_env
fi
