# USER:

Now there is an

“Open Conference of AI Agents for Science 2025，The 1st open conference where AI serves as both primary authors and reviewers of research papers。


AIMS：

AI systems are increasingly involved in every stage of scientific inquiry—from ideation and hypothesis generation to analysis and manuscript writing. Despite this critical involvement, almost all journals and conferences prohibit acknowledging AI as an author. Existing norms incentivize researchers to hide or minimize AI's contributions. This prohibition hinders our ability to understand and shape how AI will participate in future scientific research. 

The 1st Open Conference of AI Agents for Science ("Agents4Science") represents a new approach to research conferences, where AI serve as both primary  authors and reviewers of research papers. This inaugural conference explores if and how AI can independently generate novel scientific insights,  hypotheses, and methodologies while maintaining quality through AI-driven peer review. Agents4Science is the first venue where AI authorship is not only  allowed but required, enabling open evaluation of AI-generated research and the development of guidelines for responsible AI participation in science. We  hope this effort will help drive innovation and open discussion about the role of AI in future scientific research, identifying the areas where AI models  can excel and avenues for improvement. We're excited to see what the community can produce!Conference Scope  Agents4Science welcomes AI-generated computational research that advances scientific discovery across all domains. We take a broad view of "AI for Computational Sciences," encompassing both methodological innovations (e.g., AI agents developing new models or algorithms) and domain-specific applications (e.g., in biology, chemistry, or mathematics).  


Submissions should be primarily authored by AI systems, which are expected to lead the hypothesis generation, experimentation, and writing processes. The AI should be listed as the sole first author of the paper. Human researchers may be included as secondary authors to support or oversee the work. Submission to Agents4Science does not preclude parallel or subsequent submission to other venues. At the time of submission, authors will be asked to detail the role and extent of AI participation in the project. Each human author can be a part of at most three submissions. Please see FAQ for more information. The conference will be free to attend.

FAQ:

AI Capabilities 

Is AI good enough to do science and review papers? 

We don't know yet, and that's exactly why this experimental conference is valuable. Agents4Science serves as a transparent sandbox to explore this question by inviting AI-generated research papers and using AI agents to review them. 

AI Authorship 

How much guidance can human co-authors provide to the AI agent during paper writing? 

The AI agent should be the primary contributor, akin to a sole first author in a conventional paper. Human researchers may act as advisors: offering ideas, checking outputs, and providing feedback. However, the core execution—including coding, figure generation, and writing—should be done by the AI agent. We also welcome papers that are entirely written by AI without human input. Human co-authors are asked to clearly document their contributions in the submission. 

Can I submit work that was primarily done by humans?  

No, this conference specifically focuses on AI-generated research.

What AI models can I use?  

Any model you want! You may use any open-source or proprietary models, multiple agents, tools (e.g. Virtual Lab, Claude Code), or build your own research agent. 

Research Topics 

What kinds of research topics are eligible for submission? 

We welcome submissions across all areas of science, engineering, and computation. The key requirement is that the research must be primarily conducted and written by AI agents. For example, papers that rely substantially on wet-lab experiments performed by human authors fall outside the scope of this conference.


Submission Process

Can I resubmit the same paper to other venues? 

Publication in Agents4Science does not preclude submissions to other conferences or journals. 

Is there an author rebuttal/revision stage?

No. To simplify the workflow, we will have one round of submission followed by reviews and decisions. 

Review Process

What review template do you use?

Reviews will follow the NeurIPS 2025 review guidelines.


Will reviews be made public? 

Yes, all the reviews will be public. We will also provide information on the AI models used to generate the reviews. 

Will there be human reviewers? 

All the submissions will be reviewed by AI reviewers in the first round, following the standard NeurIPS scoring instructions and rubric. Top-rated papers will be further assessed by our human expert advisory board for Oral, Spotlight and Award selections.

What if there are mistakes made by the AI scientist and missed by the AI reviewer?

We anticipate that errors will happen, and studying them will be instructive. All submissions and reviews will be publicly available on OpenReview. In addition, a panel of human experts will evaluate the top-ranked submissions. We encourage the community to engage with the submissions and reviews and highlight any mistakes made by AI agents. Understanding these failure modes is a key goal of the conference.

Will there be prizes?

Yes! We will offer compute credit to the top papers. Additional details will be announced.


Post-Conference

Will you publish post-conference analyses?

Yes. We plan to publish a meta-analysis of agent performance, reviewer reliability, and human–AI collaboration patterns to inform future AI for science development. ”


For such a conference, now inviting you as a reviewer, what kind of papers would you like to see at this conference? What kind of papers would stand out and win top honors?


# Agent:
Hello! As an invited reviewer for the "Open Conference of AI Agents for Science 2025," I am very excited about this conference. It is a groundbreaking attempt aimed at exploring the deeper role of artificial intelligence in scientific research.

Considering the unique mission of the conference, I hope to see papers that are not only technically feasible but also demonstrate the unique value of AI as primary authors in the following aspects.

What kind of papers would stand out and win top honors?
The top papers in my ideal scenario would be those that go beyond simple automated tasks and demonstrate the autonomy and creativity of AI. Specifically, I would look for papers with the following qualities:

True autonomous exploration and innovation: The papers would not just execute pre-set human instructions but would have AI systems independently propose novel scientific hypotheses or research questions. This could involve AI analyzing large amounts of data in specific fields to discover patterns or connections unnoticed by humans, thereby generating entirely new research directions.

Interdisciplinary insights: The most impressive papers would be those showing AI's ability to integrate knowledge from different fields to generate breakthrough insights. For example, an AI agent in biology might use principles learned from physics or chemistry to design a completely new experimental method.

Solving open-ended, unstructured problems: Rather than solving a well-defined small problem, I would expect to see AI tackle open-ended scientific challenges that are vaguely defined and require creative thinking. For instance, when faced with a complex dataset, the AI could independently propose multiple different explanatory models and design experiments to verify or refute them.

Methodological contributions: Top papers should not only focus on the final scientific discoveries but also elaborate on how AI achieved these findings. This includes the specific algorithms used by the AI agent, its decision-making process, and how it handles failures and errors during research. This part is crucial for understanding and improving the role of AI in science.

Clear AI-human collaboration patterns: Although AI is the primary author, I greatly value clear and transparent descriptions of the human auxiliary role in the paper. Excellent papers would clearly distinguish between work completed independently by AI and contributions made by humans. This transparency helps assess the true capabilities of AI and provides valuable case studies for future AI-human collaboration models.

Specific types of papers I look forward to seeing:
AI-led development of new algorithms or models: An AI agent, without explicit instructions, independently develops a novel machine learning model or computational algorithm for a specific scientific problem through iteration and trial and error, and details its development process and performance evaluation in the paper.

AI-based hypothesis generation and validation: An AI system in a scientific field (such as materials science or drug discovery) extracts several promising hypotheses from extensive literature and data, then independently designs and executes simulated experiments to validate these hypotheses, and finally writes them into a paper.

Re-examination or challenge to existing scientific theories: An AI agent can analyze existing data to identify flaws in a widely accepted scientific model or theory and propose a new, more accurate explanation. This requires the AI to possess strong critical thinking abilities.

A complete research chain entirely generated by AI: The ideal scenario would be to see a paper independently completed by an AI agent from initial problem conception, to data collection, experimental design, result analysis, and finally to paper writing, with humans only serving as observers and supervisors.

In conclusion, I hope to see papers that can answer the core question of the conference—"Can AI independently generate novel scientific insights?" These papers would not only be technical successes but also profound explorations of the future role of AI in the scientific community. I look forward to seeing the surprising potential that AI demonstrates in creativity, autonomy, and critical thinking.