# python > 3.9
# pip install httpx[socks] google-genai
# https://ai.google.dev/gemini-api/docs/rate-limits#free-tier
# https://aistudio.google.com/apikey

import os
from google import genai
from google.genai import types

os.environ['GEMINI_API_KEY']='AIzaSyAK9JB8w_YBIKWthOwj-8RccUM72jHlfvs' 
os.environ['https_proxy']='http://127.0.0.1:7890'
os.environ['http_proxy']='http://127.0.0.1:7890'
os.environ['all_proxy']='socks5://127.0.0.1:7890 '

import glob
import pathlib
import time


def ask_gemini(i=0, file='file.pdf',output='summary.txt'):
    print(file)
    client = genai.Client()

    filepath = pathlib.Path(file)
    prompt = "你是一资深的AI研究员。这篇论文主要讲了什么内容？解决了一个什么样的问题？详细的方法是什么（必要时可以用公式说明）？进行了怎样的实验？帮我总结这篇论文，逐点思考，输出全部内容. "

    response = client.models.generate_content(
        model="gemini-2.5-flash-lite", 
        contents=[
      types.Part.from_bytes(
        data=filepath.read_bytes(),
        mime_type='application/pdf',
      ),
      prompt]
    )
    res = f"""# Paper {i+1} \n{file.split('.pdf')[0]}\n\n{response.text}\n\n\n\n"""

    with open(output, "a") as f:
        f.write(res)
    return 



if __name__ == '__main__':
    for i, ifile in enumerate(glob.glob('*.pdf')):
        if i<3:
            continue
        ask_gemini(i,ifile, output='summary.md')
        time.sleep(30)
