import networkx as nx
from infomap import Infomap


def InfomapLayers(G: nx.Graph):
    im = Infomap(silent=True)
    mapping = im.add_networkx_graph(G)
    im.run()
    res = []

    for node, modules in im.get_multilevel_modules(states=True).items():
        if len(res) < len(modules):
            res = [dict() for i in range(len(modules))]
        modules += (im.get_name(node),)
        # print(modules)
        for i in range(len(modules) - 1):
            if modules[i] not in res[i]:
                res[i][modules[i]] = set()
            res[i][modules[i]].add(modules[i + 1])
        # print(node, modules)

    res.insert(0, {'root': {k for k in res[0].keys()}})
    return res
