# Code and Evaluation Datasets

## To reproduce finetuning:
The directory `T5` contains the tasks needed to reproduce our finetuning objectives. The file `operative_config.gin` contains the full set of hyperparamters we used for finetuning T5-Large on the `FillBlankOrEnd` objective. The simplest way to reproduce our training objectives is to copy & paste the code from the provided `tasks.py` into the [Github version of this file](https://github.com/google-research/text-to-text-transfer-transformer/blob/master/t5/data/tasks.py) then follow the finetuning instructions located [here](https://github.com/google-research/text-to-text-transfer-transformer#fine-tuning).

It is very easy to finetune on datasets besides C4, so long as they are in [TFDS](https://www.tensorflow.org/datasets/catalog/overview#text). Simply replace the line `tfds_name="c4/en:3.0.1"` with your dataset of choice.

## To reproduce Amazon Mechanical Turk:
In the directory `amturk`, the file `amturk_task.html` has a jinja2 template of the task. Running `amturk_task.py` will render this template and output `amturk_task_rendered.html`. Finally, `HITs.csv` contains the examples we used for human evaluation.