import gym
import time
from gym.envs.registration import register
import argparse

from .binary_choice import *


def main():
    env = gym.make('MultiGrid-MiniBinaryChoice-v0')

    _ = env.reset()

    nb_agents = 1

    while True:
        env.render(mode='human', highlight=True)
        time.sleep(0.02)

        ac = [env.action_space.sample() for _ in range(nb_agents)]

        obs, r, done, _ = env.step(ac)

        if done:
            print('Received reward of', r)
            env.reset()

if __name__ == "__main__":
    main()