# Grounding Aleatoric Uncertainty in Unsupervised Environment Design

This codebase reproduces the experimental results in the paper "Grounding Aleatoric Uncertainty in Unsupervised Environment Design," submitted for review at ICLR 2022.. Instructions for reproducing the various experiments are detailed below.

## Set up

To install the necessary dependencies, run the following commands:

```
conda create --name samplr
conda activate samplr
pip install -r requirements.txt
git clone https://github.com/openai/baselines.git
cd baselines
pip install -e .
cd ..
cd minihack
pip install -e .
cd ..
```

## Experiments

For convenience, configuration json files are provided to generate the commands to run the specific experimental settings for each method featured in the main results. To generate the command to launch 1 run of the experiment codified by the configuration file `config.json` in the local folder `train_scripts/grid_configs`, simply run the following, and copy and paste the output into your command line. 
```shell
python train_scripts/make_cmd.py --json config --num_trials 1
```

Alternatively, you can run the following to copy the command directly to your clipboard:

```shell
python train_scripts/make_cmd.py --json config --num_trials 1 | pbcopy
```

By default, each experiment run will generate a folder in `~/logs/samplr` named after the `--xpid` argument passed into the the `train` command. This folder will contain log outputs in `logs.csv` and periodic screenshots of generated levels in the directory `screenshots`. Each screenshot uses the naming convention `update_<number of PPO updates>.png`. The latest model checkpoint will be output to `model.tar`, and archived model checkpoints are also saved according to the naming convention `model_<number of PPO updates>.tar`.

The json file for each running each method with the best hyperparameters settings is listed below:

### Stochastic fruit-choice experiments

| Method        | json config  |
| ------------- |:-------------|
| (LP)-SAMPLR| minihack/multiroom/multiroom_bc_n8_obl_plr.json|
| PLR<sup>⊥</sup> |  minihack/multiroom/multiroom_bc_n8_robust_plr.json|
| DR |  minihack/multiroom/multiroom_bc_n8.json |

### FireDungeon experiments
| Method        | json config  |
| ------------- |:-------------|
| (LP)-SAMPLR | minihack/firedungeon/dof_hunt_pro_obl_plr.json|
| PLR<sup>⊥</sup> | minihack/firedungeon/dof_hunt_pro_robust_plr.json|
| DR | minihack/firedungeon/dof_hunt_pro.json |


## Plotting

- `plot.py` generates line plots based on a set of xpid prefixes located in the `-r` directory path provided to the script.



