import gym
from .permissive_wrapper import PermissiveWrapper

class Seedable(PermissiveWrapper):
    def __init__(self, env):
        super().__init__(env)
        self._level_seed = 0 
        self.use_seed_list = self._check_use_seed_list()

    def _check_use_seed_list(self):
        return self.env.unwrapped.spec.id.startswith('MiniHack')

    def step(self, action):
        obs, r, done, info = super().step(action)
        info['level_seed'] = self.level_seed

        return obs, r, done, info

    def seed(self, level_seed):
        if self.use_seed_list:
            self.env._level_seeds = [level_seed]

        self._level_seed = level_seed
        super().seed(level_seed)

        return super().reset()

    @property
    def level_seed(self):
        return self._level_seed