set +e
gpu_ids=${1:-"0,1,2"}
gpu_buffer=${2:-"2960"}
target_dir="./EXP/summe_tvsum"
pt_ckpt="./checkpoint/visp_default_e200_b32.pt"
file_to_save_finetune="$target_dir/res_best.txt"
pt_datasets="SumMe,TVSum"

for dropout in 0.1 0.2 0.3 0.4 0.5 0.6; do
    for epoch in 100 120 200; do
        command_to_run="python post_train.py --pt_ckpt_path $pt_ckpt --epochs $epoch --repeat 10 --result_path $file_to_save_finetune --Dropout_ratio $dropout"
        bash ./scripts/run_cmd_when_gpu_free.sh  "$gpu_ids"  "$command_to_run" "120" "$gpu_buffer"
    done 
done
