set +e
gpu_ids=${1:-"0,1,2,3,4,5"} # gpu_ids="0,1,2,3,4,5,6,7"  
python=${2:-"python"}
retry_interval=${3:-"60"} 
pt_datasets="SumMe,TVSum"
target_dir="./EXP/summe_tvsum/pt_ckpt"

# Prepare GPU array
IFS=',' read -ra gpu_array <<< "$gpu_ids"

echo "Pretrain from scratch..."
for batch_size in 32; do
    for dropout in 0.2 0.4 0.6; do
        for rand_neg in "false" "true"; do
            for coef_ent in 5 0.1 100 0.01 0.001; do
                for coff_size in 100 10 1 0.1 0.01; do
                    for tau in 0.5 0.05 5; do
                        command_to_run="$python pre_train.py --mask_type zero --read_out cls --act sigmoidConcreteSoft --rand_neg $rand_neg --batch_size $batch_size \
                        --pt_datasets $pt_datasets --pt_ckpt_dir $target_dir  \
                        --epochs 200 --coef_ent $coef_ent --coff_size $coff_size --tau $tau  --Dropout_ratio $dropout"
                        bash ./scripts/run_cmd_when_gpu_free.sh  "$gpu_ids"  "$command_to_run" "$retry_interval" "50000"
                    done
                    command_to_run="$python pre_train.py --mask_type zero --read_out cls --act sigmoidSoft --rand_neg $rand_neg --batch_size $batch_size \
                    --pt_datasets $pt_datasets --pt_ckpt_dir $target_dir  \
                    --epochs 200 --coef_ent $coef_ent --coff_size $coff_size --tau 0  --Dropout_ratio $dropout"
                    bash ./scripts/run_cmd_when_gpu_free.sh  "$gpu_ids"  "$command_to_run" "$retry_interval" "50000"
                done
            done
        done
    done
done

echo "Finetune from scratch..."
pt_files=$(find "$target_dir" -type f -name "*.pt")
file_to_save_finetune="$target_dir/res_repeat.txt"
for dropout in 0.1 0.2 0.3 0.4 0.5 0.6; do
    for file in $pt_files; do
        echo $file
        command_to_run="$python post_train.py --pt_ckpt_path $file --epochs 100 --repeat 10 --result_path $file_to_save_finetune  --Dropout_ratio $dropout --skip_files $target_dir/res_repeat.txt"
        bash ./scripts/run_cmd_when_gpu_free.sh  "$gpu_ids"  "$command_to_run" "$retry_interval" 10960
    done
done